\name{splitDFstrings}
\alias{splitDFstrings}
\title{A function to split vector strings in a data.frame}
\description{
  Given a data.frame and a set of fields, will take any "string of
  strings" (e.g. "foo, blah, bar") and split them into a vector of strings
  (e.g. c("foo", "blah", "bar")).
}
\usage{
splitDFstrings(df, fields, delim = ",[[:space:]]*")
}
\arguments{
  \item{df}{A data.frame}
  \item{fields}{Set of columns (fields) to split}
  \item{delim}{Delimiter to split on.  Default is ", "}
}
\value{
  The data.frame with the specified columns appropriately manipulated.
}
\author{Jeff Gentry}
\examples{
   a <- data.frame(I("foo, blah"))
   colnames(a) <- "bar"
   a
   splitDFstrings(a,"bar")
   a$bar
}
\keyword{utilities}
