\name{parseThemesXML}
\alias{parseThemesXML}
\title{A function to read repository theme XML}
\description{
  This function will read in a repository theme XML file and output a
  RDA file with a list of \code{\link{reposTheme}} objects specifying
  the themes for a repository.
}
\usage{
parseThemesXML(repTXML = "repThemes.xml", repTrda = "repThemes.rda", repDrda = "repdatadesc.rda")
}
\arguments{
  \item{repTXML}{Filename of the input XML file.}
  \item{repTrda}{Filename of the output RDA file.}
  \item{repDrda}{Filename of the repdatadesc file for this repository.}
}
\details{
  This function is used by \code{\link{genRepos}} to convert the
  \code{repThemes.xml} file which specifies any repository themes in XML
  format into a list of \code{\link{reposTheme}} objects and stores them
  in a file named \code{repThemes.rda}.

  The \code{repdatadesc.rda} file must be used for cases where there is
  no package version specified for a package in a theme - in which case,
  \code{parseThemesXML} will determine the highest version of that
  package in the repository and use that for the package version of the theme.
}
\author{Jeff Gentry}
\seealso{\code{\link{themes}}, \code{\link{reposTheme-class}}, \code{\link{genRepos}}}
\examples{
   ## Using non-default filenames solely for this example
   exXMLfile <- system.file(file.path("themes", "repThemes.xml"),
                            package="reposTools")
   exDDfile <- system.file(file.path("themes", "repdatadesc.rda"),
                           package="reposTools")
   exOutfile <- tempfile()

 
   parseThemesXML(repTXML=exXMLfile, repTrda=exOutfile, repDrda=exDDfile)
}
\keyword{utilities}
