loadDepends <- function(x, force=FALSE, recursive=TRUE, local=TRUE) {
    require("tools") || stop("This function requires the tools package")

    ## Check to see if this is a vignette or a package
    if (length(grep("\\.(Rnw|Snw|rnw|snw)$",x)) > 0) {
        ## Assume this is a vignette
        depList <- vignetteDepends(x, recursive=recursive, local=local)
    }
    else {
        depList <- pkgDepends(x, recursive=recursive, local=local)
    }

    ## Now have depList, report any unresolved, load what is appropriate

    ## check to see if any are uninstalled, if so, report that,
    ## and only continue if force == TRUE
    bad <- which(! x$Depends %in% x$Installed)
    if ((length(bad) > 0) && (force == FALSE)) {
        out <- paste("The folowing dependencies were not installed:  ",
                     paste(pkgs[bad], collapse=", "), ".", sep="")
        stop(out)
    }

    ## Load the installed dependencies
    if (length(depList$Installed) > 0) {
        pkgs <- strsplit(depList$Installed, " ")
        pkgs <- unlist(lapply(pkgs, function(x) x[1]))

        installed <- unlist(lapply(pkgs,
                                   function(x) {
                                       z <- do.call("require", list(x))
                                       if (!z)
                                           warning("Could not load package ", z)
                                       z
                                   }))
        return(pkgs[installed])
    }
    else {
        return(character())
    }
}

getDependsMatrix <- function(deps) {
    ## Takes in a vector of dependencies, separates any version
    ## requirements.  Returns a matrix, col1 is the packs, col2
    ## is any algebraic requirements

    ## This is much different then tools:::getDepMtrx, which gets
    ## a similar matrix but for an installed package.  This is
    ## creating one out of dependency strings

    if ((is.null(deps))||(is.na(deps))||(length(deps)==0)||(deps==""))
        return(NULL)

    tmp <- strsplit(deps,",")
    if (!is.null(tmp))
        deps <- unlist(tmp)

    deps <- gsub("\\)","",deps)
    deps <- strsplit(deps,"\\(")
    ## Now have a list, some w/ 1 els some w/ more (those w/ reqs)
    deps <- lapply(deps, function(x){
                             if (length(x) == 1)
                                 return(c(x, ""))
                             else
                                 return(x)
                         }
                   )
    pkgs <- lapply(deps,function(x){return(x[1])})
    reqs <- lapply(deps,function(x){return(x[2])})
    depMtrx <- cbind(matrix(unlist(pkgs)),matrix(unlist(reqs)))
    ## Kill any trailing whitespace on entries
    for (i in 1:2)
        depMtrx[,i] <- gsub("[[:space:]]$","",depMtrx[,i])

    if (depMtrx[1,1] == "NA")
        depMtrx <- NULL

    return(depMtrx)
}


getReqVers <- function(depReq) {
    return(buildVersionNumber(gsub("(>)|(<)|(=)|([[:space:]])","",depReq)))
}

getReqOper <- function(depReq) {
    return(gsub("[^><=]","",depReq))
}

getDependings <- function(repository, depLevel=c("Depends",
                                         "Suggests"), method="auto") {
    depLevel <- match.arg(depLevel)

    if (missing(repository))
        stop("No online repositories specified")
    if (length(repository) != 1)
        stop("The repository argument must be of length 1")

    ## FIXME: CRAN.packages doesn't do 'Suggests', so ripping
    ##        out necessary code
##    cran <- CRAN.packages(contriburl=repository)

    tmpf <- tempfile()
    on.exit(unlink(tmpf))
    download.file(url=paste(repository, "PACKAGES", sep="/"),
                  destfile=tmpf, method=method, cacheOK=FALSE)
    cran <-  read.dcf(file=tmpf, fields=c("Package", "Version",
                                 "Priority", "Bundle", "Depends",
                                 "Suggests"))

    if (depLevel %in% colnames(cran)) {
        pkgDeps <- package.dependencies(cran, check=FALSE, depLevel=depLevel)
        pkgs <- names(pkgDeps)

        dependings <- vector(mode="list", length=length(pkgs))
        names(dependings) <- pkgs

        for (i in seq(along=pkgs)) {
            for (j in seq(along=pkgs)) {
                if (!is.matrix(pkgDeps[[j]]) && is.na(pkgDeps[[j]]))
                    next
                else if (pkgs[i] %in% pkgDeps[[j]][,1])
                    dependings[[i]] <- c(dependings[[i]], pkgs[j])
            }
        }

        dependings
    }
    else
        list()
}



