#include <dlfcn.h>
#include <stdlib.h>

#include <sys/utsname.h>

int __uname(struct utsname *buf)  __attribute__ ((alias("uname")));

int uname(struct utsname *buf)
{
  int err;
  static int (*func)();
  static char *s;
  if (!func)
    func = dlsym(RTLD_NEXT,"uname");
  err = func(buf);
  if (err)
    return err;
  if (!s)
    s = getenv("FAKEHOST");
  if (s)
    strcpy(buf->nodename,s);
  else
    strcpy(buf->nodename,"unknown");
  return err;
}
