/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2017-2018 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#include "vk_common.h"
#include "vk_resources.h"

template <>
std::string DoStringise(const VulkanChunk &el)
{
  RDCCOMPILE_ASSERT((uint32_t)VulkanChunk::Max == 1116, "Chunks changed without updating names");

  BEGIN_ENUM_STRINGISE(VulkanChunk)
  {
    STRINGISE_ENUM_CLASS(vkEnumeratePhysicalDevices);
    STRINGISE_ENUM_CLASS(vkCreateDevice);
    STRINGISE_ENUM_CLASS(vkGetDeviceQueue);
    STRINGISE_ENUM_CLASS(vkAllocateMemory);
    STRINGISE_ENUM_CLASS(vkUnmapMemory);
    STRINGISE_ENUM_CLASS(vkFlushMappedMemoryRanges);
    STRINGISE_ENUM_CLASS(vkCreateCommandPool);
    STRINGISE_ENUM_CLASS(vkResetCommandPool);
    STRINGISE_ENUM_CLASS(vkAllocateCommandBuffers);
    STRINGISE_ENUM_CLASS(vkCreateFramebuffer);
    STRINGISE_ENUM_CLASS(vkCreateRenderPass);
    STRINGISE_ENUM_CLASS(vkCreateDescriptorPool);
    STRINGISE_ENUM_CLASS(vkCreateDescriptorSetLayout);
    STRINGISE_ENUM_CLASS(vkCreateBuffer);
    STRINGISE_ENUM_CLASS(vkCreateBufferView);
    STRINGISE_ENUM_CLASS(vkCreateImage);
    STRINGISE_ENUM_CLASS(vkCreateImageView);
    STRINGISE_ENUM_CLASS(vkCreateDepthTargetView);
    STRINGISE_ENUM_CLASS(vkCreateSampler);
    STRINGISE_ENUM_CLASS(vkCreateShaderModule);
    STRINGISE_ENUM_CLASS(vkCreatePipelineLayout);
    STRINGISE_ENUM_CLASS(vkCreatePipelineCache);
    STRINGISE_ENUM_CLASS(vkCreateGraphicsPipelines);
    STRINGISE_ENUM_CLASS(vkCreateComputePipelines);
    STRINGISE_ENUM_CLASS(vkGetSwapchainImagesKHR);
    STRINGISE_ENUM_CLASS(vkCreateSemaphore);
    STRINGISE_ENUM_CLASS(vkCreateFence);
    STRINGISE_ENUM_CLASS(vkGetFenceStatus);
    STRINGISE_ENUM_CLASS(vkResetFences);
    STRINGISE_ENUM_CLASS(vkWaitForFences);
    STRINGISE_ENUM_CLASS(vkCreateEvent);
    STRINGISE_ENUM_CLASS(vkGetEventStatus);
    STRINGISE_ENUM_CLASS(vkSetEvent);
    STRINGISE_ENUM_CLASS(vkResetEvent);
    STRINGISE_ENUM_CLASS(vkCreateQueryPool);
    STRINGISE_ENUM_CLASS(vkAllocateDescriptorSets);
    STRINGISE_ENUM_CLASS(vkUpdateDescriptorSets);
    STRINGISE_ENUM_CLASS(vkBeginCommandBuffer);
    STRINGISE_ENUM_CLASS(vkEndCommandBuffer);
    STRINGISE_ENUM_CLASS(vkQueueWaitIdle);
    STRINGISE_ENUM_CLASS(vkDeviceWaitIdle);
    STRINGISE_ENUM_CLASS(vkQueueSubmit);
    STRINGISE_ENUM_CLASS(vkBindBufferMemory);
    STRINGISE_ENUM_CLASS(vkBindImageMemory);
    STRINGISE_ENUM_CLASS(vkQueueBindSparse);
    STRINGISE_ENUM_CLASS(vkCmdBeginRenderPass);
    STRINGISE_ENUM_CLASS(vkCmdNextSubpass);
    STRINGISE_ENUM_CLASS(vkCmdExecuteCommands);
    STRINGISE_ENUM_CLASS(vkCmdEndRenderPass);
    STRINGISE_ENUM_CLASS(vkCmdBindPipeline);
    STRINGISE_ENUM_CLASS(vkCmdSetViewport);
    STRINGISE_ENUM_CLASS(vkCmdSetScissor);
    STRINGISE_ENUM_CLASS(vkCmdSetLineWidth);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthBias);
    STRINGISE_ENUM_CLASS(vkCmdSetBlendConstants);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthBounds);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilCompareMask);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilWriteMask);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilReference);
    STRINGISE_ENUM_CLASS(vkCmdBindDescriptorSets);
    STRINGISE_ENUM_CLASS(vkCmdBindVertexBuffers);
    STRINGISE_ENUM_CLASS(vkCmdBindIndexBuffer);
    STRINGISE_ENUM_CLASS(vkCmdCopyBufferToImage);
    STRINGISE_ENUM_CLASS(vkCmdCopyImageToBuffer);
    STRINGISE_ENUM_CLASS(vkCmdCopyBuffer);
    STRINGISE_ENUM_CLASS(vkCmdCopyImage);
    STRINGISE_ENUM_CLASS(vkCmdBlitImage);
    STRINGISE_ENUM_CLASS(vkCmdResolveImage);
    STRINGISE_ENUM_CLASS(vkCmdUpdateBuffer);
    STRINGISE_ENUM_CLASS(vkCmdFillBuffer);
    STRINGISE_ENUM_CLASS(vkCmdPushConstants);
    STRINGISE_ENUM_CLASS(vkCmdClearColorImage);
    STRINGISE_ENUM_CLASS(vkCmdClearDepthStencilImage);
    STRINGISE_ENUM_CLASS(vkCmdClearAttachments);
    STRINGISE_ENUM_CLASS(vkCmdPipelineBarrier);
    STRINGISE_ENUM_CLASS(vkCmdWriteTimestamp);
    STRINGISE_ENUM_CLASS(vkCmdCopyQueryPoolResults);
    STRINGISE_ENUM_CLASS(vkCmdBeginQuery);
    STRINGISE_ENUM_CLASS(vkCmdEndQuery);
    STRINGISE_ENUM_CLASS(vkCmdResetQueryPool);
    STRINGISE_ENUM_CLASS(vkCmdSetEvent);
    STRINGISE_ENUM_CLASS(vkCmdResetEvent);
    STRINGISE_ENUM_CLASS(vkCmdWaitEvents);
    STRINGISE_ENUM_CLASS(vkCmdDraw);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndirect);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndexed);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndexedIndirect);
    STRINGISE_ENUM_CLASS(vkCmdDispatch);
    STRINGISE_ENUM_CLASS(vkCmdDispatchIndirect);
    STRINGISE_ENUM_CLASS(vkCmdDebugMarkerBeginEXT);
    STRINGISE_ENUM_CLASS(vkCmdDebugMarkerInsertEXT);
    STRINGISE_ENUM_CLASS(vkCmdDebugMarkerEndEXT);
    STRINGISE_ENUM_CLASS(vkDebugMarkerSetObjectNameEXT);
    STRINGISE_ENUM_CLASS(vkCreateSwapchainKHR);
    STRINGISE_ENUM_CLASS(SetShaderDebugPath);
    STRINGISE_ENUM_CLASS(vkRegisterDeviceEventEXT);
    STRINGISE_ENUM_CLASS(vkRegisterDisplayEventEXT);
    STRINGISE_ENUM_CLASS_NAMED(vkCmdIndirectSubCommand, "Indirect sub-command");
    STRINGISE_ENUM_CLASS(vkCmdPushDescriptorSetKHR);
    STRINGISE_ENUM_CLASS(vkCmdPushDescriptorSetWithTemplateKHR);
    STRINGISE_ENUM_CLASS(vkCreateDescriptorUpdateTemplate);
    STRINGISE_ENUM_CLASS(vkUpdateDescriptorSetWithTemplate);
    STRINGISE_ENUM_CLASS(vkBindBufferMemory2);
    STRINGISE_ENUM_CLASS(vkBindImageMemory2);
    STRINGISE_ENUM_CLASS(vkCmdWriteBufferMarkerAMD);
    STRINGISE_ENUM_CLASS(vkSetDebugUtilsObjectNameEXT);
    STRINGISE_ENUM_CLASS(vkQueueBeginDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkQueueEndDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkQueueInsertDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCmdBeginDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCmdEndDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCmdInsertDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCreateSamplerYcbcrConversion);
    STRINGISE_ENUM_CLASS(vkCmdSetDeviceMask);
    STRINGISE_ENUM_CLASS(vkCmdDispatchBase);
    STRINGISE_ENUM_CLASS(vkGetDeviceQueue2);
    STRINGISE_ENUM_CLASS_NAMED(Max, "Max Chunk");
  }
  END_ENUM_STRINGISE()
}

template <>
std::string DoStringise(const VkResourceType &el)
{
  BEGIN_ENUM_STRINGISE(VkResourceType);
  {
    STRINGISE_ENUM(eResUnknown)
    STRINGISE_ENUM(eResPhysicalDevice)
    STRINGISE_ENUM(eResInstance)
    STRINGISE_ENUM(eResDevice)
    STRINGISE_ENUM(eResQueue)
    STRINGISE_ENUM(eResDeviceMemory)
    STRINGISE_ENUM(eResBuffer)
    STRINGISE_ENUM(eResBufferView)
    STRINGISE_ENUM(eResImage)
    STRINGISE_ENUM(eResImageView)
    STRINGISE_ENUM(eResFramebuffer)
    STRINGISE_ENUM(eResRenderPass)
    STRINGISE_ENUM(eResShaderModule)
    STRINGISE_ENUM(eResPipelineCache)
    STRINGISE_ENUM(eResPipelineLayout)
    STRINGISE_ENUM(eResPipeline)
    STRINGISE_ENUM(eResSampler)
    STRINGISE_ENUM(eResDescriptorPool)
    STRINGISE_ENUM(eResDescriptorSetLayout)
    STRINGISE_ENUM(eResDescriptorSet)
    STRINGISE_ENUM(eResCommandPool)
    STRINGISE_ENUM(eResCommandBuffer)
    STRINGISE_ENUM(eResFence)
    STRINGISE_ENUM(eResEvent)
    STRINGISE_ENUM(eResQueryPool)
    STRINGISE_ENUM(eResSemaphore)
    STRINGISE_ENUM(eResSwapchain)
    STRINGISE_ENUM(eResSurface)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const MemoryScope &el)
{
  BEGIN_ENUM_STRINGISE(MemoryScope);
  {
    STRINGISE_ENUM_CLASS(InitialContents);
  }
  END_ENUM_STRINGISE()
}

template <>
std::string DoStringise(const MemoryType &el)
{
  BEGIN_ENUM_STRINGISE(MemoryType)
  {
    STRINGISE_ENUM_CLASS(Upload);
    STRINGISE_ENUM_CLASS(GPULocal);
    STRINGISE_ENUM_CLASS(Readback);
  }
  END_ENUM_STRINGISE()
}

template <>
std::string DoStringise(const VkFlagWithNoBits &el)
{
  if(el != 0)
    return StringFormat::Fmt("Invalid bits set: %x", el);
  return "0";
}

template <>
std::string DoStringise(const VkQueueFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueueFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUEUE_GRAPHICS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_COMPUTE_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_TRANSFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_SPARSE_BINDING_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_PROTECTED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkPipelineCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DERIVATIVE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DISPATCH_BASE);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkPipelineStageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineStageFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_VERTEX_INPUT_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_VERTEX_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TRANSFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_HOST_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_ALL_COMMANDS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_COMMAND_PROCESS_BIT_NVX);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkBufferUsageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkBufferUsageFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_TRANSFER_SRC_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_TRANSFER_DST_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_STORAGE_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_INDEX_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_VERTEX_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkImageUsageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkImageUsageFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_TRANSFER_SRC_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_TRANSFER_DST_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_SAMPLED_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_STORAGE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkBufferCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkBufferCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_SPARSE_BINDING_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_SPARSE_ALIASED_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_PROTECTED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkImageCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkImageCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPARSE_BINDING_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPARSE_ALIASED_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_ALIAS_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_EXTENDED_USAGE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_PROTECTED_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_DISJOINT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkSparseMemoryBindFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSparseMemoryBindFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SPARSE_MEMORY_BIND_METADATA_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkCommandPoolCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkCommandPoolCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_CREATE_TRANSIENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_CREATE_PROTECTED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkCommandPoolResetFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkCommandPoolResetFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkCommandBufferUsageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkCommandBufferUsageFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkDescriptorPoolCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDescriptorPoolCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT);
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkFenceCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkFenceCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_FENCE_CREATE_SIGNALED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkQueryPipelineStatisticFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueryPipelineStatisticFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkQueryControlFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueryControlFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUERY_CONTROL_PRECISE_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkQueryResultFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueryResultFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_64_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_WAIT_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_WITH_AVAILABILITY_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_PARTIAL_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkAttachmentDescriptionFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkAttachmentDescriptionFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkSampleCountFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSampleCountFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_1_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_2_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_4_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_8_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_16_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_32_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_64_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkImageAspectFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkImageAspectFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_COLOR_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_DEPTH_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_STENCIL_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_METADATA_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_PLANE_0_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_PLANE_1_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_PLANE_2_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkDependencyFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDependencyFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_DEPENDENCY_BY_REGION_BIT);
    STRINGISE_BITFIELD_BIT(VK_DEPENDENCY_DEVICE_GROUP_BIT);
    STRINGISE_BITFIELD_BIT(VK_DEPENDENCY_VIEW_LOCAL_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkShaderStageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkShaderStageFlagBits);
  {
    STRINGISE_BITFIELD_VALUE(VK_SHADER_STAGE_ALL_GRAPHICS);
    STRINGISE_BITFIELD_VALUE(VK_SHADER_STAGE_ALL);

    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_VERTEX_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_GEOMETRY_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_FRAGMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_COMPUTE_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkMemoryHeapFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkMemoryHeapFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_MEMORY_HEAP_DEVICE_LOCAL_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_HEAP_MULTI_INSTANCE_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkMemoryPropertyFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkMemoryPropertyFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_HOST_COHERENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_HOST_CACHED_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_PROTECTED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkAccessFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkAccessFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_ACCESS_INDIRECT_COMMAND_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_INDEX_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_UNIFORM_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_INPUT_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_SHADER_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_SHADER_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COLOR_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_TRANSFER_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_TRANSFER_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_HOST_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_HOST_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_MEMORY_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_MEMORY_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COMMAND_PROCESS_READ_BIT_NVX);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COMMAND_PROCESS_WRITE_BIT_NVX);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkExternalMemoryHandleTypeFlagBitsNV &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalMemoryHandleTypeFlagBitsNV);
  {
    STRINGISE_BITFIELD_BIT(VK_MEMORY_HEAP_DEVICE_LOCAL_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkExternalMemoryHandleTypeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalMemoryHandleTypeFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkExternalSemaphoreHandleTypeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalSemaphoreHandleTypeFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkExternalFenceHandleTypeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalFenceHandleTypeFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkSurfaceCounterFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSurfaceCounterFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_SURFACE_COUNTER_VBLANK_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkDeviceGroupPresentModeFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDeviceGroupPresentModeFlagBitsKHR);
  {
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkMemoryAllocateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkMemoryAllocateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
std::string DoStringise(const VkStencilFaceFlagBits &el)
{
  // technically a bitfield but each combination has a particular meaning
  BEGIN_ENUM_STRINGISE(VkStencilFaceFlagBits);
  {
    STRINGISE_ENUM(VK_STENCIL_FACE_FRONT_BIT)
    STRINGISE_ENUM(VK_STENCIL_FACE_BACK_BIT)
    STRINGISE_ENUM(VK_STENCIL_FRONT_AND_BACK)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkCullModeFlagBits &el)
{
  // technically a bitfield but each combination has a particular meaning
  BEGIN_ENUM_STRINGISE(VkCullModeFlagBits);
  {
    STRINGISE_ENUM(VK_CULL_MODE_NONE)
    STRINGISE_ENUM(VK_CULL_MODE_FRONT_BIT)
    STRINGISE_ENUM(VK_CULL_MODE_BACK_BIT)
    STRINGISE_ENUM(VK_CULL_MODE_FRONT_AND_BACK)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkPipelineBindPoint &el)
{
  BEGIN_ENUM_STRINGISE(VkPipelineBindPoint);
  {
    STRINGISE_ENUM(VK_PIPELINE_BIND_POINT_COMPUTE)
    STRINGISE_ENUM(VK_PIPELINE_BIND_POINT_GRAPHICS)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkIndexType &el)
{
  BEGIN_ENUM_STRINGISE(VkIndexType);
  {
    STRINGISE_ENUM(VK_INDEX_TYPE_UINT16)
    STRINGISE_ENUM(VK_INDEX_TYPE_UINT32)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkImageType &el)
{
  BEGIN_ENUM_STRINGISE(VkImageType);
  {
    STRINGISE_ENUM(VK_IMAGE_TYPE_1D)
    STRINGISE_ENUM(VK_IMAGE_TYPE_2D)
    STRINGISE_ENUM(VK_IMAGE_TYPE_3D)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkImageTiling &el)
{
  BEGIN_ENUM_STRINGISE(VkImageTiling);
  {
    STRINGISE_ENUM(VK_IMAGE_TILING_LINEAR)
    STRINGISE_ENUM(VK_IMAGE_TILING_OPTIMAL)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkImageViewType &el)
{
  BEGIN_ENUM_STRINGISE(VkImageViewType);
  {
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_1D)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_2D)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_3D)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_CUBE)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_1D_ARRAY)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_2D_ARRAY)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_CUBE_ARRAY)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkVertexInputRate &el)
{
  BEGIN_ENUM_STRINGISE(VkVertexInputRate);
  {
    STRINGISE_ENUM(VK_VERTEX_INPUT_RATE_VERTEX)
    STRINGISE_ENUM(VK_VERTEX_INPUT_RATE_INSTANCE)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkPolygonMode &el)
{
  BEGIN_ENUM_STRINGISE(VkPolygonMode);
  {
    STRINGISE_ENUM(VK_POLYGON_MODE_FILL)
    STRINGISE_ENUM(VK_POLYGON_MODE_LINE)
    STRINGISE_ENUM(VK_POLYGON_MODE_POINT)
    STRINGISE_ENUM(VK_POLYGON_MODE_FILL_RECTANGLE_NV)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkFrontFace &el)
{
  BEGIN_ENUM_STRINGISE(VkFrontFace);
  {
    STRINGISE_ENUM(VK_FRONT_FACE_COUNTER_CLOCKWISE)
    STRINGISE_ENUM(VK_FRONT_FACE_CLOCKWISE)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkBlendFactor &el)
{
  BEGIN_ENUM_STRINGISE(VkBlendFactor);
  {
    STRINGISE_ENUM(VK_BLEND_FACTOR_ZERO)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_DST_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_DST_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_CONSTANT_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_CONSTANT_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC_ALPHA_SATURATE)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC1_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC1_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkBlendOp &el)
{
  BEGIN_ENUM_STRINGISE(VkBlendOp);
  {
    STRINGISE_ENUM(VK_BLEND_OP_ADD)
    STRINGISE_ENUM(VK_BLEND_OP_SUBTRACT)
    STRINGISE_ENUM(VK_BLEND_OP_REVERSE_SUBTRACT)
    STRINGISE_ENUM(VK_BLEND_OP_MIN)
    STRINGISE_ENUM(VK_BLEND_OP_MAX)
    STRINGISE_ENUM(VK_BLEND_OP_ZERO_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_OVER_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_OVER_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_IN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_IN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_OUT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_OUT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_ATOP_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_ATOP_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_XOR_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_MULTIPLY_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SCREEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_OVERLAY_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DARKEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LIGHTEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_COLORDODGE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_COLORBURN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HARDLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SOFTLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DIFFERENCE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_EXCLUSION_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_INVERT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_INVERT_RGB_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LINEARDODGE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LINEARBURN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_VIVIDLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LINEARLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PINLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HARDMIX_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_HUE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_SATURATION_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_COLOR_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_LUMINOSITY_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_CLAMPED_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_DARKER_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_MINUS_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_MINUS_CLAMPED_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_CONTRAST_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_INVERT_OVG_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_RED_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_GREEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_BLUE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkDynamicState &el)
{
  BEGIN_ENUM_STRINGISE(VkDynamicState);
  {
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SCISSOR)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_LINE_WIDTH)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_BIAS)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_BLEND_CONSTANTS)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_BOUNDS)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_WRITE_MASK)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_REFERENCE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkAttachmentLoadOp &el)
{
  BEGIN_ENUM_STRINGISE(VkAttachmentLoadOp);
  {
    STRINGISE_ENUM(VK_ATTACHMENT_LOAD_OP_LOAD)
    STRINGISE_ENUM(VK_ATTACHMENT_LOAD_OP_CLEAR)
    STRINGISE_ENUM(VK_ATTACHMENT_LOAD_OP_DONT_CARE)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkAttachmentStoreOp &el)
{
  BEGIN_ENUM_STRINGISE(VkAttachmentStoreOp);
  {
    STRINGISE_ENUM(VK_ATTACHMENT_STORE_OP_STORE)
    STRINGISE_ENUM(VK_ATTACHMENT_STORE_OP_DONT_CARE)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkStencilOp &el)
{
  BEGIN_ENUM_STRINGISE(VkStencilOp);
  {
    STRINGISE_ENUM(VK_STENCIL_OP_KEEP)
    STRINGISE_ENUM(VK_STENCIL_OP_ZERO)
    STRINGISE_ENUM(VK_STENCIL_OP_REPLACE)
    STRINGISE_ENUM(VK_STENCIL_OP_INCREMENT_AND_CLAMP)
    STRINGISE_ENUM(VK_STENCIL_OP_DECREMENT_AND_CLAMP)
    STRINGISE_ENUM(VK_STENCIL_OP_INVERT)
    STRINGISE_ENUM(VK_STENCIL_OP_INCREMENT_AND_WRAP)
    STRINGISE_ENUM(VK_STENCIL_OP_DECREMENT_AND_WRAP)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkLogicOp &el)
{
  BEGIN_ENUM_STRINGISE(VkLogicOp);
  {
    STRINGISE_ENUM(VK_LOGIC_OP_CLEAR)
    STRINGISE_ENUM(VK_LOGIC_OP_AND)
    STRINGISE_ENUM(VK_LOGIC_OP_AND_REVERSE)
    STRINGISE_ENUM(VK_LOGIC_OP_COPY)
    STRINGISE_ENUM(VK_LOGIC_OP_AND_INVERTED)
    STRINGISE_ENUM(VK_LOGIC_OP_NO_OP)
    STRINGISE_ENUM(VK_LOGIC_OP_XOR)
    STRINGISE_ENUM(VK_LOGIC_OP_OR)
    STRINGISE_ENUM(VK_LOGIC_OP_NOR)
    STRINGISE_ENUM(VK_LOGIC_OP_EQUIVALENT)
    STRINGISE_ENUM(VK_LOGIC_OP_INVERT)
    STRINGISE_ENUM(VK_LOGIC_OP_OR_REVERSE)
    STRINGISE_ENUM(VK_LOGIC_OP_COPY_INVERTED)
    STRINGISE_ENUM(VK_LOGIC_OP_OR_INVERTED)
    STRINGISE_ENUM(VK_LOGIC_OP_NAND)
    STRINGISE_ENUM(VK_LOGIC_OP_SET)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkCompareOp &el)
{
  BEGIN_ENUM_STRINGISE(VkCompareOp);
  {
    STRINGISE_ENUM(VK_COMPARE_OP_NEVER)
    STRINGISE_ENUM(VK_COMPARE_OP_LESS)
    STRINGISE_ENUM(VK_COMPARE_OP_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_LESS_OR_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_GREATER)
    STRINGISE_ENUM(VK_COMPARE_OP_NOT_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_GREATER_OR_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_ALWAYS)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkFilter &el)
{
  BEGIN_ENUM_STRINGISE(VkFilter);
  {
    STRINGISE_ENUM(VK_FILTER_NEAREST)
    STRINGISE_ENUM(VK_FILTER_LINEAR)
    STRINGISE_ENUM(VK_FILTER_CUBIC_IMG)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSamplerMipmapMode &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerMipmapMode);
  {
    STRINGISE_ENUM(VK_SAMPLER_MIPMAP_MODE_NEAREST)
    STRINGISE_ENUM(VK_SAMPLER_MIPMAP_MODE_LINEAR)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSamplerAddressMode &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerAddressMode);
  {
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_REPEAT)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkBorderColor &el)
{
  BEGIN_ENUM_STRINGISE(VkBorderColor);
  {
    STRINGISE_ENUM(VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_INT_TRANSPARENT_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_INT_OPAQUE_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE)
    STRINGISE_ENUM(VK_BORDER_COLOR_INT_OPAQUE_WHITE)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkPrimitiveTopology &el)
{
  BEGIN_ENUM_STRINGISE(VkPrimitiveTopology);
  {
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_POINT_LIST)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_LIST)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_STRIP)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_PATCH_LIST)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkDescriptorType &el)
{
  BEGIN_ENUM_STRINGISE(VkDescriptorType);
  {
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_SAMPLER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_IMAGE)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkQueryType &el)
{
  BEGIN_ENUM_STRINGISE(VkQueryType);
  {
    STRINGISE_ENUM(VK_QUERY_TYPE_OCCLUSION)
    STRINGISE_ENUM(VK_QUERY_TYPE_PIPELINE_STATISTICS)
    STRINGISE_ENUM(VK_QUERY_TYPE_TIMESTAMP)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkPhysicalDeviceType &el)
{
  BEGIN_ENUM_STRINGISE(VkPhysicalDeviceType);
  {
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_OTHER)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_CPU)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSharingMode &el)
{
  BEGIN_ENUM_STRINGISE(VkSharingMode);
  {
    STRINGISE_ENUM(VK_SHARING_MODE_EXCLUSIVE)
    STRINGISE_ENUM(VK_SHARING_MODE_CONCURRENT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkCommandBufferLevel &el)
{
  BEGIN_ENUM_STRINGISE(VkCommandBufferLevel);
  {
    STRINGISE_ENUM(VK_COMMAND_BUFFER_LEVEL_PRIMARY)
    STRINGISE_ENUM(VK_COMMAND_BUFFER_LEVEL_SECONDARY)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSubpassContents &el)
{
  BEGIN_ENUM_STRINGISE(VkSubpassContents);
  {
    STRINGISE_ENUM(VK_SUBPASS_CONTENTS_INLINE)
    STRINGISE_ENUM(VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkImageLayout &el)
{
  BEGIN_ENUM_STRINGISE(VkImageLayout);
  {
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_UNDEFINED)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_GENERAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_PREINITIALIZED)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_PRESENT_SRC_KHR)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkStructureType &el)
{
  BEGIN_ENUM_STRINGISE(VkStructureType);
  {
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_APPLICATION_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_SPARSE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FENCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EVENT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_BARRIER)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MIR_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OBJECT_TABLE_CREATE_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CMD_PROCESS_COMMANDS_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CMD_RESERVE_SPACE_FOR_COMMANDS_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_LIMITS_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_FEATURES_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_HDR_METADATA_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkComponentSwizzle &el)
{
  BEGIN_ENUM_STRINGISE(VkComponentSwizzle);
  {
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_IDENTITY)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_ZERO)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_ONE)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_R)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_G)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_B)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_A)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkFormat &el)
{
  BEGIN_ENUM_STRINGISE(VkFormat);
  {
    STRINGISE_ENUM(VK_FORMAT_UNDEFINED)
    STRINGISE_ENUM(VK_FORMAT_R4G4_UNORM_PACK8)
    STRINGISE_ENUM(VK_FORMAT_R4G4B4A4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_B4G4R4A4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R5G6B5_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_B5G6R5_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R5G5B5A1_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_B5G5R5A1_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_A1R5G5B5_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_R8G8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_UINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_UINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_USCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SSCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_UINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SRGB_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_SNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_USCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_SSCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_UINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_SINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_SNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_USCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_SSCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_UINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_SINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_R16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R16G16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32G32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32A32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32A32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32A32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64G64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64A64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64A64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64A64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_B10G11R11_UFLOAT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_E5B9G9R9_UFLOAT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_D16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_X8_D24_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_D32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_D16_UNORM_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_D24_UNORM_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_D32_SFLOAT_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGB_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGB_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGBA_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGBA_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC2_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC2_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC3_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC3_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC4_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC4_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC5_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC6H_UFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC6H_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC7_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC7_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11G11_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11G11_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_4x4_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_4x4_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x4_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x4_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x6_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x6_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x6_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x6_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x6_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x6_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x10_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x10_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x10_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x10_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x12_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x12_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_G8B8G8R8_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8G8_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8R8_2PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8R8_2PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R10X6_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R10X6G10X6_UNORM_2PACK16)
    STRINGISE_ENUM(VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_R12X4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R12X4G12X4_UNORM_2PACK16)
    STRINGISE_ENUM(VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G16B16G16R16_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B16G16R16G16_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16R16_2PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16R16_2PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkResult &el)
{
  BEGIN_ENUM_STRINGISE(VkResult);
  {
    STRINGISE_ENUM(VK_SUCCESS)
    STRINGISE_ENUM(VK_NOT_READY)
    STRINGISE_ENUM(VK_TIMEOUT)
    STRINGISE_ENUM(VK_EVENT_SET)
    STRINGISE_ENUM(VK_EVENT_RESET)
    STRINGISE_ENUM(VK_INCOMPLETE)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_HOST_MEMORY)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_DEVICE_MEMORY)
    STRINGISE_ENUM(VK_ERROR_INITIALIZATION_FAILED)
    STRINGISE_ENUM(VK_ERROR_DEVICE_LOST)
    STRINGISE_ENUM(VK_ERROR_MEMORY_MAP_FAILED)
    STRINGISE_ENUM(VK_ERROR_LAYER_NOT_PRESENT)
    STRINGISE_ENUM(VK_ERROR_EXTENSION_NOT_PRESENT)
    STRINGISE_ENUM(VK_ERROR_FEATURE_NOT_PRESENT)
    STRINGISE_ENUM(VK_ERROR_INCOMPATIBLE_DRIVER)
    STRINGISE_ENUM(VK_ERROR_TOO_MANY_OBJECTS)
    STRINGISE_ENUM(VK_ERROR_FORMAT_NOT_SUPPORTED)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_POOL_MEMORY)
    STRINGISE_ENUM(VK_ERROR_INVALID_EXTERNAL_HANDLE)
    STRINGISE_ENUM(VK_ERROR_SURFACE_LOST_KHR)
    STRINGISE_ENUM(VK_ERROR_NATIVE_WINDOW_IN_USE_KHR)
    STRINGISE_ENUM(VK_SUBOPTIMAL_KHR)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_DATE_KHR)
    STRINGISE_ENUM(VK_ERROR_INCOMPATIBLE_DISPLAY_KHR)
    STRINGISE_ENUM(VK_ERROR_VALIDATION_FAILED_EXT)
    STRINGISE_ENUM(VK_ERROR_INVALID_SHADER_NV)
    STRINGISE_ENUM(VK_ERROR_FRAGMENTATION_EXT)
    STRINGISE_ENUM(VK_ERROR_NOT_PERMITTED_EXT)
  }
  END_ENUM_STRINGISE();
}

////////////////////////////////////////////////////////////
// VK_KHR_surface
////////////////////////////////////////////////////////////

template <>
std::string DoStringise(const VkSurfaceTransformFlagBitsKHR &el)
{
  string ret;
  if(el & VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR";
  if(el & VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR)
    ret += " | VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR";

  if(!ret.empty())
    ret = ret.substr(3);

  return ret;
}

template <>
std::string DoStringise(const VkCompositeAlphaFlagBitsKHR &el)
{
  string ret;

  if(el & VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR)
    ret += " | VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR";
  if(el & VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR)
    ret += " | VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR";
  if(el & VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR)
    ret += " | VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR";
  if(el & VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR)
    ret += " | VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR";

  if(!ret.empty())
    ret = ret.substr(3);

  return ret;
}

template <>
std::string DoStringise(const VkColorSpaceKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkColorSpaceKHR);
  {
    STRINGISE_ENUM(VK_COLOR_SPACE_SRGB_NONLINEAR_KHR)
    STRINGISE_ENUM(VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_DCI_P3_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_BT709_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_BT709_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_BT2020_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_HDR10_ST2084_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_DOLBYVISION_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_HDR10_HLG_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_PASS_THROUGH_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkPresentModeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkPresentModeKHR);
  {
    STRINGISE_ENUM(VK_PRESENT_MODE_IMMEDIATE_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_MAILBOX_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_FIFO_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_FIFO_RELAXED_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkDescriptorUpdateTemplateType &el)
{
  BEGIN_ENUM_STRINGISE(VkDescriptorUpdateTemplateType);
  {
    STRINGISE_ENUM(VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET)
    STRINGISE_ENUM(VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkConservativeRasterizationModeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkConservativeRasterizationModeEXT);
  {
    STRINGISE_ENUM(VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT)
    STRINGISE_ENUM(VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT)
    STRINGISE_ENUM(VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkTessellationDomainOrigin &el)
{
  BEGIN_ENUM_STRINGISE(VkTessellationDomainOrigin);
  {
    STRINGISE_ENUM(VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT)
    STRINGISE_ENUM(VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSamplerReductionModeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerReductionModeEXT);
  {
    STRINGISE_ENUM(VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_EXT)
    STRINGISE_ENUM(VK_SAMPLER_REDUCTION_MODE_MIN_EXT)
    STRINGISE_ENUM(VK_SAMPLER_REDUCTION_MODE_MAX_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSamplerYcbcrModelConversion &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerYcbcrModelConversion);
  {
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSamplerYcbcrRange &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerYcbcrRange);
  {
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_RANGE_ITU_FULL)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_RANGE_ITU_NARROW)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkChromaLocation &el)
{
  BEGIN_ENUM_STRINGISE(VkChromaLocation);
  {
    STRINGISE_ENUM(VK_CHROMA_LOCATION_COSITED_EVEN)
    STRINGISE_ENUM(VK_CHROMA_LOCATION_MIDPOINT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkDeviceQueueCreateFlagBits &el)
{
  BEGIN_ENUM_STRINGISE(VkDeviceQueueCreateFlagBits);
  {
    STRINGISE_ENUM(VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSubpassDescriptionFlagBits &el)
{
  BEGIN_ENUM_STRINGISE(VkSubpassDescriptionFlagBits);
  {
    STRINGISE_ENUM(VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX)
    STRINGISE_ENUM(VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkDescriptorSetLayoutCreateFlagBits &el)
{
  BEGIN_ENUM_STRINGISE(VkDescriptorSetLayoutCreateFlagBits);
  {
    STRINGISE_ENUM(VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR)
    STRINGISE_ENUM(VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkSwapchainCreateFlagBitsKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkSwapchainCreateFlagBitsKHR);
  {
    STRINGISE_ENUM(VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR)
    STRINGISE_ENUM(VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkQueueGlobalPriorityEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkQueueGlobalPriorityEXT);
  {
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_LOW_EXT)
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT)
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_HIGH_EXT)
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_REALTIME_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
std::string DoStringise(const VkExtent3D &el)
{
  return StringFormat::Fmt("VkExtent3D(%u, %u, %u)", el.width, el.height, el.depth);
}
