import sys
from qt import *
import time

class WorkerThread(QThread):
    def __init__(self, receiver, eventid, func, *args):
        QThread.__init__(self)
        self.receiver = receiver
        self.eventid = eventid
        self.func = func
        self.stopped = 0
        self.args = args


    def run(self):
        if not self.stopped:
            #time.sleep(5000)
            data = apply(self.func, self.args)
            if not self.stopped:
                event = QCustomEvent(self.eventid)
                event.setData(data)
                qApp.postEvent(self.receiver, event)

    def stop(self):
        self.stopped = 1
