/* ============================================================
*
* This file is a part of the rekonq project
*
* Copyright (C) 2009-2010 by Andrea Diamantini <adjam7 at gmail dot com>
* Copyright (C) 2010 by Matthieu Gicquel <matgic78 at gmail dot com>
*
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation; either version 2 of
* the License or (at your option) version 3 or any later version
* accepted by the membership of KDE e.V. (or its successor approved
* by the membership of KDE e.V.), which shall act as a proxy 
* defined in Section 14 of version 3 of the license.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
* ============================================================ */


#ifndef REKONQ_NEW_TAB_PAGE
#define REKONQ_NEW_TAB_PAGE


// Local Includes
#include "rekonqprivate_export.h"

// KDE Includes
#include <KUrl>

// Qt Includes
#include <QObject>
#include <QString>
#include <QWebElement>

// Forward Includes
class KBookmark;
class WebPage;


class REKONQ_TESTS_EXPORT NewTabPage : public QObject
{
Q_OBJECT

public:
    NewTabPage(QWebFrame *frame);
    ~NewTabPage();

    /**
     * This method takes an about: url and loads 
     * the corresponding part of the new tab page
     */
    void generate(KUrl url = KUrl("about:home"));
    
    void snapFinished(int index, KUrl url, QString title);
    void removePreview(int index);
     
protected:  // these are the function to build the new tab page
    void browsingMenu(const KUrl &currentUrl);

    void favoritesPage();
    void historyPage();
    void bookmarksPage();
    void closedTabsPage();

    QWebElement emptyPreview(int index);
    QWebElement loadingPreview(int index, KUrl url);
    QWebElement validPreview(int index, KUrl url, QString title);
    
    /** This function takes a QwebElement with the .thumbnail structure.
        It hides the "remove" and "modify" buttons->
    */
    void hideControls(QWebElement e);
    void showControls(QWebElement e);
    void setupPreview(QWebElement e, int index);
     
private:
    void createBookItem(const KBookmark &bookmark, QWebElement parent);
    
    /** This function helps to get faster a new markup of one type,it isn't easy to create one with QWebElement.
        It gets it in the #models div of home.html.
        It works for all elements defined here.
    */
    inline QWebElement markup(QString selector) 
    {
       return m_root.document().findFirst("#models > " + selector).clone();
    }
    
    QString checkTitle(QString title);

    QString m_html;
    
    QWebElement m_root;
    
    KUrl m_url;
};

#endif // REKONQ_NEW_TAB_PAGE
