actNull		= 0
actFirst	= 1
actPrevious	= 2
actNext		= 3
actLast		= 4
actAdd		= 5
actSave		= 6
actDelete	= 7
actQuery	= 8
actExecute	= 9
actCancel	= 10
actInsert	= 11
actReset	= 14
actGotoQRow	= 15
actSyncAll	= 16
actStore	= 17

def onButtonClick (button) :

	name	= button.getName ()
	block	= button.getBlock()

	if   name == "First" :
		block.doAction (actFirst   )
	elif name == "Previous" :
		block.doAction (actPrevious)
	elif name == "Next" :
		block.doAction (actNext    )
	elif name == "Last" :
		block.doAction (actLast    )
	elif name == "Add" :
		block.doAction (actAdd     )
	elif name == "Save" :
		block.doAction (actSave    )
	elif name == "Delete" :
		block.doAction (actDelete  )
	elif name == "Query" :
		block.doAction (actQuery   )
	elif name == "Execute" :
		block.doAction (actExecute )
	elif name == "Cancel" :
		block.doAction (actCancel  )
	elif name == "Insert" :
		block.doAction (actInsert  )

def onBlockCurrent (block, currow) :

	nrows	= block.getNumRows ()

	ctrl	= block.getNamedCtrl ("First", 0)
	if ctrl != None :
		ctrl.setEnabled (currow != 0)

	ctrl	= block.getNamedCtrl ("Previous", 0)
	if ctrl != None :
		ctrl.setEnabled (currow != 0)

	ctrl	= block.getNamedCtrl ("Next", 0)
	if ctrl != None :
		ctrl.setEnabled (currow != nrows)

	ctrl	= block.getNamedCtrl ("Last", 0)
	if ctrl != None :
		ctrl.setEnabled (currow != nrows - 1)

def onButtonGoForm (button) :

	button.getBlock().getForm().openForm (button.getName())

def onButtonGoReport (button) :

	button.getBlock().getForm().openReport (button.getName())
