/***************************************************************************
    file	         : pyobject.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYOBJECT_H
#define	__KB_PYOBJECT_H

#include	"kb_item.h"
#include	"kb_config.h"
#include	"kb_dblink.h"
#include	"kb_docroot.h"
#include	"pybase.h"

class	PyKBObject : public PyKBBase
{
public	:

	inline	PyKBObject
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBase (_cookie, _ptr, _name)
	{
	}

	inline	void	setEnabled
		(	bool	enabled
		)
	{
		if (!isValid ()) return ;
		((KBObject *)ptr)->setEnabled (enabled) ;
	}

	inline	void	setVisible
		(	bool	visible
		)
	{
		if (!isValid ()) return ;
		((KBObject *)ptr)->setVisible (visible) ;
	}

	inline	bool	isVisible ()
	{
		if (!isValid ()) return false ;
		return	((KBObject *)ptr)->isVisible () ;
	}

	inline	bool	isEnabled ()
	{
		if (!isValid ()) return false ;
		return	((KBObject *)ptr)->isEnabled () ;
	}
	inline	cchar	*getName ()
	{
		return	getAttr ("name") ;
	}
	inline	cchar	*getType ()
	{
		static QString aQString	   ;
		if (!isValid ()) return "" ;
		aQString = ((KBObject *)ptr)->getElement() ;
		return	aQString ;
	}

	inline	cchar	*getAttr
		(	cchar	*name
		)
	{
		static QString aQString	   ;
		if (!isValid ()) return "" ;
		aQString = ((KBObject *)ptr)->getAttrVal(name) ;
		return	aQString ;
	}

	inline	cchar	*getConfig
		(	cchar	*name
		)
	{
		static QString aQString	   ;
		if (!isValid ()) return "" ;

		TITER
		(	Config,
			((KBObject *)ptr)->getChildren(),
			c,
			if (c->attrib() == name)
			{	aQString = c->value() ;
				break	 ;
			}
		)

		return	aQString ;
	}

	inline	void	setAttr
		(	cchar	*name,
			cchar	*value,
			int	upd
		)
	{
		if (!isValid ()) return	;
		((KBObject *)ptr)->setAttrVal(name, value, true, upd) ;
	}

	inline	void	update	()
	{
		if (!isValid ()) return	;
		((KBObject *)ptr)->updateProps() ;
	}

	inline	KBNode	*getParent ()
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->getParent() ;
	}

	inline	KBBlock	*getBlock ()
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->getBlock() ;
	}

	inline	KBForm	*getForm  ()
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->getForm () ;
	}

	inline	KBReport *getReport  ()
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->getReport () ;
	}

	inline	KBNode	*getRoot  ()
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->getRoot () ;
	}

	KBObject*getNamedCtrl
		(	const char	*name,
			bool		reqd
		)
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->getNamedObject(name, reqd) ;
	}

	inline	uint	width	  ()
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->geometry().width () ;
	}

	inline	uint	height	  ()
	{
		if (!isValid ()) return 0 ;
		return	((KBObject *)ptr)->geometry().height() ;
	}

	inline	void	resize
		(	uint	width,
			uint	height
		)
	{
		if (!isValid ()) return ;
		((KBObject *)ptr)->resize(width, height) ;
	}

	inline	cchar	*lastError ()
	{
		return	PyKBBase::lastError ((KBObject *)ptr) ;
	}

	void	getControls
		(	QList<KBItem>	&controls
		)
	{
		if (!isValid ()) return ;

		TITER
		(	Item,
			((KBObject *)ptr)->getChildren(),
			i,
			
			if (i->isBlock() == 0) controls.append (i) 
		)
	}

	KBDBLink*openServer
		(	QString		svrName
		)
	{
		KBObject *object = (KBObject *)getPtr() ;
		if (object == 0) return 0 ;

		KBDBLink *dbLink = new KBDBLink () ;
		const KBLocation &locn = object->getDocRoot()->getLocation() ;

		if (svrName.isEmpty()) svrName = locn.docLocn ;

		if (!dbLink->connect (locn, svrName, true))
		{       delete  dbLink  ;
			return	0	;
		}

		return	dbLink	;
        }

}	;

#endif	// __KB_PYOBJECT_H
