/***************************************************************************
    file	         : pyform.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYFORM_H
#define	__KB_PYFORM_H

#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"
#include	"kb_dblink.h"
#include	"kb_dbinfo.h"
#include	"kb_form.h"
#include	"kb_copyexec.h"
#include	"kb_macro.h"
#include	"kb_dbdociter.h"
#include	"kb_objbase.h"
#include	"pyblock.h"


extern	QString	getPythonString (PyObject *) ;

class	PyKBForm : public PyKBBlock
{
public	:

	inline	PyKBForm
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBlock (_cookie, _ptr, _name)
	{
	}

	bool	openForm
		(	cchar		*name,
			QDict<QString>	&pDict,
			const KBValue	key,
			QDict<QString>	*rDict
		)
	{
		if (!isValid ()) return false ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"form",
			((KBForm *)ptr)->getDocRoot()->getLocation().docLocn,
			name
		)	;

		KBError		error	;
		KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject
					  (	location,
						KB::ShowAsData,
						pDict,
						error,
						key,
						rDict
					  )	;

		fprintf	(stderr, "PyKBForm::openForm: rc=%d\n", (int)rc) ;

		if (rc == KB::ShowRCError)
		{
			error.DISPLAY()	;
			return	false	;
		}

		return	rc == KB::ShowRCOK ;
	}

	bool	openReport
		(	cchar		*name,
			QDict<QString>	&pDict,
			const KBValue	key
		)
	{
		if (!isValid ()) return false ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"report",
			((KBForm *)ptr)->getDocRoot()->getLocation().docLocn,
			name
		)	;

		KBError		error	;
		KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject
					  (	location,
						KB::ShowAsReport,
						pDict,
						error,
						key
					  )	;

		if (rc == KB::ShowRCError)
		{
			error.DISPLAY()	;
			return	false	;
		}

		return	true	;
	}

	bool	openTextForm
		(	cchar		*text,
			QDict<QString>	&pDict
		)
	{
		if (!isValid ()) return false ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"form",
			KBLocation::m_pInline,
			"xmlTextForm",
			text
		)	;

		KBError		error	;
		KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject (location, KB::ShowAsData, pDict, error) ;

		fprintf	(stderr, "PyKBForm::openTextForm: rc=%d\n", (int)rc) ;

		if (rc == KB::ShowRCError)
		{
			error.DISPLAY()	;
			return	false	;
		}

		return	rc == KB::ShowRCOK ;
	}

	bool	openTextReport
		(	cchar		*text,
			QDict<QString>	&pDict
		)
	{
		if (!isValid ()) return false ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"report",
			KBLocation::m_pInline,
			"xmlTextReport",
			text
		)	;

		KBError		error	;
		KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject (location, KB::ShowAsReport, pDict, error) ;

		if (rc == KB::ShowRCError)
		{
			error.DISPLAY()	;
			return	false	;
		}

		return	true	;
	}

	bool	openTable
		(	cchar		*name,
			QDict<QString>	&pDict
		)
	{
		if (!isValid ()) return false ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"table",
			((KBForm *)ptr)->getDocRoot()->getLocation().docLocn,
			name
		)	;

		KBError		error	;
		KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject (location, KB::ShowAsData, pDict, error) ;

		fprintf	(stderr, "PyKBForm::openTable: rc=%d\n", (int)rc) ;

		if (rc == KB::ShowRCError)
		{
			error.DISPLAY()	;
			return	false	;
		}

		return	rc == KB::ShowRCOK ;
	}

	bool	openQuery
		(	cchar		*name,
			QDict<QString>	&pDict
		)
	{
		if (!isValid ()) return false ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"query",
			((KBForm *)ptr)->getDocRoot()->getLocation().docLocn,
			name
		)	;

		KBError		error	;
		KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject (location, KB::ShowAsData, pDict, error) ;

		fprintf	(stderr, "PyKBForm::openQuery: rc=%d\n", (int)rc) ;

		if (rc == KB::ShowRCError)
		{
			error.DISPLAY()	;
			return	false	;
		}

		return	rc == KB::ShowRCOK ;
	}

	QString	serverSetting
		(	const QString	&setting,
			QString		svrName
		)
	{
		KBForm	 *form	 = (KBForm *)getPtr() ;
		if (form == 0) return QString::null   ;

		const KBLocation &locn = form->getDocRoot()->getLocation() ;

		if (svrName.isEmpty()) svrName = locn.docLocn ;

		KBServerInfo  *svinfo = locn.dbInfo->findServer (svrName) ;
		if (svinfo == 0) return QString::null ;

		KBError  error	 ;
		KBServer *server = svinfo->getServer (error) ;
		if (server == 0) return QString::null ;

		return	server->setting (setting) ;
	}

	int	executeCopier
		(	cchar		*name,
			QDict<QString>	&pDict
		)
	{
		if (!isValid ()) return false ;
		KBForm	*form = ((KBBlock *)ptr)->isForm() ;
		if (form == 0)
		{	KBError::EError
			(	"Python Script Error",
				"Invoking executeCopier on non-form",
				__ERRLOCN
			)	;
			return	0 ;
		}

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"copier",
			((KBForm *)ptr)->getDocRoot()->getLocation().docLocn,
			name
		)	;

		QString	report	;
		KBError	error	;
		int	nRows	= KBCopyExec::execDocument
				  (	location,
					report,
					error,
					pDict
				  )	;

		if (nRows < 0)
			form->setError (error) ;

		return	nRows	;
	}

	int	executeMacro
		(	cchar		*name
		)
	{
		if (!isValid ()) return false ;
		KBForm	*form = ((KBBlock *)ptr)->isForm() ;
		if (form == 0)
		{	KBError::EError
			(	"Python Script Error",
				"Invoking executeMacro on non-form",
				__ERRLOCN
			)	;
			return	0 ;
		}

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"macro",
			((KBForm *)ptr)->getDocRoot()->getLocation().docLocn,
			name
		)	;

		KBError	error	;
		bool	ok	= KBMacroExec::execute
				  (	location,
					error,
					form
				  )	;

		if (!ok)
			form->setError (error) ;

		return	ok	;
	}

	bool	getServerList
		(	QStringList	&servers
		)
	{
		if (!isValid ()) return false ;
		KBForm	*form = ((KBBlock *)ptr)->isForm() ;
		if (form == 0)
		{	KBError::EError
			(	"Python Script Error",
				"Invoking getServerlist on non-form",
				__ERRLOCN
			)	;
			return	false	;
		}

		KBDBInfo		    *dbInfo = ((KBForm *)ptr)->getDocRoot()->getDBInfo() ;
		QListIterator<KBServerInfo> *svIter = dbInfo->getServerIter () ;
		KBServerInfo		    *svInfo ;

		while ((svInfo = svIter->current()) != 0)
		{
			servers.append (svInfo->serverName()) ;
			(*svIter) += 1 ;
		}

		return	true	;
	}

	bool	getObjectList
		(	QStringList	&objects,
			const char	*server,
			const char	*type
		)
	{
		if (!isValid ()) return false ;
		KBForm	*form = ((KBBlock *)ptr)->isForm() ;
		if (form == 0)
		{	KBError::EError
			(	"Python Script Error",
				"Invoking getObjectlist on non-form",
				__ERRLOCN
			)	;
			return	false	;
		}

		KBDBInfo	*dbInfo = ((KBForm *)ptr)->getDocRoot()->getDBInfo() ;
		KBDBDocIter	docIter ;
		KBError		error	;

		if (!docIter.init
			(	dbInfo,
				server,
				type,
				KBLocation::extnForType (dbInfo, type, ""),
				error,
				false
			))
		{
			error.DISPLAY ();
			return	false	;
		}

		QString	name	;
		QString	stamp	;

		while (docIter.getNextDoc (name, stamp))
		{
			objects.append (name) ;
		}

		return	true	;
	}

	QString	getObjectText
		(	cchar		*server,
			cchar		*name,
			cchar		*type
		)
	{
		if (!isValid ()) return QString::null ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			type,
			server,
			name
		)	;
		KBError	   error ;
		QString	   text	 = location.contents (error) ;
		if (text == QString::null) error.DISPLAY() ;
		return	   text  ;
	}

	KBNode	*findOpenForm
		(	cchar		*name
		)
	{
		if (!isValid ()) return false ;

		KBLocation location 
		(	((KBForm *)ptr)->getDocRoot()->getDBInfo  (),
			"form",
			((KBForm *)ptr)->getDocRoot()->getLocation().docLocn,
			name
		)	;

		KBNode	*node = KBAppPtr::getCallback()->objectNode (location) ;
		if ((node == 0) || (node->isForm() == 0)) return 0 ;

		return	node ;

	}

	inline	void	close
		(	int	rc
		)
	{
		if (!isValid()) return ;
		((KBForm *)ptr)->getDocRoot()->doRequestClose(rc) ;
	}

}	;

#endif	// __KB_PYFORM_H
