/***************************************************************************
    file	         : tkc_pydebug.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_PYDEBUG_H
#define	__TKC_PYDEBUG_H


#include	"tkc_pydebugbase.h"


/*  TKCPyRekallCookie							*/
/*  -----------------							*/
/*  Module cookie for Rekall. This is little more than a wrapper round	*/
/*  the KBLocation class.						*/

class	TKCPyRekallCookie : public TKCPyCookie
{
	KBLocation	location	;

public	:

	TKCPyRekallCookie (KBLocation &) ;
	virtual	~TKCPyRekallCookie    () ;

	virtual	bool		get		(      QString &, QString &, QString &) ;
	virtual	bool		put		(const QString &, QString &, QString &) ;
	virtual	bool		operator==	(const TKCPyCookie &) ;
	virtual	TKCPyCookie	*replicate	() ;
	virtual	QString		title		() ;

	inline	KBLocation	&getLocation	()
	{
		return	location ;
	}
}	;

/*  TKCPyDebug								*/
/*  ----------								*/
/*  This class, which is derived from the TKCPyDebugBase class, is the	*/
/*  Rekall interface to the debugger.					*/

class	TKCPyDebug : public TKCPyDebugBase
{
public	:

	inline	TKCPyDebug () : TKCPyDebugBase () { }

	virtual	TKCPyTraceOpt	funcTraceHook	(PyObject *, PyObject *, PyObject *, void *) ;
	virtual	TKCPyTraceOpt	lineTraceHook	(PyObject *, PyObject *, PyObject *, void *) ;
	virtual	TKCPyTraceOpt	profTraceHook	(PyObject *, PyObject *, PyObject *, void *) ;
	virtual	TKCPyTraceOpt	doDebugHook	(PY_FRAME_TYPE *, const char *) ;
}	;

#endif	// __TKC_PYDEBUG_H
