/***************************************************************************
    file	         : kb_kjdebug.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_KJDEBUG_H
#define	__KB_KJDEBUG_H

#include	"debugger.h"


class	KBKJSDebugger : public KJS::Debugger
{
	static	int		m_lastSourceID	;
	static	int		m_lastLine	;

	static	KBKJSDebugger	*m_self		;

public	:

	KBKJSDebugger	()	;

	virtual	bool	sourceParsed
			(	KJS::ExecState	*exec,
				int		sourceId,
				const KJS::UString
						&source,
				int		errorLine
			)	;

	virtual	bool	atStatement
			(	KJS::ExecState	*exec,
				int		sourceId,
				int		firstLine,
				int		lastLine
			)	;

	virtual	bool	callEvent
			(	KJS::ExecState	*exec,
				int		sourceId,
				int		lineno,
				KJS::Object	&function,
				const KJS::List	&args
			)	;

	virtual	bool	returnEvent
			(	KJS::ExecState	*exec,
				int		sourceId,
				int		lineno,
				KJS::Object	&function
			)	;

	virtual	bool	exception
			(	KJS::ExecState	*exec,
				int		sourceId,
				int		lineno,
				KJS::Object 	&exceptionObj
			)	;

	static	inline	int	lastSourceID ()
	{
		return	m_lastSourceID	;
	}
	static	inline	int	lastLine     ()
	{
		return	m_lastLine	;
	}

	static	KBKJSDebugger	*self ();
}	;

#endif	// __KB_KJDEBUG_H
