/***************************************************************************
    file	         : kb_tablebase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_TABLEBASE_H
#define	__KB_TABLEBASE_H

#include	"kb_libloader.h"

#include	"kb_objbase.h"
#include	"kb_tableviewer.h"



class	KBTableBase : public KBObjBase
{
	Q_OBJECT

	KBTableViewer	*m_viewer	 ;
	bool		m_create	 ;

private slots :

	void	widgetClosing () ;

public	:

	KBTableBase	(QObject *) ;
	virtual		~KBTableBase () ;

	virtual	bool		build
		(		KBLocation &,
				bool,
				KBError &
		) ;

	virtual	KB::ShowRC	show
		(		KB::ShowAs		,
				const QDict<QString>	&,
				QWidget			*,
				KBError			&,
				const KBValue		& = KBValue(),
				QDict<QString>		* = 0
		) ;

	virtual	QString		def	() { return QString::null ; }
}	;

#ifndef _WIN32
KBPARTFACTORY(KBTableFactory,"tableviewer")
#else
class KBTableFactory : public KBPartFactory
{
public:
	
	inline	KBTableFactory() : KBPartFactory ()
	{
	}
	virtual	QObject	*create(QObject* = 0, const char* = 0, const char* = 0, 
		const QStringList &	= QStringList());
	virtual	const char *ident();
};
#endif

#endif	// __KB_TABLEBASE_H
