/***************************************************************************
    file	         : kb_formviewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_FORMVIEWER_H
#define  _KB_FORMVIEWER_H

#include	"kb_classes.h"
#include	"kb_attrdict.h"
#include	"kb_conductor.h"
#include	"kb_viewer.h"
#include	"kb_navgui.h"
#include	"kb_docroot.h"


class	KBObjTreeViewer	;
class	QStatusBar	;


/*  KBFormViewer							*/
/*  ------------							*/
/*  This class is the MDI child wrapper for form viewing, in either	*/
/*  data or design mode.						*/

class	KBFormViewer : public KBViewer, protected KBPlayer
{
	Q_OBJECT

	KBAttrDict		m_pDict		;

	QGuardedPtr<KBForm  >	m_docRoot 	;
	KB::ShowAs		m_showing	;
	bool			m_executing	;
	KBNavGUI		*m_dataGUI	;
	KBObjTreeViewer		*m_objTree	;
	KBValue			m_parentKey	;

	QStatusBar		*m_statusBar	;
	QLabel			*m_locking	;

#if	! __KB_RUNTIME
	KBaseGUI		*m_designGUI	;
#endif

	void			setupWidget		(const QSize &)	;

protected slots	:

	void			execError		()	;
	void			requestClose		(int)	;
	void			objTreeViewerDead	()	;
	void			focusAtRow		(bool, uint, uint, bool) ;
	void			statusChange		(KBDocStatus *) ;

public	:

	KBFormViewer (KBObjBase*, QWidget *, const QDict<QString> &, bool = false) ;
virtual~KBFormViewer () ;

	virtual	KBFormViewer	*isFormViewer	() { return this  ; }

	virtual	cchar		*getChanged	(bool)	;
	virtual	bool		queryClose	()	;
	virtual	bool		event		(QEvent *) ;

	KB::ShowRC		startup		(KBForm *, KB::ShowAs, const KBValue &, KBError &) ;

	virtual	QString		playerName	()	;

	virtual	bool		playerPerform
				(	const QString	  &,
					const QStringList &,
					KBError		  &
				)	;
public	slots	:

	virtual	void	showAs		(KB::ShowAs)	;

	void		saveDocument	()     		;
	void		saveDocumentAs	()     		;

	void		dbaseAction	(int)		;
	void		reload	        ()		;
	void		doCtrlAlign	(int)		;
	void		doCut		()		;
	void		doCopy		()		;
	void		doSaveComponent	()		;
	void		doPaste		()		;
	void		snapToGrid	()		;

	void		showObjTree	()		;
	void		doMultiProp	()		;
	void		doProperties	()		;
}	;

extern	KBForm	*KBOpenForm  (KBDBInfo *, const QString &, QDict<QString> *, KBError &) ;

#endif // _KB_FORMVIEWER_H
