/***************************************************************************
    file	         : kb_querywidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_serverinfo.h"

#ifndef 	_WIN32
#include	"kb_querywidget.moc"
#else
#include 	"kb_querywidget.h"
#endif

#include	"tk_icons.h"



/*  KBQueryWidget								*/
/*  KBQueryWidget: Constructor for table copier widget			*/
/*  parent	 : QWidget *	: Parent widget				*/
/*  part	 : QObject *	: Parent copier part			*/
/*  srce	 : bool		: Table is source			*/
/*  location	 : KBLocation &	: Database location			*/
/*  (returns)	 : KBQueryWidget:					*/

KBQueryWidget::KBQueryWidget
	(	QWidget		*parent,
		QObject		*part,
		bool		srce,
		KBLocation	&location
	)
	:
	QWidget		(parent),
	KBCopyQuery	(srce, location),
	part		(part),
	srce		(srce),
	location	(location),
	cbServer	(this),
	cbQuery		(this),
	lbFields	(this),
	lbSelect	(this),
	bAdd		(this),
	bAddAll		(this),
	bRemove		(this),
	bUp		(this),
	bDown		(this),
#if	__KB_EMBEDDED
	wBottom		(this),
#else
	gbBottom	(2, Qt::Horizontal, srce ? TR("Where/Order") : TR("Operation"), this),
	wBottom		(&gbBottom),
#endif
	fldChooser
	(	location,
		cbServer, cbQuery, lbFields, lbSelect,
		bAdd,	   bAddAll, bRemove,  bUp,      bDown,
		false,
		true
	)
{
	int	 mlw	= 0 ;

	layMain	  = new QVBoxLayout (this     ) ;

	layQuery  = new QHBoxLayout (layMain  ) ;
	layQuery ->addWidget (&cbServer) ;
	layQuery ->addWidget (&cbQuery ) ;

	laySelect = new QHBoxLayout (layMain  ) ;
	laySelect->addWidget (&lbFields) ;
	layButton = new QVBoxLayout (laySelect) ;
	laySelect->addWidget (&lbSelect) ;

	layButton->addWidget (&bAdd    ) ;
	layButton->addWidget (&bAddAll ) ;
	layButton->addWidget (&bRemove ) ;
	layButton->addWidget (&bUp     ) ;
	layButton->addWidget (&bDown   ) ;
	layButton->addStretch()	 ;

	layExpr	= new QHBoxLayout (layMain) ;
	lExpr	= new QLabel	  (this) ;
	eExpr	= new QLineEdit	  (this) ;
	bExpr	= new QPushButton (this) ;

	layExpr->addWidget (lExpr) ;
	layExpr->addWidget (eExpr) ;
	layExpr->addWidget (bExpr) ;

	lExpr  ->setText   (TR("Expression")) ;
	bExpr  ->setPixmap (getSmallIcon("insert")) ;

	connect	(bExpr, SIGNAL(clicked()), SLOT(clickExpr())) ; 

	mlw	= lExpr->sizeHint().width() ;

#if	__KB_EMBEDDED
	layMain  ->addWidget (&wBottom ) ;
#else
	layMain  ->addWidget (&gbBottom) ;
#endif

	lWhere	= new QLabel    (&wBottom ) ;
	eWhere	= new QLineEdit (&wBottom ) ;
	lOrder	= new QLabel    (&wBottom ) ;
	eOrder	= new QLineEdit (&wBottom ) ;

	layBottom = new QGridLayout (&wBottom) ;
	layBottom->addWidget (lWhere, 0, 0) ;
	layBottom->addWidget (eWhere, 0, 1) ;
	layBottom->addWidget (lOrder, 1, 0) ;
	layBottom->addWidget (eOrder, 1, 1) ;

	lWhere->setText (TR("Where")) ;
	lOrder->setText (TR("Order By")) ;
	connect	(eWhere, SIGNAL(textChanged(const QString &)), part, SLOT(setChanged())) ;

	if (lWhere->minimumSizeHint().width() > mlw)
		mlw = lWhere->sizeHint().width() ;
	if (lOrder->minimumSizeHint().width() > mlw)
		mlw = lOrder->sizeHint().width() ;


#if	__KB_EMBEDDED
	lbFields.setMinimumWidth ( 75) ;
	lbSelect.setMinimumWidth ( 75) ;

	if (mlw > 0)
	{	lExpr ->setFixedWidth (mlw) ;
		lWhere->setFixedWidth (mlw) ;
		lOrder->setFixedWidth (mlw) ;
	}
#else
	lbFields.setMinimumWidth (120) ;
	lbSelect.setMinimumWidth (120) ;
#endif

	_KBDialog::setupLayout  (layMain,   -1, -1) ;
	_KBDialog::setupLayout  (layBottom, -1, -1) ;

	connect	(this,	      SIGNAL(changed	  ()),	   part, SLOT(setChanged ())) ;
	connect	(&fldChooser, SIGNAL(fieldsChanged()), 	   part, SLOT(setChanged ())) ;
	connect	(&fldChooser, SIGNAL(selectChanged(bool)), part, SLOT(setChanged ())) ;
}


/*  KBQueryWidget							*/
/*  clickExpr	: User clicks add-expression button			*/
/*  (returns)	: void		:					*/

void	KBQueryWidget::clickExpr ()
{
	QString	expr	;

	if (!(expr = eExpr->text()).isEmpty())
	{
		int	sCur	= lbSelect.currentItem () + 1 ;
		lbSelect.insertItem     (expr, sCur) ;
		lbSelect.setCurrentItem (sCur) ;
		emit changed () ;
	}
}


/*  KBQueryWidget							*/
/*  saveall	: Save all settings					*/
/*  (returns)	: void		:					*/

void	KBQueryWidget::saveall ()
{
	reset	() ;
	setServer (cbServer.currentText()) ;
	setQuery  (cbQuery .currentText()) ;

	for (uint idx = 0 ; idx < lbSelect.count() ; idx += 1)
		addField (lbSelect.text (idx)) ;

//	setWhere  (eWhere->text()) ;
//	setOrder  (eOrder->text()) ;
}

/*  KBQueryWidget							*/
/*  error	: KBError &	 : Error return				*/
/*  (returns)	: bool		 : Success				*/

bool	KBQueryWidget::valid
	(	KBError		&error
	)
{
	saveall () ;
	return	KBCopyQuery::valid (error) ;
}

/*  KBQueryWidget								*/
/*  set		: Set copier from definition				*/
/*  copy	: QDomElement & : Definition parent			*/
/*  error	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBQueryWidget::set
	(	QDomElement	&copy,
		KBError		&error
	)
{
	if (!KBCopyQuery::set (copy, error)) return false ;

	QStringList &fl = getFields () ;

	lbSelect.clear () ;
	lbFields.clear () ;
	
	if (!fldChooser.setServer (getServer ())) return true ;
	if (!fldChooser.setObject (getQuery  ())) return true ;

	for (uint idx1 = 0 ; idx1 < fl.count() ; idx1 += 1)
		lbSelect.insertItem (*fl.at(idx1)) ;

eWhere->setEnabled(false) ;
eOrder->setEnabled(false) ;
//	eWhere->setText (getWhere ()) ;
//	eOrder->setText (getOrder ()) ;
	return	true	;
}

/*  KBQueryWidget							*/
/*  def		: Get table copy definition				*/
/*  copy	: QDomElement &	: Element to which to attach		*/
/*  (returns)	: void		:					*/

void	KBQueryWidget::def
	(	QDomElement	&copy
	)
{
	saveall () ;
	return	KBCopyQuery::def (copy) ;
}
