/***************************************************************************
    file	         : kb_wizwizfile.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_serverinfo.h"

#ifndef		_WIN32
#include	"kb_wizwizfile.moc"
#else
#include	"kb_wizwizfile.h"
#endif


/*  KBWizardCtrlWizFile							*/
/*  KBWizardCtrlWizFile							*/
/*		: Constructor for file locator wizard control		*/
/*  page	: KBWizardPage *	: Parent wizard page		*/
/*  elem	: QDomElement &		: Definition element		*/

KBWizardCtrlWizFile::KBWizardCtrlWizFile
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	QWidget		*cntr	= new QWidget     (page) ;
	QHBoxLayout	*layout	= new QHBoxLayout (cntr) ;
	QPushButton	*btn	= new QPushButton (cntr) ;

	m_wizFile 		= new QLineEdit   (cntr) ;
	m_mode			= (KBFileDialog::KBMode)elem.attribute("mode").toInt() ;
	m_caption		= elem.attribute("caption") ;

	layout->setMargin  (0) ;
	layout->setSpacing (4) ;
	layout->addWidget  (m_wizFile) ;
	layout->addWidget  (btn	     ) ;

	btn   ->setText	      ("...") ;
	btn   ->setFixedWidth ((btn->sizeHint().width() * 2) / 3) ;

	setWidget (cntr) ;

	connect
	(	m_wizFile,
		SIGNAL(textChanged(const QString &)),
		SLOT  (ctrlChanged())
	)	;
	connect
	(	btn,
		SIGNAL(clicked()),
		SLOT  (slotClickFile())
	)	;
}

KBWizardCtrlWizFile::~KBWizardCtrlWizFile ()
{
}

void	KBWizardCtrlWizFile::slotClickFile ()
{
	QString	name	;

	switch (m_mode)
	{
		case KBFileDialog::Directory	:
			name  = KBFileDialog::getExistingDirectory
				(	"",
					m_caption
				)	;
			break	;

		case KBFileDialog::ExistingFile	:
			name  = KBFileDialog::getOpenFileName
				(	"",
					"*.rkl|Rekall files",
					0,
					m_caption
				) ;
			break	;

		default	:
			name  = KBFileDialog::getSaveFileName
				(	"",
					"*.rkl|Rekall files",
					0,
					m_caption
				) ;
			break;
	}

	if (name.isEmpty()) return ;

	m_wizFile->setText (name) ;
}


void	KBWizardCtrlWizFile::setValue
	(	const QString	&value
	)
{
	m_wizFile->setText (value) ;
}

/*  KBWizardCtrlDBType							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlWizFile::value ()
{
	return	m_wizFile->text () ;
}

WIZARDCTRLREG(WizFile)
