/***************************************************************************
    file	         : kb_wizorder.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_WIZORDER_H
#define	__KB_WIZORDER_H


#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_wizard.h"
#include	"kb_listboxpair.h"

#include	"libwizard_exports.h"


class	LIBWIZARD_API KBWizOrderSpecList : public KBListBoxPair
{
public	:

	KBWizOrderSpecList
	(	QListBox    *, QListBox    *,
		QPushButton *, QPushButton *,
		QPushButton *, QPushButton *,
		QPushButton *,
		bool = false
	)	;

	virtual	QListBoxItem	*replicate (QListBoxItem *) ;

}	;


/*  KBWizardCtrlOrder							*/
/*  -----------------							*/
/*  Wizard control used to allow selection of field order (for instance	*/
/*  for sorting. Uses the KBListBoxPair class to handle addition and	*/
/*  removal, and ordering.						*/

class	LIBWIZARD_API KBWizardCtrlOrder : public KBWizardCtrl
{
	Q_OBJECT

	QString		m_sourceName	;

	QWidget		*m_widget	;
	QListBox	*m_source	;
	QListBox	*m_dest		;
	QPushButton	*m_bAdd		;
	QPushButton	*m_bAddAll	;
	QPushButton	*m_bRemove	;
	QPushButton	*m_bMoveUp	;
	QPushButton	*m_bMoveDown	;
	KBWizOrderSpecList
			*m_lbPair	;


public	:

	KBWizardCtrlOrder
	(	KBWizardPage		*,
		const QDomElement	&
	)	;

	virtual	~KBWizardCtrlOrder	()	;

	virtual	void	pageShown	(bool)	;

	virtual	QVariant
			attribute	(const QString &) ;
	virtual	void	setValue	(const QString &) ;
	virtual	QString	value		()	;		

	virtual	bool	ok		()	;
}	;

#endif	// __KB_WIZORDER_H
