/***************************************************************************
    file	         : kb_wizorder.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dblink.h"
#include	"kb_location.h"
#include	"kb_qryquery.h"


#include	"kb_wizsource.h"
#include	"kb_wizfields.h"

#ifndef		_WIN32
#include	"kb_wizorder.moc"
#else
#include	"kb_wizorder.h"
#endif


KBWizOrderSpecList::KBWizOrderSpecList
	(	QListBox	*source,
		QListBox	*dest,
		QPushButton	*bAdd,
		QPushButton	*bAddAll,
		QPushButton	*bRemove,
		QPushButton	*bUp,
		QPushButton	*bDown,
		bool		multi
	)
	:
	KBListBoxPair (source, dest, bAdd, bAddAll, bRemove, bUp, bDown, multi)
{
}

QListBoxItem
	*KBWizOrderSpecList::replicate
	(	QListBoxItem	*item
	)
{
	return	new QListBoxText (item->text()) ;
}


/*  ------------------------------------------------------------------  */

/*  KBWizardCtrlOrder							*/
/*  KBWizardCtrlOrder							*/
/*		: Constructor for ordering wizard control		*/
/*  page	: KBWizardPage *	 : Parent page			*/
/*  elem	: QDomElement  &	 : Definition element		*/
/*  (returns)	: KBWizardCtrlOrder :					*/

KBWizardCtrlOrder::KBWizardCtrlOrder
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	/* The "source" attribute should have the form "page.ctrl"	*/
	/* and names the control (which should actually be of class	*/
	/* "KBWizardCtrlFields") that specifies the fields for the	*/
	/* order.							*/
	m_sourceName	= elem.attribute  ("source") ;

	setWide		(true) ;
	setWidget	(m_widget = new QWidget (page)) ;

	m_source	= new QListBox	  (m_widget) ;
	m_dest		= new QListBox	  (m_widget) ;
	m_bAdd		= new QPushButton (m_widget) ;
	m_bAddAll	= new QPushButton (m_widget) ;
	m_bRemove	= new QPushButton (m_widget) ;
	m_bMoveUp	= new QPushButton (m_widget) ;
	m_bMoveDown	= new QPushButton (m_widget) ;

	QVBoxLayout	*layMain = new QVBoxLayout (m_widget) ;

	layMain->addWidget (m_source	) ;

	QGridLayout	*layButt = new QGridLayout (layMain ) ;

	layButt->addWidget (m_bAdd,	 0, 0) ;
	layButt->addWidget (m_bAddAll,	 0, 1) ;
	layButt->addWidget (m_bRemove,	 1, 0) ;
	layButt->addWidget (m_bMoveUp,	 0, 3) ;
	layButt->addWidget (m_bMoveDown, 1, 3) ;
	layButt->setColStretch (2, 1) ;

	layMain->addWidget (m_dest	) ;

	m_lbPair = new	KBWizOrderSpecList
			(	m_source,
				m_dest,
				m_bAdd,
				m_bAddAll,
				m_bRemove,
				m_bMoveUp,
				m_bMoveDown,
				false
			)	;

	connect
	(	m_lbPair,
		SIGNAL	(destChanged(bool)),
		SLOT	(ctrlChanged())
	)	;
}

/*  KBWizardCtrlOrder							*/
/*  ~KBWizardCtrlOrder							*/
/*		: Destructor for data source wizard control		*/
/*  (returns)	:		:					*/

KBWizardCtrlOrder::~KBWizardCtrlOrder ()
{
	delete	m_lbPair ;
}

/*  KBWizardCtrlOrder							*/
/*  pageShown	: Page containing control is shown			*/
/*  next	: bool		: Moving to next page			*/
/*  (returns)	: void		:					*/

void	KBWizardCtrlOrder::pageShown
	(	bool		next
	)
{
	/* Do nothing if moving backwards. The field list will not	*/
	/* have changed and this preserves the user selection.		*/
	if (!next) return ;

	KBWizard	*wizard	= page()->wizard() ;

	QStringList	source	= QStringList::split ('.', m_sourceName) ;
	KBWizardCtrl	*ctrl	= wizard->findCtrl   (source[0], source[1]) ;

	m_source->clear() ;
	m_dest  ->clear() ;
	m_lbPair->setButtonState() ;

	if (ctrl == 0)
	{
		KBError::EError
		(	TR("Cannot locate source control"),
			QString("Path '%1'").arg(m_sourceName),
			__ERRLOCN
		)	;
		return	;
	}

	QList<KBFieldSpec>	fields	;
	((KBWizardCtrlFields *)ctrl)->fields (fields) ;

	LITER
	(	KBFieldSpec,
		fields,
		f,

		new QListBoxText (m_source, f->m_name) ;
	)

	/* Initialise the button state. Do it this way so that the	*/
	/* code is all in one place, even though the initial settings	*/
	/* should always be the same.					*/
	m_lbPair->setButtonState() ;
}

/*  KBWizardCtrlOrder							*/
/*  setValue	: Set data value					*/
/*  value	: const QString & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBWizardCtrlOrder::setValue
	(	const QString	&
	)
{
	/* Not used!							*/
}

/*  KBWizardCtrlOrder							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlOrder::value ()
{
	return	QString::null	;
}

/*  KBWizardCtrlOrder							*/
/*  ok		: Check if settings are acceptable			*/
/*  (returns)	: bool		: Acceptable				*/

bool	KBWizardCtrlOrder::ok ()
{
	return	true	;
}

/*  KBWizardCtrlOrder							*/
/*  attribute	: Get attribute value					*/
/*  attr	: const QString & : Attribute to retrieve		*/
/*  (returns)	: QVariant	  :					*/

QVariant
	KBWizardCtrlOrder::attribute
	(	const QString	&attr
	)
{
	if (attr == "order")
	{
		QStringList order	;
		for (uint idx = 0 ; idx < m_dest->count() ; idx += 1)
			order.append (m_dest->text(idx)) ;
		return	QVariant (order) ;
	}

	return	QVariant() ;
}


WIZARDCTRLREG(Order)
