/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef TKTEXTHIGHLIGHT_H
#define TKTEXTHIGHLIGHT_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#if		__KB_EMBEDDED
#include	<qt.h>
#undef		QT_NO_DOM
#undef		QDOM_H
#endif		//__KB_EMBEDDED
#include	"qdom.h"

#include <qcolor.h>
#include <qdict.h>

#if QT_VERSION >= 300
#include <qptrlist.h>
#else
#include <qlist.h>
#define QPtrList QList
#endif

#define CTSIZE 128

#include	"libtkwidgets_exports.h"

class LIBTKWIDGETS_API  TKTextEditorManager;
class LIBTKWIDGETS_API  TKTextLine;
class LIBTKWIDGETS_API  TKHighlightItem;

struct LIBTKWIDGETS_API TKHighlightData
{
	QString name;
	QString path;
	QString mask;
};

typedef QDict<TKHighlightData> HighlightDataDict;
typedef QPtrList<TKHighlightItem> HighlightContext;

struct LIBTKWIDGETS_API TKTextAttribute
{
  QString itemName;
  QColor color;
  bool usebg;
  QColor bgcolor;
  int fontType;
  /*
  Type  Bold Italic
   0     0    0
   1     0    1
   2     1    0
   3     1    1
  */
};

class LIBTKWIDGETS_API  TKTextHighlight
{
public:
  TKTextHighlight(const QString &, TKTextEditorManager *);
  virtual ~TKTextHighlight();

  TKTextAttribute *attribute(int z) { return attributeList[z]; }

  void highlight(TKTextLine *);
  int doHighlight(int, TKTextLine *);

  QString name() { return hname; }

protected:
  void makeContextList(QDomDocument *);
  void makeCtnList(QDomDocument *);
  void createItemData(QDomDocument *,TKTextEditorManager *);

private:
  HighlightContext *contextList[CTSIZE];
  HighlightContext *ctnList[CTSIZE];
  TKTextAttribute *attributeList[CTSIZE];
  QString hname;
};

class LIBTKWIDGETS_API  TKTextHighlightManager
{
public:
  static TKTextHighlight *findHighlight(TKTextEditorManager *, const QString &fileName);
  static TKTextHighlight *highlight(TKTextEditorManager *, const QString &highlightName=QString::null);
  static HighlightDataDict *highlights(TKTextEditorManager *);
};

#endif
