/***************************************************************************
    file	         : tk_part.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_PART_H
#define	__TK_PART_H

#include	<qwidget.h>

#include	"tk_xmlguispec.h"

#include "libtkkde_exports.h"

class	TKPart		;
class	TKPartManager	;

class LIBTKKDE_API TKPartManager : public QObject
{
	Q_OBJECT

	QWidget		*m_topWidget	;
	QList<TKPart>	m_partList	;
	TKPart		*m_activePart	;

	TKPart		*partForWidget	(QWidget *) ;

protected :

	virtual	bool	eventFilter	(QObject *, QEvent *) ;

protected slots :

	void		partDestroyed	() ;

public	:

	TKPartManager	(QWidget *, const char * = 0) ;

	virtual	void	addPart		(TKPart *, bool = true) ;
	virtual	void	setActivePart	(TKPart *) ;

	inline	const	QList<TKPart>	*parts ()
	{
		return	&m_partList	;
	}
	inline	TKPart	*activePart ()
	{
		return	m_activePart	;
	}

signals :

	void	activePartChanged (TKPart *)	;
}	;

class LIBTKKDE_API TKPart : public QObject, public TKXMLGUISpec
{
	Q_OBJECT

	QWidget		*m_widget	;
	TKPartManager	*m_manager	;

protected slots :

	virtual	void	slotWidgetDestroyed ()	;

public	:

	TKPart	(QObject * = 0, const char * = 0) ;
	virtual	~TKPart	() ;

	virtual	void	setWidget	(QWidget *) ;

	inline	QWidget	*widget ()
	{
		return	m_widget ;
	}
	inline	void	setManager
		(	TKPartManager	*manager
		)
	{
		m_manager = manager ;
	}
	inline	TKPartManager *manager ()
	{
		return	m_manager ;
	}
}	;

#endif	// __TK_PART_H
