/***************************************************************************
    file	         : tk_dirwatch.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TH_DIRWATCH_H
#define	__TH_DIRWATCH_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include	<qtimer.h>
#include	<qdict.h>
#include <qfileinfo.h>

#include "libtkkde_exports.h"

class LIBTKKDE_API TKDirWatchDir
{
	QFileInfo	m_dir		;
	QDateTime	m_lastmod	;

public	:

	TKDirWatchDir	(const QString	&) ;

	bool		dirty	()	;
}	;

class LIBTKKDE_API TKDirWatch : public QObject
{
	Q_OBJECT

	QTimer			m_timer		;
	QDict<TKDirWatchDir>	m_dirlist	;

private slots :

	void	checkDirs	() ;

signals	:

	void	dirty		(const QString &)	;

public	:

	TKDirWatch		(int frequency = 500)	;

	void	addDir		(const QString &) ;
	void	removeDir	(const QString &) ;

}	;

#endif	// __TH_DIRWATCH_H
