/***************************************************************************
    file	         : tk_progress.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef	__TK_PROGRESS_H
#define	__TK_PROGRESS_H


#include	<qdialog.h>
#include	<qlabel.h>
#include	<qlineedit.h>
#include	<qpushbutton.h>
#include	<qtimer.h>


/*  TKProgress								*/
/*  ----------								*/
/*  The intent of this is like the QProgress dialog, but for our use	*/
/*  where we may not know in advance how many operations are to be done	*/
/*  (for instance, when importing from a CSV file).			*/

class	TKProgress : public QDialog
{
	Q_OBJECT

	QLabel		m_legend	;
	QLineEdit	m_count		;
	QLabel		m_of		;
	QLineEdit	m_total		;
	QPushButton	m_bCancel	;

	QTimer		m_timer		;

	uint		m_next		;
	uint		m_done		;
	uint		m_showat	;
	bool		m_cancelled	;
	bool		m_period	;

protected slots :

	void		clickCancel	() ;
	void		slotTimer	() ;

public	:

	TKProgress (const QString &, const QString &, const QString &, bool = true, uint = 200) ;

	void	setTotal	(uint)	;
	void	setDone		(uint)	;

	inline	uint	getDone	  ()
	{
		return	m_next		;
	}

	inline	bool	cancelled ()
	{
		return	m_cancelled	;
	}

	inline	void	setPeriod
		(	uint	period
		)
	{
		m_period = period	;
	}
}	;


#endif	// __TK_PROGRESS_H
