/***************************************************************************
    file	         : kb_sizer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_SIZER_H
#define	_KB_SIZER_H

#if		! __KB_RUNTIME

#include 	<qcursor.h>
#include 	<qwidget.h>
#include 	<qguardedptr.h>

#include	"kb_classes.h"
#include	"kb_limit.h"

#include	"libkbase_exports.h"

class	KBDisplay	;
class	KBSizer		;
class	KBSizerBlob	;
class	KBDispWidget	;
class	KBDispScroller	;

struct	LIBKBASE_API	KBSizerInfo	
{
	KBObject	*proxy	;	/* Proxy object for sizer blob	*/
	uint		flags	;	/* Resize/movement flags	*/
	QCursor		*cursor	;	/* Cursor when in blob		*/
}	;

struct	LIBKBASE_API	KBSizerInfoSet
{
	uint		trap	;	/* Mouse event trap flags	*/
	KBSizerInfo	tl	;	/* Top-left blob info		*/
	KBSizerInfo	tr	;	/* Top-right ...		*/
	KBSizerInfo	bl	;	/* Bottom-left ...		*/
	KBSizerInfo	br	;	/* Bottom-right			*/
}	;

#define	SZF_X		0x0001		/* Size/move in X direction	*/
#define	SZF_Y		0x0002		/* Size/move in Y direction	*/
#define	SZF_MOVE	0x0010		/* Move flag			*/

#define	SZF_LEFT	0x0100		/* Handle left mouse clicks	*/
#define	SZF_RIGHT	0x0200		/* Handle left mouse clicks	*/
#define	SZF_DBL		0x0400		/* Handle left mouse clicks	*/

/*  KBSizerBlob								*/
/*  -----------								*/
/*  This class is used for the marker blobs for resizing and moving	*/
/*  controls.								*/

class	LIBKBASE_API	KBSizerBlob : public QWidget
{
	Q_OBJECT

	KBObject	*object	;
	QCursor		cursor	;
	uint		flags	;
	
public	:

	KBSizerBlob (QWidget *, KBObject*, uint, QCursor *) ;

	virtual	void		move		  (int, int) ;
	virtual	void		mousePressEvent   (QMouseEvent *) ;
	virtual	void		mouseMoveEvent	  (QMouseEvent *) ;
	virtual	void		mouseReleaseEvent (QMouseEvent *) ;

	inline	QCursor		&getCursor 	  () { return cursor ; }
	inline	uint		getFlags	  () { return flags  ; }
}	;


typedef	QGuardedPtr<KBSizerBlob> KBBlobPtr ;


/*  KBSizer								*/
/*  -------								*/
/*  The KBSizer class is used to allow positioning and sizing of	*/
/*  form controls. It operates in conjunction with the KBForm node	*/
/*  fot the document being manipulated.					*/

class LIBKBASE_API	KBSizer : public QObject
{
	Q_OBJECT

	KBObject	*object	;	/* Object being worked upon	*/
	KBDisplay	*display;

	QWidget		*szCtrl	;	/* Control to attach blobs to	*/
	QWidget		*evCtrl	;	/* Control to event filter	*/

	KBBlobPtr	btl	;	/* Top-left marker blob		*/
	KBBlobPtr	btr	;	/* Top-right marker blob	*/
	KBBlobPtr	bbl	;	/* Bottom-left marker blob	*/
	KBBlobPtr	bbr	;	/* Bottom-right marker blob	*/
	KBSizerBlob	*track	;	/* Tracking blob		*/
	uint		trap	;	/* Mouse event trap flags	*/

	int	startMX		;
	int	startMY		;
	int	startCX		;
	int	startCY		;
	int	startW		;
	int	startH		;
	bool	tracking	;
	bool	altered		;
	QSize	minSize		;	/* Minimum size of object	*/
	KBLimit	limit		;	/* Movement limits		*/

	void	init	(KBSizerInfoSet *) ;

protected :

	bool	eventFilter (QObject *, QEvent *) ;

public	:

	KBSizer	(KBObject *, KBDisplay *,
			     QWidget   *,
			     KBSizerInfoSet * = 0) ;

	KBSizer	(KBObject *, KBDisplay *,
			     KBControl *,
			     KBSizerInfoSet * = 0) ;
       ~KBSizer () ;

	void			trackStart	(QMouseEvent *, KBSizerBlob *) ;
	void			trackMove 	(QMouseEvent *) ;
	void			trackDone 	() ;

	void			setBlobs	() ;
	void			setGeometry	(QRect) ;
	void			doResize	(int, int, bool) ;

	void			hide		() ;
	void			show		() ;
	bool			doDesignPopup	(QMouseEvent *) ;

	enum	KBSizerState
	{	sbLeader,
		sbFollower,
		sbActive,
		sbIdle
	}	;

	void			setState	(KBSizerState) ;
	void			accept		(bool)	;
	void			snapToGrid	()	;
	QRect			getPosition	()	;

	inline	KBObject	*getObject	() { return object   ; }
	inline	bool		isTracking	() { return tracking ; }

	static	void		defaultInfoSet	(KBSizerInfoSet &) ;
}	;


#endif	// ! __KB_RUNTIME

#endif	// _KB_SIZER_H
