/***************************************************************************
    file	         : kb_qtspinbox.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qspinbox.h>
#include	<qobjectlist.h>


#ifndef 	_WIN32
#include 	"kb_qtspinbox.moc"
#else
#include 	"kb_qtspinbox.h"
#endif

#include	"kb_spinbox.h"
#include	"kb_writer.h"
#include	"kb_block.h"
#include	"kb_display.h"
#include	"kb_docroot.h"
#include	"kb_helper.h"




/*  KBCtrlSpinBox							*/
/*  KBCtrlSpinBox: Constructor for spinbox wrapper			*/
/*  display	 : KBDisplay *	 : Parent display			*/
/*  spinbox	 : KBSpinBox *	 : Parent spinbox			*/
/*  drow	 : uint		 : Row number in field			*/
/*  (returns)	 : KBCtrlSpinBox :					*/

KBCtrlSpinBox::KBCtrlSpinBox
	(	KBDisplay	*display,
		KBSpinBox	*spinbox,
		uint		drow
	)
	:
	QSpinBox	(display->getDisplayWidget()),
	KBControl	(this, display, spinbox, drow),
	m_spinbox	(spinbox)
{
	m_inSetValue	= false	;
	m_isNull	= false	;

	QObjectList *cl = queryList("TKLineEdit", 0, true, true) ;
	m_mainWidget	= cl->count() == 0 ? this : (QWidget *)cl->at(0) ;

	connect
	(	this,
		SIGNAL	(valueChanged	 (const QString &)),
		SLOT	(slotValueChanged(const QString &))
	)	;
	connect
	(	editor(),
		SIGNAL	(textChanged	 (const QString &)),
		SLOT	(slotValueChanged(const QString &))
	)	;
}

/*  KBCtrlSpinBox							*/
/*  ~KBCtrlSpinBox: Destructor for spinbox class			*/
/*  (returns)	  :		:					*/

KBCtrlSpinBox::~KBCtrlSpinBox ()
{
}


/*  KBCtrlSpinBox							*/
/*  mapValueToText: Map spin box value to text				*/
/*  value	  : int		: Value					*/
/*  (returns)	  : QString	: Text to display			*/

QString	KBCtrlSpinBox::mapValueToText
	(	int		value
	)
{
	/* If in design view then show the control name for the first	*/
	/* rown and blank thereafter.					*/
	if (m_showing == KB::ShowAsDesign)
		return	m_drow == 0 ? m_spinbox->getName() : QString::null ;

	/* Otherwise, show null as empty text, and all non-null values	*/
	/* as normal.							*/
	return	m_isNull ? QString::null : QSpinBox::mapValueToText (value) ;
}

/*  KBCtrlSpinBox							*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlSpinBox::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
		updateDisplay() ;
#endif
}


/*  KBCtrlSpinBox							*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlSpinBox::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (m_drow == 0))
	{
		showName () ;
		return	    ;
	}
#endif

	NOCHANGE
	(
		QSpinBox::setValue (0);
	)
}

/*  KBCtrlSpinBox							*/
/*  setValue	: Set spinbox value					*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlSpinBox::setValue
	(	const KBValue	&value
	)
{
	m_isNull = value.isNull() ;

	NOCHANGE
	(
		QSpinBox::setValue (value.getRawText().toInt()) ;
	)

	KBControl::setValue (value) ;
}

/*  KBCtrlSpinBox							*/
/*  getValue	: Get spinbox value					*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBCtrlSpinBox::getValue ()
{
	/* If the control value is null and the initial value was null	*/
	/* (as opposed to an empty string), then return a null.		*/
	if (m_isNull && getIniValue().isNull())
		return	KBValue (m_spinbox->getFieldType()) ;

	return	KBValue (value(), m_spinbox->getFieldType()) ;
}

/*  KBCtrlSpinBox							*/
/*  clearValue	: Clear value for specified query and display row	*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBCtrlSpinBox::clearValue
	(	bool	query
	)
{
	NOCHANGE
	(
		m_isNull = true ;
		QSpinBox::setValue (0) ;
	)

	KBControl::clearValue (query) ;
}

/*  KBCtrlSpinBox							*/
/*  changed	: Test if spinbox value has been changed		*/
/*  (returns)	: bool		: TRUE if changed			*/

bool	KBCtrlSpinBox::changed ()
{
	/* Special case: This handles the situation where the inital	*/
	/* value is null, otherwise we get empty != null.		*/
	if (m_isNull && getIniValue().isNull())
		return false ;

	return	value() != getIniValue().getRawText().toInt() ;
}

/*  KBCtrlSpinBox							*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlSpinBox::isEmpty ()
{
	return	m_isNull ;
}

/*  KBCtrlSpinBox							*/
/*  isValid	: See if control is valid				*/
/*  allowNull	: bool		: True to ignore not-null check		*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlSpinBox::isValid
	(	bool	allowNull
	)
{
	return	!m_isNull || allowNull || m_spinbox->allowNull() ;
}

/*  KBCtrlSpinBox								*/
/*  focusInEvent: Handle focus arrival					*/
/*  e		: QFocusEvent *	: Focus arrival event			*/
/*  (returns)	: void		:					*/

void	KBCtrlSpinBox::focusInEvent
	(	QFocusEvent	*e
	)
{
	QSpinBox::focusInEvent (e) ;
}

/*  KBCtrlSpinBox								*/
/*  focusOutEvent: Handle focus exit					*/
/*  e		 : QFocusEvent * : Focus exit event			*/
/*  (returns)	 : void		 :					*/

void	KBCtrlSpinBox::focusOutEvent
	(	QFocusEvent *e
	)
{
	QSpinBox::focusOutEvent (e) ;
}

/*  KBCtrlSpinBox								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlSpinBox::giveFocus ()
{
	QSpinBox::setFocus () ;
}


/*  KBCtrlSpinBox							*/
/*  slotValueChanged							*/
/*		: User has changed setting				*/
/*  text	: const QString & : New text value			*/
/*  (returns)	: void		  :					*/

void	KBCtrlSpinBox::slotValueChanged
	(	const QString	&text
	)
{
	if (!m_inSetValue && startUpdate())
	{
		m_isNull = text.isEmpty() ;
		m_spinbox->userChange (m_spinbox->getBlock()->getCurDRow() + m_drow) ;
	}
}

/*  KBCtrlSpinBox							*/
/*  mainWidget	: Get the main widget for the control			*/
/*  (returns)	: QWidget *	: Widget in question			*/

QWidget	*KBCtrlSpinBox::mainWidget ()
{
	return	m_mainWidget ;
}

/*  KBCtrlSpinBox								*/
/*  write	: Write spinbox 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: spinbox area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlSpinBox::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}

/*  KBCtrlSpinBox							*/
/*  morphText	: Get text for morphed control				*/
/*  (returns)	: QString	: Text					*/

QString	KBCtrlSpinBox::morphText ()
{
	return	QString::number(value()) ;
}
