/***************************************************************************
    file	         : kb_qtpixmap.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QTPIXMAP_H
#define	_KB_QTPIXMAP_H

#include	<qlabel.h>

#include	"kb_classes.h"
#include	"kb_ctrl.h"

#include	"libkbase_exports.h"

/*  KBCtrlPixmap								*/
/*  -----------								*/
/*  Wrapper class for image control					*/

class LIBKBASE_API	KBCtrlPixmap : public QLabel, public KBControl
{
	KBPixmap	*m_pmap	;

protected :

        virtual void    giveFocus	() ;
	virtual	bool	eventFilter	(QObject *, QEvent *)	;
	virtual	void	setMonitor	(const KBValue &)	;

#if	! __KB_EMBEDDED
	virtual	void	dropEvent	(QDropEvent      *) ;
	virtual	void	dragEnterEvent	(QDragEnterEvent *) ;
#endif

public	:

	KBCtrlPixmap (KBDisplay *, KBPixmap *, uint) ;
virtual~KBCtrlPixmap () ;

	virtual	void	showName	() ;
	virtual	void	showAs		(KB::ShowAs) ;
	virtual	void	redraw		() ;
	virtual	void	setValue	(const KBValue &) ;
	virtual	KBValue	getValue	() ;
	virtual	void	clearValue	(bool) ;
	virtual	bool	changed		() ;
	virtual	bool	isEmpty		() ;
	virtual	bool	isValid		(bool) ;
	virtual	bool	write		(KBWriter *, QRect, const KBValue &, bool, int &) ;

	void		saveImage	(const QString &, const char *) ;
	void		loadImage	(const QString &) ;

	SETFOCUS
	SIZEHINT
}	;


#endif	// _KB_QTPIXMAP_H
