/***************************************************************************
    file	         : kb_override.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdarg.h>

#include	<qlist.h>
#include	<qdict.h>
#include	<qstring.h>


#include	"kb_classes.h"
#include	"kb_attr.h"

#include	"kb_node.h"
#include	"kb_object.h"
#include	"kb_override.h"
#include	"kb_config.h"
#include	"kb_nodereg.h"


/*  KBOverride								*/
/*  KBOverride	: Constructor for override node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: Attribute list			*/
/*		: bool *	:					*/
/*  (returns)	: KBOverride	:					*/

KBOverride::KBOverride
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBNode		(parent, "KBOverride"),
	m_ident		(this,	 "ident",	aList),
	m_path		(this,	 "path",	aList),
	m_attrib	(this,	 "attrib",	aList),
	m_value		(this,	 "value",	aList),
	m_enabled	(this,	 "enabled",	aList)
{
}

/*  KBOverride								*/
/*  KBOverride	: Constructor for override node				*/
/*  parent	: KBNode *	  : Parent node				*/
/*  ident	: const QString & : Identification			*/
/*  path	: const QString & : Path or target config		*/
/*  attrib	: const QString & : Attribute name			*/
/*  value	: const QString & : Default value			*/
/*  enabled	: bool		  : Override is enabled			*/
/*  (returns)	: KBOverride	  :					*/

KBOverride::KBOverride
	(	KBNode			*parent,
		const QString		&ident,
		const QString		&path,
		const QString		&attrib,
		const QString		&value,
		bool			enabled
	)
	:
	KBNode		(parent, "KBOverride"),
	m_ident		(this,	 "ident",	ident	),
	m_path		(this,	 "path",	path	),
	m_attrib	(this,	 "attrib",	attrib	),
	m_value		(this,	 "value",	value	),
	m_enabled	(this,	 "enabled",	enabled	)
{
}

/*  KBOverride								*/
/*  KBOverride	: Constructor for override node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  extant	: KBOverride *	: Extant node				*/
/*  (returns)	: KBOverride	:					*/

KBOverride::KBOverride
	(	KBNode			*parent,
		KBOverride		*extant
	)
	:
	KBNode		(parent, "KBOverride"),
	m_ident		(this,	 "ident",	extant),
	m_path		(this,	 "path",	extant),
	m_attrib	(this,	 "attrib",	extant),
	m_value		(this,	 "value",	extant),
	m_enabled	(this,	 "enabled",	extant)
{
}

/*  KBOverride								*/
/*  KBOverride	: Destructor for override node				*/
/*  (returns)	:		:					*/

KBOverride::~KBOverride ()
{
}

/*  KBOverride								*/
/*  substitute	: Substitue value into object by path			*/
/*  (returns)	: KBObject *	: Object substituted or null		*/

KBObject
	*KBOverride::substitute ()
{
	fprintf
	(	stderr,
		"KBOverride::substitute [%s][%s]<-[%s]\n",
		(cchar *)m_path  .getValue(),
		(cchar *)m_attrib.getValue(),
		(cchar *)m_value .getValue()
	)	;

	QString	 path	 = m_path  .getValue() ;
	QString	 attrib	 = m_attrib.getValue() ;

	KBObject *target = getParent()->isObject()->getNamedObject (path, false) ;
	if (target == 0) return 0 ;

	LITER
	(	KBNode,
		target->getChildren(),
		child,

		KBConfig *c = child->isConfig() ;
		if ((c != 0) && (c->attrib() == attrib))
		{
			c->setValue   (m_value.getValue()) ;
			c->substitute (true) ;
			return	target ;
		}
	)

	return	0 ;
}

/*  KBOverride								*/
/*  replicate	: Replicate this configuration node			*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New choice node			*/

KBNode	*KBOverride::replicate
	(	KBNode	*_parent
	)
{
	return	new KBOverride (_parent, this) ;
}


NEWNODE(Override, (cchar *)0, KF_FORM|KF_REPORT)


