/***************************************************************************
    file	         : kb_object.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_OBJECT_H
#define	_KB_OBJECT_H

#include	"libkbase_exports.h"

#include	<qsize.h>
#include	<qrect.h>

#if		! __KB_EMBEDDED
#include	<qvariant.h>
#endif

#include	"kb_node.h"
#include	"kb_event.h"
#include	"kb_limit.h"

#if	! __KB_RUNTIME
#include	"kb_sizer.h"

class		KBQuickText	;
#endif

/*  KBObject								*/
/*  -------								*/
/*  The KBObject class is used for elements in the XML parse tree	*/
/*  which correspond to displayed objects. It contains stuff common to	*/
/*  attributes and object properties, plus methods to support sizing	*/
/*  and moving, and right-button operations.				*/

class	LIBKBASE_API	KBObject : public KBNode
{
	Q_OBJECT

	KBBlock		*block		;	/* Owning block if any	*/
	KBDisplay	*display	;	/* Associated display	*/
	KBControl	*control	;	/* Control for sizer	*/

#if	! __KB_RUNTIME
	KBSizer		*sizer		;	/* Design mode sizer	*/
#endif

	KBAttrInt	x		;	/* Position attributes	*/
	KBAttrInt	y		;
	KBAttrInt	w		;
	KBAttrInt	h		;

	QRect		oldGeom		;
	QSize		curSize		;

	KBScriptObject	*m_scriptObj	;

protected :

	KBAttrInt	xmode		;
	KBAttrInt	ymode		;
	KBAttrStr	name		;

	KBAttrStr	*m_attrSlots	;	/* Dummy for slots	*/
	KBAttrStr	*m_attrConfig	;	/* Dummy for config	*/

	QPalette	*curPal		;	/* Current palette	*/
	QFont		*curFont	;	/* Current font		*/

#if	! __KB_RUNTIME
	KBQuickText	*m_quickText	;
#endif
	inline	KBDisplay	*getDisplay	() { return display ; }
	virtual	KBDisplay	*getContainer	() { return 0	    ; }

	bool			eventHook	(KBEvent &, uint, KBValue *, bool &) ;

	virtual	KBPopupMenu	*makeNewPopup	(bool, QRect) ;

#if	! __KB_RUNTIME
	void			setSizer	(KBSizer   *) ;

	void			insertObjects	(const QList<KBNode> &, KBDisplay *, int, int, uint, int, int) ;

	void			insertObjects	(KBDisplay *) ;
	void			insertHere	(const QList<KBNode> &, KBDisplay *, QPoint) ;
	void			insertComponent	(KBDisplay *, QPoint, QRect, bool) ;
#endif
	void			setChanged	() ;

	virtual void		setPalette	() ;
	virtual void		setFont		() ;

public slots :

	virtual	bool		propertyDlg	() ;
	virtual	void		cutObj		() ;
	virtual	void		copyObj		() ;
	virtual	void		deleteObj	() ;
	virtual	void		saveAsComponent	() ;

	virtual	void		pasteObjects	() ;

	virtual	void		setPropDirect	(int) ;

public	:

	enum	FloatMode
	{
		FMFixed,
		FMFloat,
		FMStretch
	}	;

	KBObject	(KBNode   *, cchar *, const QDict<QString> &) ;
	KBObject	(KBObject *, cchar *, const QRect          &) ;
	KBObject	(KBNode   *, KBObject *) ;
virtual~KBObject	()	;

	virtual	bool		event		(QEvent *)		;

	virtual	KBObject	*isObject	() { return this  ; }

	virtual	bool		propertyDlg	(cchar *)		;
	virtual	void		buildDisplay	(KBDisplay *)		;
	virtual	void		buildCtrls	(uint, int, int)	;
	virtual	void		showAs		(KB::ShowAs )		;
	virtual	void		ctrlGone	(KBControl *)		;

	virtual	void		updateProps	()			;

#if	! __KB_RUNTIME
	bool			addNewObject	(int, int, int, int)	;
	void			selectOverlap	(int, int, int, int)	;
	bool			checkOverlap	(int, int, int, int)	;
	KBSizer			*overlaps  	(int, int, int, int)	;

#endif
	void			findAllConfigs	(QList<KBConfig> &, QString) ;

	QSize			getBaseSize	() ;
	QSize			getMinSize	() ;
	KBLimit			getMoveLimit	() ;
	virtual	uint		calcNumRows	(uint, uint, int, int) ;
	virtual	uint		calcNumRows	(int, int, uint) ;

	virtual	bool		keyStroke	(QKeyEvent    *) ;
	virtual	bool		moveFocusOK	(uint) ;
	virtual	void		focusInEvent	(uint, QFocusEvent::Reason) ;
	virtual	void		designPopup	(QMouseEvent *, uint) ;
	virtual	void		contextMenu	(QMouseEvent *, uint) ;

	void			setFocus	() ;

	QRect			convGeometry	(const QRect  &, FloatMode, FloatMode) ;
	QRect			geometry	() ;
	QRect			geometry	(const QPoint &) ;
	QSize			minGeometry	() ;
	virtual void		setGeometry	(const QRect  &) ;
	virtual	void		move		(int, int) ;
	virtual	bool		resize		(int, int) ;
	virtual	void		redraw		() ;

	QPalette		*getPalette	(bool) ;
	QFont			*getFont	(bool) ;
	void			setControl	(KBControl * ) ;
	virtual bool		write		(KBWriter *, QPoint, bool, int &, bool = false) ;

	virtual	void		setEnabled	(bool)	;
	virtual	void		setVisible	(bool)	;
	virtual bool		isEnabled	()	;
	virtual bool		isVisible	()	;

	virtual	void		setTabOrder	(int )	;
	virtual	int		getTabOrder	()     	;

	QString			getPath		()	;
	inline	QString		getName 	()	{ return name.getValue() ; }
#if	! __KB_RUNTIME
	inline	KBSizer		*getSizer	()	{ return sizer   ; }
#endif
	KBBlock			*getBlock	()	;

	KBObject		*getNamedObject (QString, bool = false) ;
	KBObject		*getNamedObject (QString, KBError &, bool = false) ;

	KBFormBlock		*getFormBlock	()	;
	KBReportBlock		*getReportBlock	()	;
	KBNavigator		*getNavigator	()	;

	QWidget		  	*getDisplayWidget ()	;
	QWidget			*getTopWidget	  ()	;

	void			addSlot		(KBSlot  *) ;
	void			clearSlots	() ;
	const QList<KBSlot>	&getSlots	() ;
	bool			connectLinks	(KBError &) ;
	KBEmitter		*getEmitter	(const QString  &) ;

	void			setScriptObject	(KBScriptObject *) ;
	KBScriptObject		*scriptObject	() ;


	static	void		minPosition	(const QList<KBNode> &, int &, int &) ;

#if	! __KB_EMBEDDED
	virtual	QVariant	property	(cchar *)		;
	virtual	bool		setProperty	(cchar *, const QVariant &) ;
#endif
#if	! __KB_RUNTIME
	friend	class	KBSizer	;
#endif
}	;


#endif	// _KB_OBJECT_H
