/***************************************************************************
    file	         : kb_macro.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_MACRO_H
#define	__KB_MACRO_H

#include	<qlist.h>
#include	<qmap.h>
#include	<qobject.h>
#include	<qstring.h>
#include	<qstringlist.h>
#include	<qpushbutton.h>
#include	<qtextview.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dialog.h"
#include	"kb_options.h"
#include	"kb_dom.h"

#include	"libkbase_exports.h"


class	KBMacroExec	;
class	KBMacroInstr	;
class	KBMacroDebugDlg	;

typedef	QMap<QString,KBNode *>	NodeMap		;
typedef	QMap<QString,QString >	ValueMap	;



/*  KBMacroExec								*/
/*  -----------								*/
/*  Class used to handle macro parsing and execution.			*/

class	LIBKBASE_API KBMacroExec : public QObject
{
	Q_OBJECT

	KBDBInfo		*m_dbInfo	;
	QString			m_server	;
	KBNode			*m_invoker	;

	QList<KBMacroInstr>	m_instructions	;
	bool			m_executing	;
	NodeMap			m_nodes		;
	ValueMap		m_values	;

	bool			m_debug		;
	KBMacroDebugDlg		*m_debugDlg	;

	bool		showDebug	(KBMacroInstr *, KBError &) ;

private slots :

	void		slotNodeGone	()	;

public	:

	KBMacroExec	(KBDBInfo *, const QString &)	;
	KBMacroExec	(KBMacroExec *)		;

	~KBMacroExec	()				;

	bool		load		(QDomElement  &, KBError &)	;
	void		save		(QDomElement  &)		;
	void		save		(QString &, int)		;

	bool		append
			(	const QString		&,
				const QStringList	&,
				const QString		&,
				KBError			&
			)	;

	/* Allow instructions to store pointers to created objects like	*/
	/* forms and reports.						*/
	void		addNode		(cchar *, 	  KBNode *) 	;
	KBNode		*getNode	(const QString &, cchar  *) 	;

	/* Allow simple value saving ...				*/
	void		addValue	(cchar *, const QString  &)	;
	QString		getValue	(cchar *)			;

	void		setDebug	(bool)				;
	bool		execute		(KBNode *, KBError &)		;


	inline	const QList<KBMacroInstr>
				&instructions	() { return m_instructions ; }
	inline	KBDBInfo	*getDBInfo	() { return m_dbInfo 	   ; }
	inline	const QString	&getServer 	() { return m_server 	   ; }
	inline	KBNode		*getInvoker	() { return m_invoker	   ; }

	inline	void	halt ()
	{
		m_executing = false ;
	}

	/* Provide a static execution method to give a quick and easy	*/
	/* way to execute a macro from a specified location. Creates	*/
	/* and loads an instance or KBMacroExec, executes and deletes.	*/
	static	bool	execute	(KBLocation &, KBError &, KBNode * = 0) ;
}	;

/*  ------------------------------------------------------------------  */

/*  KBMacroInstr							*/
/*  ------------							*/
/*  Base class for a macro instruction. Classes are derived for each	*/
/*  available macro instruction, which specifically provide the execute	*/
/*  method.								*/

class	LIBKBASE_API KBMacroInstr
{
protected :

	KBMacroExec	*m_exec		;
	QString		m_action	;
	QString		m_comment	;
	QStringList	m_args		;

public	:

	KBMacroInstr	(KBMacroExec *, const QString &) ;
	virtual	~KBMacroInstr	()	;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			uint			,
			uint			,
			KBError			&
		)	;

	bool	init
		(	QDomElement		&,
			KBError			&
		)	;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	=  0	;


	inline	const QString		&action	() const { return m_action  ; }
	inline	const QString		&comment() const { return m_comment ; }
	inline	const QStringList	&args	() const { return m_args    ; }

	void		save	(QDomElement & ) ;
	void		save	(QString &, int) ;

	virtual	bool	execute	(KBError &) = 0  ;
}	;

/*  ------------------------------------------------------------------  */

/*  Macro instructions types (actions) are registered using the		*/
/*  NEWMACRO (C/C++) macro, which creates a static instance of the	*/
/*  KBMacroReg class. This executes when the library is loaded, and	*/
/*  registers the macro name and factory function.			*/

typedef	KBMacroInstr	*MKMACRO (KBMacroExec *) ;


class	LIBKBASE_API	KBMacroReg
{
public	:
	KBMacroReg (cchar *, MKMACRO *) ;
}	;

#define	NEWMACRO(t)							\
									\
	KBMacroInstr							\
		*newMacro##t						\
		(	KBMacroExec	*exec				\
		)							\
	{								\
		return	new KBMacro##t (exec) ;				\
	}								\
	static	KBMacroReg  reg##t (#t, newMacro##t)	;

/*  ------------------------------------------------------------------  */

/*  KBMacroDebugEnable							*/
/*  ------------------							*/
/*  Macro used to turn debugging on or off in on-demand debug mode.	*/

class	LIBKBASE_API	KBMacroDebugEnable : public KBMacroInstr
{
public	:

	KBMacroDebugEnable (KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	  (KBError &) ;
}	;

#endif	// __KB_MACRO_H
