/***************************************************************************
    file	         : kb_listboxpair.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_LISTBOXPAIR_H
#define	__KB_LISTBOXPAIR_H

#include	<qlistbox.h>
#include	<qpushbutton.h>

#include	"libkbase_exports.h"


/*  KBListBoxPair							*/
/*  -------------							*/
/*  This class manipulates a pair of list boxes, allowing the user to	*/
/*  move entries back and forth, and to order the entries in the	*/
/*  destination list. Note that is does *not* do geometry managament.	*/

class	LIBKBASE_API	KBListBoxPair : public QObject
{
	Q_OBJECT

	QListBox	*m_source	;
	QListBox	*m_dest		;
	QPushButton	*m_bAdd		;
	QPushButton	*m_bAddAll	;
	QPushButton	*m_bRemove	;
	QPushButton	*m_bUp		;
	QPushButton	*m_bDown	;
	bool		m_multi		;

signals	:

	void		destChanged	(bool) ;

protected slots	:

	void		clickAdd	() ;
	void		clickAddAll	() ;
	void		clickRemove	() ;
	void		clickUp		() ;
	void		clickDown	() ;

public slots	:

	void		setButtonState	() ;

public	:

	KBListBoxPair
	(	QListBox    *, QListBox    *,
		QPushButton *, QPushButton *,
		QPushButton *, QPushButton *,
		QPushButton *,
		bool = false
	)	;

	/* The "replicate" method is used to replicate entries, and	*/
	/* must be defined in a derived class for this class to be used	*/
	virtual	QListBoxItem	*replicate (QListBoxItem *) = 0 ;
}	;


class	KBListBoxPairText : public KBListBoxPair
{
public	:

	KBListBoxPairText
	(	QListBox    *, QListBox    *,
		QPushButton *, QPushButton *,
		QPushButton *, QPushButton *,
		QPushButton *,
		bool = false
	)	;

	virtual	QListBoxItem	*replicate (QListBoxItem *) ;
}	;

#endif	// __KB_LISTBOXPAIR_H
