/***************************************************************************
    file	         : kb_link.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_LINK_H
#define	_KB_LINK_H

#include	"libkbase_exports.h"

#include	<qdict.h>
#include	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_qtlink.h"

class	KBLinkData
{
public	:

	const QStringList			&m_keyset	;
	const QValueList<const QStringList>	&m_valset	;

	inline	KBLinkData
		(	const QStringList			&keyset,
			const QValueList<const QStringList>	&valset
		)
		:
		m_keyset	(keyset),
		m_valset	(valset)
	{
	}
}	;

/*  KBLink								*/
/*  ----------								*/
/*  This class is used to represent a KBaseLink element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  field.								*/

class	LIBKBASE_API	KBLink : public KBItem
{
	Q_OBJECT

	KBAttrStr	m_child		;
	KBAttrStr	m_show		;
	KBAttrStr	m_fgcolor	;
	KBAttrStr	m_bgcolor	;
	KBAttrStr	m_font		;
	KBAttrStr	m_nullval	;
	KBAttrBool	m_nullOK	;
	KBAttrBool	m_dynamic	;
	KBAttrBool	m_morph		;
	KBAttrUInt	m_showCols	;
	KBEvent		m_onChange	;

	KBQryBase 	*m_query	;

	KBItem	 	*m_iKey		;	/* Dummy for child key	*/
	QList<KBItem>	m_iShow		;	/* Dummy for display	*/

	bool		m_loaded	;	/* Query values loaded	*/
	QStringList	m_keyset	;	/* Key list from query	*/
	QValueList<const QStringList>
			m_valset	;	/* Query display list	*/

	void		addDummyItems 	() ;
	void		remDummyItems	() ;
	void		loadValues	() ;

protected slots	:

	void		showQuery	() ;

protected :

	virtual	KBControl	*makeCtrl    	(uint)	;
	virtual	bool		isMorphing	()	;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg  	() ;
#endif

public	:

	KBLink	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBLink	(KBNode  *, KBLink *) ;

virtual~KBLink	()		 ;

	virtual	void		prepare		()		;
	virtual	void		prepareCtrls    (uint, uint)	;
	virtual	KBValue		getReportValue	(bool, bool = false)		;

	virtual	void		designPopup	(QMouseEvent *, uint) ;

	virtual	QString		getOrderValue	(const KBValue &) ;
	virtual	KB::IType	getOrderType	() ;

	virtual	KBNode		*replicate	(KBNode *)	;
	virtual	void		showAs		(KB::ShowAs)	;
	virtual	bool		keyStroke	(QKeyEvent   *) ;

	KBQryBase		*getQuery	() ;

	bool			checkValid	(uint, bool)	;
	void			userChange	(uint, uint)	;
	KBValue			itemToValue	(uint,		  const QStringList *) ;
	uint			valueToItem	(const KBValue &, const QStringList *) ;
	QString			valueToText	(const KBValue &) ;
	void			doRefresh	(uint) ;

	void			loadValues
				(	const QString                   &,
					const QString                   &,
					QStringList                     &,
					QValueList<const QStringList>   &
                                )       ;

	virtual	void		doSearch	() ;

	virtual	void		setUserFilter   (uint, const QString &) ;
	virtual	void		setUserSorting  (uint, const QString &) ;
	virtual	void		reload          (uint) ;

	inline	bool	dynamic	()
	{
		return	m_dynamic.getBoolValue	() ;
	}
}	;

extern LIBKBASE_API	bool	linkPropDlg (KBLink *, cchar *, QList<KBAttr> &) ;

#endif	// _KB_LINK_H
