/***************************************************************************
    file	         : kb_copysql.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<errno.h>
#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_param.h"

#include	"kb_database.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_select.h"

#include	"kb_copybase.h"
#include	"kb_copysql.h"


/*  KBCopySQL								*/
/*  KBCopySQL	: Constructor for SQL (source) copier			*/
/*  srce	: bool		: Source, else error!			*/
/*  location	: KBLocation &	: Database location			*/
/*  (returns)	: KBCopySQL	:					*/

KBCopySQL::KBCopySQL
	(	bool		srce,
		KBLocation	&location
	)
	:
	srce	 (srce),
	location (location)
{
	select	= 0	;
	qExec	= false	;
}

/*  KBCopySQL								*/
/*  ~KBCopySQL: Destructor for SQL copier				*/
/*  (returns)	:		:					*/

KBCopySQL::~KBCopySQL ()
{
	DELOBJ	(select) ;
}

/*  KBCopySQL								*/
/*  tag		: Get tag for XML output				*/
/*  (returns)	: cchar *	: Tag					*/

cchar	*KBCopySQL::tag ()
{
	return	"sql"	;
}

/*  KBCopySQL								*/
/*  setServer	: Set server						*/
/*  _server	: const QString & : Server name				*/
/*  (returns)	: void		  :					*/

void	KBCopySQL::setServer
	(	const QString	&_server
	)
{
	server	= _server  ;
}

/*  KBCopySQL								*/
/*  setSQL	: Set SQL query						*/
/*  _query	: const QString & : Query				*/
/*  (returns)	: void		  :					*/

void	KBCopySQL::setSQL
	(	const QString	&_query
	)
{
	query	= _query  ;
}

/*  KBCopySQL								*/
/*  set		: Set copier from definition				*/
/*  copy	: QDomElement & : Definition parent			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBCopySQL::set
	(	QDomElement	&copy,
		KBError		&
	)
{
	QDomElement	element	= copy.namedItem(tag()).toElement() ;

	if (element.isNull ()) return true ;
//	{
//		pError	= KBError
//			  (	KBError::Error,
//				QString(TR("Document lacks %1 SQL part")).arg(srce ? "source" : "destination"),
//				QString::null,
//				__ERRLOCN
//			  )	;
//		return	false	;
//	}

	reset	 ()	;
	setSQL	 (element.attribute ("query" )) ;
	setServer(element.attribute ("server")) ;
	return	true	;
}

/*  KBCopySQL								*/
/*  valid	: Check validity					*/
/*  error	: KBError &	: Error return				*/
/*  (returns)	: bool		: Valid					*/

bool	KBCopySQL::valid
	(	KBError		&error
	)
{
	if (server.isEmpty())
	{
		error	= KBError
			  (	KBError::Error,
			  	TR("No server specified for SQL copier"),
			  	QString::null,
			  	__ERRLOCN
			  )	;
		return	false	;
	}

	if (query .isEmpty())
	{
		error	= KBError
			  (	KBError::Error,
			  	TR("No query specified for SQL copier"),
			  	QString::null,
			  	__ERRLOCN
			  )	;
		return	false	;
	}

	return	true	;
}

/*  KBCopySQL								*/
/*  def		: Get table copy definition				*/
/*  copy	: QDomElement &	: Element to which to attach		*/
/*  (returns)	: void		:					*/

void	KBCopySQL::def
	(	QDomElement	&copy
	)
{
	QDomElement	element	;

	copy   .appendChild  (element = copy.ownerDocument().createElement (tag())) ;

	element.setAttribute ("query",  query ) ;
	element.setAttribute ("server", server) ;
}

/*  KBCopySQL								*/
/*  getColumnNames							*/
/*		: Get column names					*/
/*  names	: QStringList &	: List of column names			*/
/*  (returns)	: void		:					*/

void	KBCopySQL::getColumnNames
	(	QStringList	&names
	)
{
	KBSelect select ;
	select.parseQuery (query) ;

	const QValueList<KBSelectExpr> &exprs = select.getExprList() ;
	for (uint idx = 0 ; idx < exprs.count() ; idx += 1)
		names.append (exprs[idx].alias().isEmpty() ? exprs[idx].expr() : exprs[idx].alias()) ;
}

/*  KBCopySQL								*/
/*  prepare	: Prepare for execution					*/
/*  paramDict	: const QDict<QString> &				*/
/*				: Paramater dictionary			*/
/*  other	: KBCopyBase *	: Other half of copier			*/
/*  (returns)	: bool		: Success				*/

bool	KBCopySQL::prepare
	(	const QDict<QString>	&paramDict,
		KBCopyBase		*
	)
{
	if (!srce)
	{
		m_lError = KBError
			   (	KBError::Fault,
				TR("Using copier SQL as destination"),
				QString::null,
				__ERRLOCN
			   )	;
		return	false	;
	}

	DELOBJ	(select)	;
	dbLink.disconnect ()	;
	qExec	= false		;
	sRow	= 0		;

	/* Connect to the database server. If this fails then grab the	*/
	/* error and return false.					*/
	if (!dbLink.connect (location, server))
	{	m_lError = dbLink.lastError () ;
		return	 false	;
	}

	if ((select = dbLink.qrySelect (true, paramSub (query, paramDict))) == 0)
	{	m_lError = dbLink.lastError () ;
		return	 false	;
	}

	return	true	;
}

/*  KBCopySQL								*/
/*  getNumCols	: Get number of columns in copy				*/
/*  (returns)	: int		: Number of columns			*/

int	KBCopySQL::getNumCols ()
{
	/* Need to execute the query to find out how may columns there	*/
	/* are ...							*/
	if (!qExec)
		if (!select->execute (0, 0))
		{	m_lError = select->lastError () ;
			return	 -1 ;
		}

	sRow	= 0 	;
	qExec	= true	;
	return	select->getNumFields () ;
}

/*  KBCopySQL								*/
/*  getRow	: Get next row						*/
/*  values	: KBValue *	: Value vector				*/
/*  nCols	: uint		: Number of columns available		*/
/*  ok		: bool &	: Execute OK				*/
/*  (returns)	: int		: Actual number of columns		*/

int	KBCopySQL::getRow
	(	KBValue		*values,
		uint		,
		bool		&ok
	)
{
	/* Check that this is a source copier, if not then there is an	*/
	/* implementation error.					*/
	if (!srce)
	{
		m_lError = KBError
			   (	KBError::Fault,
				TR("Attempt to use non-source SQL copier"),
				QString::null,
				__ERRLOCN
			   )	;
		ok	= false	;
		return	-1	;
	}

	if (!qExec)
	{
		if (!select->execute (0, 0))
		{	m_lError = select->lastError () ;
			return	 -1 ;
		}

		sRow	= 0	;
		qExec	= true	;
	}

	/* If the row number has exceeded the number of rows available	*/
	/* then all rows have been retrieved. The "ok" value is set	*/
	/* true as there is no error, but return false to indicate the	*/
	/* end of the data.						*/
	if (!select->rowExists(sRow))
	{
		ok	= true	;
		return	-1	;
	}

	/* Copy the next row, increment the row count, and return with	*/
	/* both "ok" set true (no error) and true to indicate that	*/
	/* there is a row of data available.				*/
	for (uint sCol = 0 ; sCol < select->getNumFields() ; sCol += 1)
		values[sCol] = select->getField (sRow, sCol) ;

	sRow   += 1	;
	ok	= true	;
	return	select->getNumFields() ;
}

/*  KBCopySQL								*/
/*  putRow	: Put a row of data					*/
/*  values	: KBValue *	: Value vector				*/
/*  aCols	: uint		: Actual number of columns		*/
/*  (returns)	: bool		: Success				*/

bool	KBCopySQL::putRow
	(	KBValue		*,
		uint		
	)
{
	m_lError = KBError
		   (	KBError::Fault,
		  	TR("Attempt to store copy result through SQL query"),
		  	QString::null,
		  	__ERRLOCN
		   )	;
	return	false	;
}

/*  KBCopySQL								*/
/*  finish	: Finish execution					*/
/*  report	: QString &	: Completion report			*/
/*  (returns)	: bool		: Success				*/

bool	KBCopySQL::finish
	(	QString		&
	)
{
	DELOBJ	(select) ;
	return	true	 ;
}

/*  KBCopySQL								*/
/*  (returns)	: void		:					*/

void	KBCopySQL::reset ()
{
	server	= QString::null ;
	query	= QString::null ;
}

