/***************************************************************************
    file	         : kb_attrmargindlg.h
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_ATTRMARGINDLG_H
#define	_KB_ATTRMARGINDLG_H

#include	"kb_attritem.h"
#include	"kb_attrdlg.h"

class	QSpinBox	;
class	KBAttrMargin	;

/*  KBAttrMarginItem							*/
/*  ----------------							*/
/*  Derived item used in property dialogs to hold temporary values of	*/
/*  attributes, in this case the report margin settings.		*/

class	LIBKBASE_API	KBAttrMarginItem : public KBAttrItem
{
	KBAttrMargin	*m_attrMargin	;
	int		m_lMargin	;
	int		m_rMargin	;
	int		m_tMargin	;
	int		m_bMargin	;

public	:

	KBAttrMarginItem	(KBAttrMargin *);
	~KBAttrMarginItem	()		;

	virtual	QString		displayValue	() ;
	virtual	void		clear		() ;
	virtual	void		save		() ;

	virtual	KBAttrDlg	*getAttrDlg	(QWidget *, QDict<KBAttrItem> &) ;

	friend	class		KBAttrMarginDlg	;
}	;

/*  KBAttrMarginDlg							*/
/*  --------------							*/
/*  Dialog component for margin settings				*/

class	LIBKBASE_API	KBAttrMarginDlg : public KBAttrDlg
{
	Q_OBJECT

	KBAttrMarginItem	*m_attrItem	;

	QSpinBox		*m_lMargin	;
	QSpinBox		*m_rMargin	;
	QSpinBox		*m_tMargin	;
	QSpinBox		*m_bMargin	;

public	:

	KBAttrMarginDlg
	(	QWidget			*,
		KBAttrMargin		*,
		KBAttrMarginItem	*,
		QDict<KBAttrItem>	&
	)	;

	virtual	bool		init		(const QString &) ;
	virtual	bool		init		() ;
	virtual	void		save		() ;
	virtual QString		value		() ;
}	;

#endif	// _KB_ATTRMARGINDLG_H
