/***************************************************************************
    file	         : kb_taborddlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_item.h"

#ifndef 	_WIN32
#include	"kb_taborddlg.moc"
#else
#include	"kb_taborddlg.h"
#endif

#include	"tk_helpproxy.h"


/*  KBTabOrderObject							*/
/*  objectInRange							*/
/*		: Test whether item has coordinate in object range	*/
/*  Object	: KBObject *	: Object in question			*/
/*  axis	: char		: Specifies "x" or "y"			*/
/*  tol		: uint		: Alignment tolerance			*/
/*  (returns)	: bool		: True if in range within telerance	*/

bool	KBTabOrderObject::objectInRange
	(	KBObject	*object,
		cchar		axis,
		uint		tol
	)
{
	QRect	r	= object->geometry() ;
	uint	v	= axis == 'x' ? r.x() : r.y() ;

	/* Note that the following calculation is ordered so that we	*/
	/* work with unsigned values.					*/
	if ((m_minval <= v + tol) && (v <= m_maxval + tol))
	{	if (v < m_minval) m_minval = v ;
		if (v > m_maxval) m_maxval = v ;
		return	true	;
	}

	return	false	;
}


/*  ------------------------------------------------------------------  */

/*  KBTabListObject							*/
/*  comparedTo	: Determin ordering of object with respect to another	*/
/*  other	: KBTabListObject * : Other object			*/
/*  (returns)	: int		    : Sorting value for QT sort methods	*/

int	KBTabListObject::comparedTo
	(	KBTabListObject	*other
	)
{
	/* If the ordering is by the current tab order then simply	*/
	/* compare the current ordering values.				*/
	if (*m_order == byTabOrder)
		return	m_object->getTabOrder() - other->m_object->getTabOrder() ;

	int	tv1	;
	int	tv2	;
	int	ov1	;
	int	ov2	;

	if (*m_order == byColumn)
	{	tv1	= 	 m_orderx->getOrderVal () ;
		tv2	= 	 m_ordery->getOrderVal () ;
		ov1	= other->m_orderx->getOrderVal () ;
		ov2	= other->m_ordery->getOrderVal () ;
	}
	else
	{	tv1	= 	 m_ordery->getOrderVal () ;
		tv2	= 	 m_orderx->getOrderVal () ;
		ov1	= other->m_ordery->getOrderVal () ;
		ov2	= other->m_orderx->getOrderVal () ;
	}

	return	(tv1 == ov1) ? (tv2 - ov2) : (tv1 - ov1) ;	
}



/*  KBTabListObject							*/
/*  coalesce	: Coalesce into orderings				*/
/*  x		: QList<KBTabOrderObject>					*/
/*				: Ordering list for x-axis		*/
/*  y		: QList<KBTabOrderObject>					*/
/*				: Ordering list for y-axis		*/
/*  tol		: uint		: Alignment tolerance			*/
/*  (returns)	: KBTabListObject	:					*/

void	KBTabListObject::coalesce
	(	QList<KBTabOrderObject>	&x,
		QList<KBTabOrderObject>	&y,
		uint			tol
	)
{
	m_orderx	= 0 ;
	m_ordery	= 0 ;

	/* Scan through the x ordering list to see if we have an	*/
	/* overlap with this object. If so then use this overlap, if	*/
	/* not append a new overlap element.				*/
	LITER
	(	KBTabOrderObject,
		x,
		p1,

		if (p1->objectInRange (m_object, 'x', tol))
		{	m_orderx = p1 ;
			break	 ;
		}
	)

	if (m_orderx == 0)
	{	m_orderx = new KBTabOrderObject (m_object->geometry().x()) ;
		x.append (m_orderx) ;
	}

	/* Similarly repeat for the y ordering ...			*/
	LITER
	(	KBTabOrderObject,
		y,
		p2,

		if (p2->objectInRange (m_object, 'y', tol))
		{	m_ordery = p2 ;
			break	 ;
		}
	)

	if (m_ordery == 0)
	{	m_ordery = new KBTabOrderObject (m_object->geometry().y()) ;
		y.append (m_ordery) ;
	}
}

/*  KBTabListObject							*/
/*  KBTabListObject							*/
/*		: Constructor for tab list sorting object		*/
/*  item	: KBObject *	  : Associated object			*/
/*  order	: Order *	  : Ordering type pointer		*/
/*  (returns)	: KBTabListObject :					*/

KBTabListObject::KBTabListObject
	(	KBObject	*object,
		Order		*order
	)
	:
	m_object	(object),
	m_order	(order)
{
	/* This version is used on entry to the tab order dialog, where	*/
	/* we are ordering by the existing tab order.			*/
	m_tabbed = object->getTabOrder() > 0 ;
	m_orderx = 0 ;
	m_ordery = 0 ;
}



/*  ------------------------------------------------------------------  */

/*  KBTabList								*/
/*  compareItems: Comparisom function for tab ordering			*/
/*  _item1	: QCollection::Object : First item			*/
/*  _item2	: QCollection::Object : Second item			*/
/*  (returns)	: int		    L Orderinf value			*/

int	KBTabList::compareItems
	(	QCollection::Item	_item1,
		QCollection::Item	_item2
	)
{
	KBTabListObject	*item1	= (KBTabListObject *)_item1 ;
	KBTabListObject	*item2	= (KBTabListObject *)_item2 ;

	return	item1->comparedTo (item2) ;
}



/*  ------------------------------------------------------------------  */

/*  KBTabListBoxObject							*/
/*  KBTabListBoxObject : Constructor for displayed list entry		*/
/*  listBox	: QListBox *		: Parent list view		*/
/*  object	: KBTabListObject *	: Associated tab list object	*/
/*  (returns)	: KBTabListBoxObject	:				*/

KBTabListBoxObject::KBTabListBoxObject
	(	QListBox	*listBox,
		KBTabListObject	*object
	)
	:
	QListBoxText	(listBox),
	m_object	(object)
{
	QString	name	= m_object->getObject()->getName() ;

	if (name.isEmpty())
		name	= QString(TR("Control %1")).arg(listBox->count()) ;

	setText	(name) ;
}



/*  ------------------------------------------------------------------  */

/*  KBTabOrderDlg							*/
/*  KBTabOrderDlg: Constructor for tab order dialog			*/
/*  block	 : KBBlock *	     : Parent block			*/
/*  objects	 : QList<KBObject> & : List of tab-ordered objects 	*/
/*  (returns)	 : KBTabOrderDlg     :					*/

KBTabOrderDlg::KBTabOrderDlg
	(	KBBlock		*block,
		QList<KBObject>	&objects
	)
	:
	_KBDialog 	(TR("Tab ordering"), true),
	m_block	  	(block),
	m_objects	(objects),
	m_lObjects	(this),
	m_xObjects	(this),
	m_bOK		(this),
	m_bCancel	(this),
	m_bAdd	  	(this),
	m_bRemove	(this),
#if	! __KB_EMBEDDED
	m_bByColumn 	(this),
	m_bByRow	(this),
	m_lTolerance	(this),
	m_sTolerance	(1, 100, 1, this),
#endif
#if	! __KB_EMBEDDED && ! __KB_TKC
	m_bHelp	  	(this),
#endif
	m_bMoveUp	(this),
	m_bMoveDown	(this)
{
	m_layMain   = new QHBoxLayout (this) ;
	m_layMain->addWidget (&m_xObjects) ;

	m_layAddRem = new QVBoxLayout (m_layMain) ;
	m_layMain->addWidget (&m_lObjects) ;

#if	! __KB_EMBEDDED
	m_layRight  = new QGridLayout (m_layMain) ;
#endif

	m_layAddRem->addWidget (&m_bAdd   ) ;
	m_layAddRem->addWidget (&m_bRemove) ;

#if	__KB_EMBEDDED
	m_layAddRem->addWidget (&m_bMoveUp  ) ;
	m_layAddRem->addWidget (&m_bMoveDown) ;
	m_layAddRem->addStretch()  ;
	m_layAddRem->addWidget (&m_bOK	) ;
	m_layAddRem->addWidget (&m_bCancel  ) ;

	m_xObjects	  .setMinimumWidth  ( 75) ;
	m_lObjects	  .setMinimumWidth  ( 75) ;
#else
	m_layAddRem->addStretch()  ;
	m_layRight ->addWidget (&m_bMoveUp,	0, 0) ;
	m_layRight ->addWidget (&m_bMoveDown,	1, 0) ;
	m_layRight ->addWidget (&m_lTolerance,	2, 0) ;
	m_layRight ->addWidget (&m_bOK,	   	5, 0) ;
	m_layRight ->addWidget (&m_bByColumn, 	0, 1) ;
	m_layRight ->addWidget (&m_bByRow,	1, 1) ;
	m_layRight ->addWidget (&m_sTolerance,	2, 1) ;
	m_layRight ->addWidget (&m_bCancel,	5, 1) ;
#if ! __KB_EMBEDDED && ! __KB_TKC
	m_layRight ->addWidget (&m_bHelp,	4, 1) ;
#endif
	m_layRight ->addRowSpacing (3, 64) ;

	m_sTolerance.setValue        (5)   ;
	m_xObjects  .setMinimumWidth (150) ;
	m_lObjects  .setMinimumWidth (150) ;
#endif

	m_xObjects  .setSelectionMode (QListBox::Single) ;
	m_lObjects  .setSelectionMode (QListBox::Single) ;

	m_bOK	   .setText     (TR("OK"       )) ;
	m_bCancel  .setText     (TR("Cancel"   )) ;
	m_bAdd	   .setText     (TR("Add >>"   )) ;
	m_bRemove  .setText     (TR("<< Remove")) ;
	m_bMoveUp  .setText     (TR("Move Up"  )) ;
	m_bMoveDown.setText     (TR("Move Down")) ;

	m_bOK	   .show	() ;
	m_bCancel  .show	() ;
	m_bMoveUp  .show	() ;
	m_bMoveDown.show	() ;

	m_bMoveUp   .setEnabled (false) ;
	m_bMoveDown .setEnabled (false) ;

	connect (&m_bOK,	SIGNAL(clicked ()),      this, SLOT(clickOK       ())) ;
	connect (&m_bCancel,	SIGNAL(clicked ()),      this, SLOT(clickCancel   ())) ;
	connect (&m_bAdd,	SIGNAL(clicked ()),      this, SLOT(clickAdd      ())) ;
	connect (&m_bRemove,	SIGNAL(clicked ()),      this, SLOT(clickRemove   ())) ;
	connect (&m_bMoveUp,	SIGNAL(clicked ()),      this, SLOT(clickMoveUp   ())) ;
	connect (&m_bMoveDown,	SIGNAL(clicked ()),      this, SLOT(clickMoveDown ())) ;
	connect	(&m_lObjects, 	SIGNAL(highlighted(int)),this, SLOT(highlighted(int))) ;

	connect (&m_xObjects,	SIGNAL(doubleClicked(QListBoxObject *)), this, SLOT(clickAdd   ())) ;
	connect (&m_lObjects,	SIGNAL(doubleClicked(QListBoxObject *)), this, SLOT(clickRemove())) ;

#if	!__KB_EMBEDDED
	m_bByColumn .setText     (TR("By Column")) ;
	m_bByRow    .setText     (TR("By Row"   )) ;
	m_lTolerance.setText     (TR("Tolerance")) ;
#if ! __KB_EMBEDDED && ! __KB_TKC
	m_bHelp	    .setText     (TR("Help"     )) ;
#endif
	m_bByColumn .show	 () ;
	m_bByRow    .show	 () ;
	m_lTolerance.show	 () ;
#if ! __KB_EMBEDDED && ! __KB_TKC
	connect (&m_bHelp,     SIGNAL(clicked ()),      this, SLOT(clickHelp     ())) ;
#endif
	connect (&m_bByColumn, SIGNAL(clicked ()),      this, SLOT(clickByColumn ())) ;
	connect (&m_bByRow,    SIGNAL(clicked ()),      this, SLOT(clickByRow    ())) ;
#endif

	m_tabList.setAutoDelete  (true) ;
	m_orderx .setAutoDelete  (true) ;
	m_ordery .setAutoDelete  (true) ;

	/* Add the items to our list and sort them by current tab order	*/
	/* and then load them into the dissplay list box. Note that	*/
	/* blocks and hidden fields are skipped.			*/
	LITER
	(	KBObject,
		m_objects,
		obj,

		if ((obj->isBlock() == 0) && (obj->isHidden() == 0))
			m_tabList.append (new KBTabListObject (obj, &m_order)) ;
	)

	m_order = byTabOrder ;
	m_tabList.sort () ;
	loadListBox    () ;
}

/*  KBTabOrderDlg							*/
/*  loadListBox	: Load list box with item (control) names		*/
/*  (returns)	: void		:					*/

void	KBTabOrderDlg::loadListBox ()
{
	m_lObjects.clear () ;
	m_xObjects.clear () ;

	LITER
	(	KBTabListObject,
		m_tabList,
		object,

		if (object->getTabbed ())
			new KBTabListBoxObject (&m_lObjects, object) ;
		else	new KBTabListBoxObject (&m_xObjects, object) ;
	)
}

void	KBTabOrderDlg::clickHelp ()
{
	TKHelpProxy	*help	= TKHelpProxy::self() ;
	help->showHelpPage ("dialog_taborder") ;
}

/*  KBTabOrderDlg							*/
/*  clickOK	: Handle click of the OK button				*/
/*  (returns)	: void		:					*/

void	KBTabOrderDlg::clickOK ()
{
	LITER
	(	KBObject,
		m_objects,
		obj,
		obj->setTabOrder (0)
	)

	for (uint idx = 0 ; idx < m_lObjects.count () ; idx += 1)
		((KBTabListBoxObject *)m_lObjects.item(idx))->getObject()->getObject()->setTabOrder (idx + 1) ;

	done	(true) ;
}

/*  KBTabOrderDlg							*/
/*  clickCancel	: Handle click of the cancel button			*/
/*  (returns)	: void		:					*/

void	KBTabOrderDlg::clickCancel ()
{
	done	(false) ;
}

#if	! __KB_EMBEDDED

/*  KBTabOrderDlg							*/
/*  positionSort: Sort items on basis of position			*/
/*  _order	: Order		: Required ordering			*/
/*  (returns)	: void		:					*/

void	KBTabOrderDlg::positionSort
	(	Order	_order
	)
{
	m_orderx .clear () ;
	m_ordery .clear () ;

	LITER
	(	KBTabListObject,
		m_tabList,
		obj,
		obj->coalesce (m_orderx, m_ordery, m_sTolerance.value())
	)

	m_order	= _order  ;
	m_tabList.sort () ;
	loadListBox    () ;
}

#endif

/*  KBTabOrderDlg							*/
/*  clickAdd	: Request to add an untabbed item to the tab list	*/
/*  (returns)	: void		:					*/

void	KBTabOrderDlg::clickAdd  ()
{
	int		xidx	;
	int		lidx	;
	QListBoxItem	*item	;

	if ((xidx = m_xObjects.currentItem()) <  0) return ;
	if ((item = m_xObjects.item   (xidx)) == 0) return ;

	m_xObjects.takeItem (item) ;

	if ((lidx  = m_lObjects.currentItem()) < 0) lidx = m_lObjects.count() ;
	m_lObjects.insertItem     (item, lidx + 1) ;
	m_lObjects.setCurrentItem (item) ;

	((KBTabListBoxObject *)item)->getObject()->setTabbed (true) ;

	if ((uint)xidx < m_xObjects.count()) m_xObjects.setCurrentItem (xidx) ;
}

/*  KBTabOrderDlg							*/
/*  clickRemove	: Request to remove a tabbed item from the tab list	*/
/*  (returns)	: void		:					*/

void	KBTabOrderDlg::clickRemove  ()
{
	int		lidx	;
	int		xidx	;
	QListBoxItem	*item	;

	if ((lidx = m_lObjects.currentItem()) <  0) return ;
	if ((item = m_lObjects.item   (lidx)) == 0) return ;

	m_lObjects.takeItem (item) ;

	if ((xidx  = m_xObjects.currentItem()) < 0) xidx = m_xObjects.count() ;
	m_xObjects.insertItem     (item, xidx + 1) ;
	m_xObjects.setCurrentItem (item) ;

	((KBTabListBoxObject *)item)->getObject()->setTabbed (false) ;

	if ((uint)lidx < m_lObjects.count()) m_lObjects.setCurrentItem (lidx) ;
}

/*  KBTabOrderDlg							*/
/*  clickByColumn: Handle click of the by-column button			*/
/*  (returns)	 : void		:					*/

void	KBTabOrderDlg::clickByColumn ()
{
#if	! __KB_EMBEDDED
	positionSort (byColumn)  ;
#endif
}

/*  KBTabOrderDlg							*/
/*  clickByRow	 : Handle click of the by-row button			*/
/*  (returns)	 : void		:					*/

void	KBTabOrderDlg::clickByRow ()
{
#if	! __KB_EMBEDDED
	positionSort (byRow) ;
#endif
}

/*  KBTabOrderDlg							*/
/*  clickMoveUp	 : Handle click of the move-up button			*/
/*  (returns)	 : void		:					*/

void	KBTabOrderDlg::clickMoveUp ()
{
	int		idx	;
	QListBoxItem	*cur	;

	if ((idx = m_lObjects.currentItem()) <= 0) return ;
	if ((cur = m_lObjects.item    (idx)) == 0) return ;

	m_lObjects.takeItem       (cur) ;
	m_lObjects.insertItem     (cur, idx - 1) ;
	m_lObjects.setCurrentItem (cur) ;
}

/*  KBTabOrderDlg							*/
/*  clickMoveDown: Handle click of the move-down button			*/
/*  (returns)	 : void		:					*/

void	KBTabOrderDlg::clickMoveDown ()
{
	int		idx	;
	QListBoxItem	*cur	;

	if ((idx = m_lObjects.currentItem())  < 0) return ;
	if ((cur = m_lObjects.item    (idx)) == 0) return ;
	if (idx >= (int)m_lObjects.count() - 1)    return ;

	m_lObjects.takeItem       (cur) ;
	m_lObjects.insertItem     (cur, idx + 1) ;
	m_lObjects.setCurrentItem (cur) ;
}

/*  KBTabOrderDlg							*/
/*  highlighted	: Used clicks on an entry in the list box		*/
/*  idx		: int		: Highlighted item index		*/
/*  (returns)	: void		:					*/

void	KBTabOrderDlg::highlighted
	(	int	idx
	)
{
	m_bMoveUp  .setEnabled (idx > 0) ;
	m_bMoveDown.setEnabled (idx < (int)m_lObjects.count() - 1) ;
}


/*  tabOrderDlg	: Run the tab order dialog				*/
/*  block	: KBBlock *	     : Parent block			*/
/*  objects	: <QList<KBObject> & : List of tab-ordered objects	*/
/*  (returns)	: bool		     : Success				*/

bool	tabOrderDlg
	(	KBBlock		*block,
		QList<KBObject>	&objects
	)
{
	KBTabOrderDlg tDlg (block, objects) ;
	return	tDlg.exec  () ;
}
