/***************************************************************************
    file	         : kb_script.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#include	<qdict.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_node.h"
#include	"kb_object.h"
#include	"kb_nodereg.h"
#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_notifier.h"

#ifndef		_WIN32
#include 	"kb_script.moc"
#else
#include 	"kb_script.h"
#endif

#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"

#include	"kb_libloader.h"


static	QDict<KBFactory>	factories	;
static	QDict<QString>		identStrings	;


/*  registerScript							*/
/*		: Register scripting language and interpreter factory	*/
/*  language	: const QString & : Language				*/
/*  factory	: KBFactory *	  : Interpreter factory			*/

void LIBKBASE_API
	registerScript
	(	const QString	&language,
		KBFactory	*factory
	)
{
	factories.insert (language, factory) ;
}


/*  ------------------------------------------------------------------  */

/*  KBScript								*/
/*  KBScript	: Constructor for script node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: Attribute list			*/
/*		: bool *	:					*/
/*  (returns)	: KBScript	:					*/

KBScript::KBScript
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBModule (parent, "KBScript", aList)
{
}

/*  KBScript								*/
/*  KBScript	: Constructor for script node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  name	: cchar *	: Module name				*/
/*  (returns)	: KBScript	:					*/

KBScript::KBScript
	(	KBNode	*parent,
		cchar	*name
	)
	:
	KBModule (parent, "KBScript", name)
{
}

/*  KBScript								*/
/*  KBScript	: Constructor for script node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  entant	: KBScript *	: Extant node				*/
/*  (returns)	: KBScript	:					*/

KBScript::KBScript
	(	KBNode		*parent,
		KBScript	*extant
	)
	:
	KBModule (parent, "KBScript", extant)
{
}


/*  KBScript								*/
/*  ~KBScript	: Destructor for script node				*/
/*  (returns)	:		:					*/

KBScript::~KBScript ()
{
}

/*  ------------------------------------------------------------------  */

/*  KBScriptIF								*/
/*  KBScriptIF	: Constructor for script base class			*/
/*  (returns)	: KBScriptIF	:					*/

KBScriptIF::KBScriptIF ()
{
}

/*  KBScriptIF								*/
/*  ~KBScriptIF	: Destructor for script base class			*/
/*  (returns)	:		:					*/

KBScriptIF::~KBScriptIF ()
{
}

/*  KBScriptIF								*/
/*  editorInit	: Initialise the editor colouring			*/
/*  editWin	: TKTextEditor * : Editor				*/
/*  (returns)	: void		 :					*/

void	KBScriptIF::editorInit
	(	TKTextEditor	*
	)
{
	/* Default does nothing.					*/
}

/*  KBScriptIF								*/
/*  showDebug	: Show debugger if possible				*/
/*  action	: TKToggleAction * : Toggle button			*/
/*  (returns)	: KBDebug *	   : Debugger widget			*/

KBDebug	*KBScriptIF::showDebug
	(	TKToggleAction	*
	)
{
	/* Default does nothing.					*/
	return	0 ;
}

/*  KBScriptIF								*/
/*  debugScript	: Load script into debugger				*/
/*  location	: KBLocation &	: Script loaation			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBScriptIF::debugScript
	(	KBLocation	&,
		KBError		&pError
	)
{
	pError	= KBError
		  (	KBError::Error,
			TR("Scripts cannot be loaded directly into debugger"),
			QString::null,
			__ERRLOCN
		  )	;
	return	false	;
}

void	KBScriptIF::addIdentString
	(	const QString	&lang,
		const QString	&ident
	)
{
	identStrings.setAutoDelete (true) ;
	identStrings.replace	   (lang, new QString(ident)) ;
}

QString	KBScriptIF::getIdentStrings ()
{
	QString			res  ;
	QDictIterator<QString>	iter (identStrings) ;

	while (iter.current() != 0)
	{
		res	+= QString("<tr><td>Script</td><td><b>%1</b></td><td><nobr>%2</nobr></td></tr>")
				  .arg( iter.currentKey())
				  .arg(*iter.current   ()) ;

		iter	+= 1 ;
	}

	return	res	;
}

/*  ------------------------------------------------------------------  */

/*  LinkKBScript: Link to database scripting language			*/
/*  name	: const QString & : Scripting language name		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: KBScriptIF *	  : Script interface object or null	*/

KBScriptIF
	*LinkKBScript
	(	const QString	&name,
		KBError		&pError
	)
{
	KBFactory *factory = factories.find (name) ;
	/*if (factory == 0)
	{
		pError	= KBError
			  (	KBError::Fault,
				QString (TR("Cannot locate script library for \"%1\"")).arg(name),
				"",
				__ERRLOCN
			  )	;
		return	0	;
	}*/

	KBScriptIF *iface = (KBScriptIF*)0L;
	iface =	(KBScriptIF *)factory->create(0, "scriptiface", "") ;
	if (iface == 0)
	{
		pError	= KBError
			  (	KBError::Fault,
				QString ("Cannot create script interface for \"%1\"").arg(name), 
				"",
				__ERRLOCN
			  )	;
		return	0	;
	}

	iface->setApp  (KBNotifier::self(), KBAppPtr::getCallback()) ;
	KBScriptIF::addIdentString (name, iface->ident()) ;

	return	iface	;
}

/*  KBScript								*/
/*  replicate	: Replicate this parameter				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New choice node			*/

KBNode	*KBScript::replicate
	(	KBNode	*_parent
	)
{
	return	new KBScript (_parent, this) ;
}


NEWNODE(Script, (cchar *)0, KF_FORM|KF_REPORT)


/*  ------------------------------------------------------------------  */

/*  KBScriptItem							*/
/*  ~KBScriptItem: Destructor for script items				*/
/*  (returns)	 :		:					*/

KBScriptItem::~KBScriptItem ()
{
}

/*  KBScriptItem							*/
/*  makeModule	: Instantiate a script module				*/
/*  parent	: KBNode *	  : Parent node				*/
/*  name	: const QString & : Script name				*/
/*  (returns)	: KBModule *	  : New script module			*/

KBModule*KBScriptItem::makeModule
	(	KBNode		*parent,
		const QString	&name
	)
{
	return	new KBScript (parent, name) ;
}

/*  ------------------------------------------------------------------  */

/*  KBScriptDlg								*/
/*  KBScriptDlg	: Constructor for script list dialog			*/
/*  parent	: QWidget *	    : Parent widget			*/
/*  node	: KBNode *	    : Parent node			*/
/*  modules	: QList<KBModule> & : List of scripts			*/
/*  (returns)	: KBScriptDlg	    :					*/

KBScriptDlg::KBScriptDlg
	(	QWidget		*parent,
		KBNode		*node,
		QList<KBModule>	&modules
	)
	:
	KBModuleDlg (parent, node)
{
	setModules  (modules) ;
}

/*  KBScriptDlg								*/
/*  ~KBScriptDlg: Constructor for script list dialog			*/
/*  (returns)	:		:					*/

KBScriptDlg::~KBScriptDlg()
{
}

/*  KBScriptDlg								*/
/*  makeModuleItem: Make item for script				*/
/*  listBox	  : QListBox *	  : Parent list box			*/
/*  module	  : KBModule *	  : Actually the script			*/
/*  (returns)	  : KBModuleItem  : Script item				*/

KBModuleItem
	*KBScriptDlg::makeModuleItem
	(	QListBox	*listBox,
		KBModule	*module
	)
{
	return	new KBScriptItem (listBox, module->isScript()) ;
}

/*  KBScriptDlg								*/
/*  makeModuleItem: Make item for script				*/
/*  listBox	  : QListBox *	    : Parent list box			*/
/*  name	  : const QString & : Script name			*/
/*  (returns)	  : KBModuleItem    : Script item			*/

KBModuleItem
	*KBScriptDlg::makeModuleItem
	(	QListBox	*listBox,
		const QString	&name
	)
{
	return	new KBScriptItem (listBox, name) ;
}


/*  ------------------------------------------------------------------  */

KBScriptObject::KBScriptObject ()
{
}

KBScriptObject::~KBScriptObject ()
{
}

