/***************************************************************************
    file	         : kb_qrytabledlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_dbinfo.h"
#include	"kb_docroot.h"
#include	"kb_queryset.h"
#include	"kb_qrytable.h"
#include	"kb_qrytabledlg.h"
#include	"kb_table.h"
#include	"kb_primarydlg.h"

#include	"tk_messagebox.h"


/*  ------------------------------------------------------------------  */

/*  KBAttrPrimaryItem							*/
/*  KBAttrPrimaryItem							*/
/*		: Constructor for attribute value display object	*/
/*  attr	: KBAttr *	: Underlying attribute			*/
/*  (returns)	: void		:					*/

KBAttrPrimaryItem::KBAttrPrimaryItem
	(	KBAttr		*attr
	)
	:
	KBAttrItem (attr)
{
	m_uTypeAttr	= 0	;
	m_uExprAttr	= 0	;
	m_utype		= (KBTable::UniqueType)0 ;
}

/*  KBAttrPrimaryItem							*/
/*  ~KBAttrPrimaryItem							*/
/*		: Destructor for attribute value display object		*/
/*  (returns)	:		:					*/

KBAttrPrimaryItem::~KBAttrPrimaryItem ()
{
}


/*  KBAttrPrimaryItem							*/
/*  setType	: Set primary type attribute				*/
/*  attr	: KBAttrInt *	: The attribute				*/
/*  (returns)	: vid		:					*/

void	KBAttrPrimaryItem::setType
	(	KBAttr		*typeAttr,
		KBAttr		*exprAttr
	)
{
	m_uTypeAttr	= typeAttr	;
	m_uExprAttr	= exprAttr	;
	m_utype		= (KBTable::UniqueType)typeAttr->getValue().toInt() ;
	m_uexpr		= exprAttr->getValue() ;
}

/*  KBAttrPrimaryItem							*/
/*  setType	: Set primary type value				*/
/*  utype	: UniqueType	: Unique type				*/
/*  (returns)	: void		:					*/

void	KBAttrPrimaryItem::setType
	(	KBTable::UniqueType	utype,
		const QString		&uexpr
	)
{
	m_utype	= utype	;
	m_uexpr	= uexpr	;
}

/*  KBAttrPrimaryItem							*/
/*  getType	: Get primary type attribute				*/
/*  (returns)	: UniqueType	: Value set				*/

KBTable::UniqueType
	KBAttrPrimaryItem::getType
	(	QString		&uexpr
	)
{
	uexpr =	m_uexpr	;
	return	m_utype	;
}


/*  KBAttrPrimaryItem							*/
/*  displayValue: Get properties dialog display value			*/
/*  (returns)	: QString	: Display value				*/

QString	KBAttrPrimaryItem::displayValue ()
{
	switch (m_utype)
	{
		case KBTable::Auto	 :
			return	TR("[Auto]") ;

		case KBTable::PrimaryKey :
			return	QString(TR("Primary: %1" )).arg(m_value) ;

		case KBTable::AnyUnique  :
			return	QString(TR("Unique: %1"  )).arg(m_value) ;

		case KBTable::AnySingle  :
			return	QString(TR("Any: %1"	 )).arg(m_value) ;

		case KBTable::PreExpression :
			return	QString(TR("Pre-Expression: %1, %2" )).arg(m_value).arg(m_uexpr) ;

		case KBTable::PostExpression :
			return	QString(TR("Post-Expression: %1, %2")).arg(m_value).arg(m_uexpr) ;

#ifdef	__NOTYET
		case KBTable::Multiple	 :
			return	QString(TR("Multiple: %1")).arg(m_value) ;

		case KBTable::TableSetup :
			return	TR("[Uses table setup]") ;
#endif

		case KBTable::Legacy100  :
			return	m_value	 ;

		default	:
			break	;
	}

	return	TR("#Error#")	;
}

/*  KBAttrPrimaryItem							*/
/*  save	: Save values						*/
/*  (returns)	: void		:					*/

void	KBAttrPrimaryItem::save ()
{
	KBAttrItem::save() ;
	m_uTypeAttr->setValue (QString("%1").arg((int)m_utype)) ;
	m_uExprAttr->setValue (m_uexpr) ;
}


/*  ------------------------------------------------------------------  */

/*  KBQryTablePropDlg							*/
/*  KBQryTablePropDlg							*/
/*		: Constructor for query properties dialog		*/
/*  query	: KBQryData *	   : Query				*/
/*  caption	: cchar *  	   : Dialog box caption			*/
/*  attribs	: QList<KBAttr>&   : List of attributes			*/
/*  (returns)	: KBQryTablePropDlg:					*/

KBQryTablePropDlg::KBQryTablePropDlg
	(	KBQryData	*query,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
	:
	KBPropDlg	(query, caption, attribs),
	m_query		(query)
{
	m_primaryDlg	= new KBPrimaryDlg (&topWidget, m_tabSpec) ;
	m_warn		= false ;
	m_primaryItem 	= 0 	;
	m_ptypeAttr 	= 0 	;
	m_pexprAttr 	= 0 	;
	m_primaryDlg->hide () 	;
}

/*  KBQryTablePropDlg							*/
/*  ~KBQryTablePropDlg							*/
/*		: Destructor for query properties dialog		*/
/*  (returns)	: void		:					*/

KBQryTablePropDlg::~KBQryTablePropDlg ()
{
}

/*  KBQryTablePropDlg							*/
/*  getAttrItem	: Get attribute item for attribute			*/
/*  attr	: KBAttr *	: Attribute				*/
/*  (returns)	: KBAttrItem *	: Associated attribute item		*/

KBAttrItem
	*KBQryTablePropDlg::getAttrItem
	(	KBAttr		*attr
	)
{
	if (attr->getName() == "primary")
		return	m_primaryItem = new KBAttrPrimaryItem (attr) ;

	return	KBPropDlg::getAttrItem (attr) ;
}

/*  KBQryTablePropDlg							*/
/*  hideProperty: Check whether property should be hidden		*/
/*  attr	: KBAttr *	: Attribute in question			*/
/*  (returns)	: void		:					*/

bool	KBQryTablePropDlg::hideProperty
	(	KBAttr	*attr
	)
{
	if (attr->getName() == "ptype")
	{
		m_ptypeAttr = attr ;
		return	true	 ;
	}

	if (attr->getName() == "pexpr")
	{
		m_pexprAttr = attr ;
		return	true	 ;
	}

	return	KBPropDlg::hideProperty (attr) ;
}

/*  KBQryTablePropDlg							*/
/*  preExec	: Pre-execute hook					*/
/*  (returns)	: void		:					*/

void	KBQryTablePropDlg::preExec ()
{
	m_warn = ! getProperty("server").isEmpty() ;

	if ( !getProperty ("server").isEmpty() &&
	     !getProperty ("table" ).isEmpty() ) getTableSpec () ;

	/* Pass the unique type attribute to the primary attribute, so	*/
	/* that the latter has access to both.				*/
	m_primaryItem->setType (m_ptypeAttr, m_pexprAttr) ;
	m_primaryItem->display () ;
//	LITER
//	(	QListViewItem,
//		primaryItem->lvitems,
//		lvi,
//		lvi->setText (1, primaryItem->displayValue()) ;
//	)
}

/*  KBQryTablePropDlg							*/
/*  getTableSpec: Get table specification				*/
/*  (returns)	: bool		: Success				*/

bool	KBQryTablePropDlg::getTableSpec ()
{
	cchar		*dbName ;
	cchar		*tbName ;
	KBDBLink	dbLink	;

	if ((dbName = getProperty ("server")) == 0)
		return	warning (TR("Please specify a server name")) ;

	if ((tbName = getProperty ("table"   )) == 0)
		return	warning (TR("Please specify a table name")) ;

	if (!dbLink.connect (m_query->getDocRoot()->getLocation(), dbName))
	{
		dbLink.lastError().DISPLAYCAP(TR("Cannot connect to server")) ;
		return	false	;
	}

	m_tabSpec.reset (tbName)	;
	if (!dbLink.listFields (m_tabSpec))
	{
		dbLink.lastError().DISPLAYCAP(TR("Cannot get list of fields")) ;
		return	false	;
	}

	return	true	;
}

/*  KBQryTablePropDlg							*/
/*  findPrimary	: Find preferred primary key				*/
/*  (returns)	: void		:					*/

void	KBQryTablePropDlg::findPrimary ()
{
	if (!getTableSpec ())
		return ;

	if (m_tabSpec.m_prefKey < 0)
	{
		KBError::EWarning
		(	TR("Unable to determine primary key column"),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	setProperty ("primary", m_tabSpec.m_fldList.at(m_tabSpec.m_prefKey)->m_name) ;
}

/*  KBQryTablePropDlg							*/
/*  checkPrimary: Check columns acceptability for the primary key	*/
/*  fName	: const QString & : Column name				*/
/*  (returns)	: bool		  : Acceptable				*/

bool	KBQryTablePropDlg::checkPrimary
	(	const QString	&fName
	)
{
	/* Scan the field list for the specified column. It is a fatal	*/
	/* error if it cannot be found ....				*/
	LITER
	(	KBFieldSpec,
		m_tabSpec.m_fldList,
		fSpec,

		if (fSpec->m_name == fName)
		{
			/* First check is that the column is		*/
			/* identified as unique. If it is not then it	*/
			/* is no more use than not having a primary	*/
			/* column at all.				*/
			if ((fSpec->m_flags & KBFieldSpec::Unique  ) == 0)
			{	TKMessageBox::sorry
					(	0,
						QString (TR("Column %1 is not marked as unique")).arg(fName),
						TR("Unique key column")
					)	;
				return	false	;
			}

			/* See if the column value is available after	*/
			/* a row insertion. If not then it is usable,	*/
			/* but row insert will be diabled.		*/
			if ((fSpec->m_flags & KBFieldSpec::InsAvail) == 0)
				if (TKMessageBox::questionYesNo
					(	0,
						QString (TR("Column %1 cannot be retrieved after row insertion.\n"
							    "Row insertion will be disabled: Use it anyway?"))
							.arg(fName),
						TR("Unique key column")
					)
					!= TKMessageBox::Yes) return false ;

			/* OK, we can use it ...			*/
			return	true	;
		}
	)

	KBError::EFault
	(	TR("Lost field from table specification"),
		fName,
		__ERRLOCN
	)	;

	return	false	;
}

/*  KBQryTablePropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBQryTablePropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName	= item->attr()->getName() ;

	/* Tables							*/
	/* Create a combo box and fill it with a list of tables in the	*/
	/* current database, selecting the current table if there is	*/
	/* one.								*/
	if (aName == "table")
	{
		KBTableDetailsList	tabList ;
		cchar			*dbName	;
		KBDBLink		dbLink	;
		int	       		at = -1 ;

		if ((dbName = getProperty ("server")) == 0)
			return	warning ("Please specify a server name") ;

		if (!dbLink.connect (m_query->getDocRoot()->getLocation(), dbName))
		{
			dbLink.lastError().DISPLAYCAP(TR("Cannot connect to server")) ;
			return	false	;
		}

		if (!dbLink.listTables (tabList))
		{
			dbLink.lastError().DISPLAYCAP(TR("Cannot get list of tables")) ;
			return	false	;
		}

		comboBox.show () ;

		for (uint idx = 0 ; idx < tabList.count() ; idx += 1)
		{
			const QString	&table = tabList[idx].m_name ;
			if (table.left(2) == "__") continue ;

			comboBox.insertItem (table) ;
			if (table == item->value())
				at = comboBox.count() - 1 ;
		}

		if (at >= 0) comboBox.setCurrentItem (at) ;
		return	true ;
	}

	/* Primary							*/
	/* This is the primary key column (although for our purposes,	*/
	/* any unique column will suffice). Display the primary dialog.	*/
	if (aName == "primary")
	{
		QString		    expr ;
		KBTable::UniqueType ut   = m_primaryItem->getType(expr) ;

		m_primaryDlg->set (item->value(), ut, expr) ;

		setUserWidget (m_primaryDlg) ;
		return	true ;

	}

	if ((aName == "where") || (aName == "order"))
	{
		int	at = -1	 ;

		editBox .show () ;
		comboBox.show () ;

		LITER
		(	KBFieldSpec,
			m_tabSpec.m_fldList,
			fSpec,

			comboBox.insertItem (fSpec->m_name) ;
			if (fSpec->m_name == item->value())
				at = comboBox.count() - 1 ;
		)

		if (at >= 0) comboBox.setCurrentItem (at) ;

		editBox.insert  	   (item->value ()) ;
		editBox.setFocus    	   () ;
		editBox.setCursorPosition  (0xffff, 0xffff) ;

		connect (&comboBox, SIGNAL (activated(const QString &)),
			 this,      SLOT   (pickCombo(const QString &))) ;
		return	true ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBQryTablePropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName	= item->attr()->getName () ;

	/* Server							*/
	/* If this has changed thn copy the result back, and clear the	*/
	/* table and primary key attributes.				*/
	if (aName == "server")
	{
		QString	oldVal	= item->value() ;
		KBPropDlg::saveProperty  (item) ;

		if (getProperty("server") != oldVal)
		{
			if (m_warn)
			{
				KBError::EWarning
				(	TR("Changing the server or table will probably invalidate the form or report structure"),
					QString::null,
					__ERRLOCN
				)	;
				m_warn	= false	;
			}

			setProperty ("table",   "") ;
			setProperty ("primary", "") ;
		}

		return	true ;
	}

	/* Table							*/
	/* Note the table. If both the table and the server are set 	*/
	/* then attempt to determin the primary key.			*/
	if (aName == "table")
	{
		if (comboBox.currentText() != item->value())
		{
			if (m_warn)
			{
				KBError::EWarning
				(	TR("Changing the server or table will probably invalidate the form or report structure"),
					QString::null,
					__ERRLOCN
				)	;
				m_warn	= false	;
			}

			setProperty ("table",    comboBox.currentText()) ;
			setProperty ("primary",  "") ;

			if (!getProperty("server").isEmpty()) findPrimary () ;
		}

		return	true ;
	}

	/* Primary							*/
	/* Similar, but his time we don't clear anything!		*/
	if (aName == "primary")
	{
		QString	value	;
		QString	expr	;

		KBTable::UniqueType utype = m_primaryDlg->retrieve (value, expr) ;

		m_primaryItem->setType (utype, expr) ;
		setProperty    ("primary", value) ;
		return	true ;
	}

	return	KBPropDlg::saveProperty (item) ;
}

void	KBQryTablePropDlg::clickOK()
{
	QString	expr	;

	switch (m_primaryItem->getType(expr))
	{
		case KBTable::Auto	 :
			break	;

//		case KBTable::PreExpression  :
//		case KBTable::PostExpression :
//			if (expr.isEmpty())
//			{
//				warning	(TR("No expression specified for unique column")) ;
//				return	;
//			}

		default	:
			if (m_primaryItem->value().isEmpty())
			{
				warning (m_primaryItem->attr()->getNullcheck ()) ;
				return	;
			}
			break	;
	}


	KBPropDlg::clickOK() ;
}
	

/*  qryTablePropDlg							*/
/*		: Run table query properties dialog			*/
/*  query	: KBQryData *	 : Query				*/
/*  caption	: cchar *  	 : Dialog box caption			*/
/*  attribs	: QList<KBAttr>& : List of attributes			*/
/*  (returns)	: bool		 : Success				*/

bool	queryTablePropDlg
	(	KBQryTable	*query,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
{
	KBQryTablePropDlg qDlg (query, caption, attribs) ;
	return	qDlg.exec () ;
}
