/***************************************************************************
    file	         : kb_optionsdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	<stdlib.h>

#include	<qfile.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_dialog.h"
#include	"kb_options.h"
#include	"kb_optionsdlg.h"
#include	"kb_font.h"
#include	"kb_wizard.h"
#include	"kb_locator.h"

#include	"tk_messagebox.h"
#include	"tk_fontdialog.h"


#ifndef 	_WIN32
#include	"kb_optionsdlg.moc"
#else
#include	"kb_optionsdlg.h"
#endif



/*  ------------------------------------------------------------------  */

/*  KBVerifyOpts							*/
/*  KBVerifyOpts: Constructor for verification page			*/
/*  parent	: QWidget *	: Parent				*/
/*  options	: KBOptions &	: Options object			*/
/*  (returns)	: void		:					*/

KBVerifyOpts::KBVerifyOpts
	(	QWidget 	*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "verify"),
	m_options	(options),
	m_lInsert	(this),
	m_lUpdate	(this),
	m_lDelete	(this),
	m_lMulti	(this),
	m_cbInsert	(this),
	m_cbUpdate	(this),
	m_cbDelete	(this),
	m_cbMulti	(this),
	m_layout	(this)
{
	m_layout.addWidget (&m_lInsert,	   0, 0) ;
	m_layout.addWidget (&m_lUpdate,	   1, 0) ;
	m_layout.addWidget (&m_lDelete,	   2, 0) ;
	m_layout.addWidget (&m_lMulti,     3, 0) ;

	m_layout.addWidget (&m_cbInsert,   0, 1) ;
	m_layout.addWidget (&m_cbUpdate,   1, 1) ;
	m_layout.addWidget (&m_cbDelete,   2, 1) ;
	m_layout.addWidget (&m_cbMulti,    3, 1) ;

	m_layout.setRowStretch (4, 1) ;

	m_lInsert .setText (TR("Verify inserts"		 )) ;
	m_lUpdate .setText (TR("Verify updates"		 )) ;
	m_lDelete .setText (TR("Verify deletes"		 )) ;
	m_lMulti  .setText (TR("Verify multirecord sync")) ;

	m_cbInsert.insertItem ("Never"   ) ;
	m_cbInsert.insertItem ("Always"  ) ;
	m_cbInsert.insertItem ("Multiple") ;

	m_cbUpdate.insertItem ("Never"   ) ;
	m_cbUpdate.insertItem ("Always"  ) ;
	m_cbUpdate.insertItem ("Multiple") ;

	m_cbDelete.insertItem ("Never"   ) ;
	m_cbDelete.insertItem ("Always"  ) ;
	m_cbDelete.insertItem ("Multiple") ;

	m_cbMulti .insertItem ("No")	 ; ;
	m_cbMulti .insertItem ("Yes")	 ; ;

	m_cbInsert.setCurrentItem (m_options.verInsert  ) ;
	m_cbUpdate.setCurrentItem (m_options.verUpdate  ) ;
	m_cbDelete.setCurrentItem (m_options.verDelete  ) ;
	m_cbMulti .setCurrentItem (m_options.verMultiple) ;
}

/*  KBVerifyOpts							*/
/*  save	: Save verification settings				*/
/*  config	: TKConfig *	: Configuration				*/
/*  (returns)	: void		:					*/

void	KBVerifyOpts::save
	(	TKConfig	*config
	)
{
#if	! __KB_RUNTIME
	m_options.verInsert	= (KBOptions::VerifyOption)m_cbInsert.currentItem() ;
	m_options.verUpdate	= (KBOptions::VerifyOption)m_cbUpdate.currentItem() ;
	m_options.verDelete	= (KBOptions::VerifyOption)m_cbDelete.currentItem() ;
	m_options.verMultiple	= m_cbMulti.currentItem() ;

	config->writeEntry ("verInsert",  m_options.verInsert  ) ;
	config->writeEntry ("verUpdate",  m_options.verUpdate  ) ;
	config->writeEntry ("verDelete",  m_options.verDelete  ) ;
	config->writeEntry ("verMulti",   m_options.verMultiple) ;
#endif
}



/*  ------------------------------------------------------------------  */

/*  KBLayoutOpts							*/
/*  KBLayoutOpts: Constructor for layout page				*/
/*  parent	: QWidget *	: Parent				*/
/*  options	: KBOptions &	: Options object			*/
/*  (returns)	: void		:					*/

KBLayoutOpts::KBLayoutOpts
	(	QWidget 	*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "layout"),
	m_options	(options),
	m_lGrid		(this),
	m_lGridX	(this),
	m_lGridY	(this),
	m_lForm		(this),
	m_lFormW	(this),
	m_lFormH	(this),
	m_lDefD		(this),
	m_lDefDX	(this),
	m_lDefDY	(this),
	m_lSpace	(this),
	m_sGridX	(  4,   40, 1, this),
	m_sGridY	(  4,   40, 1, this),
	m_sFormW	( 10, 2000, 1, this),
	m_sFormH	( 10, 2000, 1, this),
	m_sDefDX	(  0,  100, 1, this),
	m_sDefDY	(  0,  100, 1, this),
	m_sSpace	( 10,  100, 1, this),
	m_layout	(this)
{
	m_layout.addWidget (&m_lGrid,	0, 0) ;
	m_layout.addWidget (&m_lGridX,	0, 1) ;
	m_layout.addWidget (&m_sGridX,	0, 2) ;
	m_layout.addWidget (&m_lGridY,	0, 3) ;
	m_layout.addWidget (&m_sGridY,	0, 4) ;

	m_layout.addWidget (&m_lForm,	1, 0) ;
	m_layout.addWidget (&m_lFormW,	1, 1) ;
	m_layout.addWidget (&m_sFormW,	1, 2) ;
	m_layout.addWidget (&m_lFormH,	1, 3) ;
	m_layout.addWidget (&m_sFormH,	1, 4) ;

	m_layout.addWidget (&m_lDefD,	2, 0) ;
	m_layout.addWidget (&m_lDefDX,	2, 1) ;
	m_layout.addWidget (&m_sDefDX,	2, 2) ;
	m_layout.addWidget (&m_lDefDY,	2, 3) ;
	m_layout.addWidget (&m_sDefDY,	2, 4) ;

	m_layout.addWidget (&m_lSpace,	3, 0) ;
	m_layout.addWidget (&m_sSpace,	3, 2) ;

	m_layout.setRowStretch (4, 1) ;

	m_lGridX.setAlignment(AlignRight|AlignVCenter)	;
	m_lGridY.setAlignment(AlignRight|AlignVCenter)	;
	m_lFormW.setAlignment(AlignRight|AlignVCenter)	;
	m_lFormH.setAlignment(AlignRight|AlignVCenter)	;
	m_lDefDX.setAlignment(AlignRight|AlignVCenter)	;
	m_lDefDY.setAlignment(AlignRight|AlignVCenter)	;

	m_lGrid .setText   (TR("Design grid"	))	;
	m_lGridX.setText   (TR("X"))			;
	m_lGridY.setText   (TR("Y"))			;

	m_lForm .setText   (TR("Form default"	))	;
	m_lFormW.setText   (TR("Width" 		))	;
	m_lFormH.setText   (TR("Height"		))	;

	m_lDefD .setText   (TR("Block default"	))	;
	m_lDefDX.setText   (TR("DX"))			;
	m_lDefDY.setText   (TR("DY"))			;

#if	__KB_EMBEDDED
	m_lSpace.setText   (TR("Ctrl spacing"	))	;
#else
	m_lSpace.setText   (TR("Control spacing"))	;
#endif

	m_sGridX .setValue    (m_options.gridX) ;
	m_sGridY .setValue    (m_options.gridY) ;
	m_sFormW .setValue    (m_options.formW) ;
	m_sFormH .setValue    (m_options.formH) ;
	m_sDefDX .setValue    (m_options.defDX) ;
	m_sDefDY .setValue    (m_options.defDY) ;
	m_sSpace .setValue    (m_options.space) ;

	m_sGridX .setRange    (    1,   50) ;
	m_sGridY .setRange    (    1,   50) ;
	m_sFormW .setRange    (    1, 5000) ;
	m_sFormH .setRange    (    1, 5000) ;
	m_sDefDX .setRange    (-1000, 1000) ;
	m_sDefDY .setRange    (-1000, 1000) ;
	m_sSpace .setRange    (    0, 1000) ;
}

/*  KBLayoutOpts							*/
/*  save	: Save layout settings					*/
/*  config	: TKConfig *	: Configuration				*/
/*  (returns)	: void		:					*/

void	KBLayoutOpts::save
	(	TKConfig	*config
	)
{
#if	! __KB_RUNTIME
	m_options.gridX	= m_sGridX.cleanText().toInt() ;
	m_options.gridY	= m_sGridY.cleanText().toInt() ;
	m_options.formW	= m_sFormW.cleanText().toInt() ;
	m_options.formH	= m_sFormH.cleanText().toInt() ;
	m_options.defDX	= m_sDefDX.cleanText().toInt() ;
	m_options.defDY	= m_sDefDY.cleanText().toInt() ;
	m_options.space	= m_sSpace.cleanText().toInt() ;

	config->writeEntry ("gridX",  m_options.gridX) ;
	config->writeEntry ("gridY",  m_options.gridY) ;
	config->writeEntry ("formW",  m_options.formW) ;
	config->writeEntry ("formH",  m_options.formH) ;
	config->writeEntry ("defDX",  m_options.defDX) ;
	config->writeEntry ("defDY",  m_options.defDY) ;
	config->writeEntry ("space",  m_options.space) ;
#endif
}



/*  ------------------------------------------------------------------  */

/*  KBInterfaceOpts							*/
/*  KBInterfaceOpts							*/
/*		: Constructor for interface page			*/
/*  parent	: QWidget *	: Parent				*/
/*  options	: KBOptions &	: Options object			*/
/*  (returns)	: void		:					*/

KBInterfaceOpts::KBInterfaceOpts
	(	QWidget 	*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "interface"),
	m_options	(options),
#if	! __KB_EMBEDDED
	m_useGroup	(TR("SDI/MDI Mode"), this),
	m_useMDI	(&m_useGroup),
	m_useSDI	(&m_useGroup),
#endif
	m_openLast	(this),
	m_singleDBOnly	(this),
	m_bSetup	(this),
	m_layout	(this)
{
#if	! __KB_EMBEDDED
	m_useMDI.setText    (TR("Use MDI")) ;
	m_useSDI.setText    (TR("Use SDI")) ;
	m_useMDI.setChecked (  m_options.useMdi) ;
	m_useSDI.setChecked (! m_options.useMdi) ;
	m_layout.addWidget  (&m_useGroup) ;
#endif
	m_openLast	.setText    (TR("Open last database at start-up")) ;
	m_singleDBOnly	.setText    (TR("Allow only one open database" )) ;
	m_bSetup	.setText    (TR("Rerun setup wizard")) ;

	m_layout	.addWidget  (&m_openLast    	   ) ;
	m_layout	.addWidget  (&m_singleDBOnly       ) ;
	m_layout	.addWidget  (&m_bSetup	           ) ;
	m_openLast	.setChecked (m_options.openLast	   ) ;
	m_singleDBOnly	.setChecked (m_options.singleDBOnly) ;

	connect	(&m_bSetup, SIGNAL(clicked()), SLOT(resetSetup())) ;
}

void	KBInterfaceOpts::save
	(	TKConfig	*config
	)
{
#if	! __KB_EMBEDDED
	if (m_useMDI.isChecked() != m_options.useMdi)
		TKMessageBox::information
		(	0,
			TR("Please note that you will need to restart\n"
			   "for SDI/MDI switching to take effect"),
			TR("SDI/MDI switching"),
			"shown_sdimdi"
		)	;

	m_options.useMdi	= m_useMDI      .isChecked() ;
#endif
	m_options.openLast	= m_openLast    .isChecked() ;
	m_options.singleDBOnly	= m_singleDBOnly.isChecked() ;

	config->writeEntry ("usemdi", 		m_options.useMdi      ) ;
	config->writeEntry ("openLast",		m_options.openLast    ) ;
	config->writeEntry ("singledbonly", 	m_options.singleDBOnly) ;

	if (!m_bSetup.isEnabled())
		config->writeEntry ("version", 	0) ;
}

void	KBInterfaceOpts::resetSetup ()
{
	m_bSetup.setEnabled (false) ;

	TKMessageBox::information
	(	0,
		TR("Setup wizard will be rerun next time you start Rekall"),
		TR("Rerun Setup Wizard")
	)	;
}

/*  ------------------------------------------------------------------  */

/*  KBModalOpts								*/
/*  KBModalOpts	: Constructor for modal execution page			*/
/*  parent	: QWidget *	: Parent				*/
/*  options	: KBOptions &	: Options object			*/
/*  (returns)	: void		:					*/

KBModalOpts::KBModalOpts
	(	QWidget 	*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "modal"),
	m_options	(options),
	m_tablesModal	(this),
	m_formsModal	(this),
	m_reportsModal	(this),
	m_queriesModal	(this),
	m_layout	(this)
{
	m_tablesModal	.setText    (TR("Tables displayed modally" )) ;
	m_formsModal	.setText    (TR("Create forms as modal"    )) ;
	m_reportsModal	.setText    (TR("Create reports as modal"  )) ;
	m_queriesModal	.setText    (TR("Queries displayed modally")) ;

	m_tablesModal	.setChecked (m_options.tablesModal ) ;
	m_formsModal	.setChecked (m_options.formsModal  ) ;
	m_reportsModal	.setChecked (m_options.reportsModal) ;
	m_queriesModal	.setChecked (m_options.queriesModal) ;

	m_layout	.addWidget  (&m_tablesModal  	 ) ;
	m_layout	.addWidget  (&m_formsModal  	 ) ;
	m_layout	.addWidget  (&m_reportsModal	 ) ;
	m_layout	.addWidget  (&m_queriesModal	 ) ;
	m_layout	.addStretch () ;
}

void	KBModalOpts::save
	(	TKConfig	*config
	)
{
	m_options.tablesModal  = m_tablesModal .isChecked() ;
	m_options.formsModal   = m_formsModal  .isChecked() ;
	m_options.reportsModal = m_reportsModal.isChecked() ;
	m_options.queriesModal = m_queriesModal.isChecked() ;

	config->writeEntry ("tablesModal",	m_options.tablesModal ) ;
	config->writeEntry ("formsModal",	m_options.formsModal  ) ;
	config->writeEntry ("reportsModal",	m_options.reportsModal) ;
	config->writeEntry ("queriesModal",	m_options.queriesModal) ;
}

/*  ------------------------------------------------------------------  */

/*  KBReportOpts							*/
/*  KBReportOpts: Constructor for report options page			*/
/*  parent	: QWidget *	: Parent				*/
/*  options	: KBOptions &	: Options object			*/
/*  (returns)	: void		:					*/

KBReportOpts::KBReportOpts
	(	QWidget		*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "report"),
	m_options	(options),
	m_llMargin	(this),
	m_lrMargin	(this),
	m_ltMargin	(this),
	m_lbMargin	(this),
	m_lDPI		(this),
	m_slMargin	(0, 0x7fffffff, 1, this),
	m_srMargin	(0, 0x7fffffff, 1, this),
	m_stMargin	(0, 0x7fffffff, 1, this),
	m_sbMargin	(0, 0x7fffffff, 1, this),
	m_sDPI		(0, 0x7fffffff, 1, this),
	m_cbDesign	(this),
	m_layout	(this)
{
	m_layout.addWidget (&m_llMargin, 0, 0) ;
	m_layout.addWidget (&m_slMargin, 0, 1) ;
	m_layout.addWidget (&m_lrMargin, 1, 0) ;
	m_layout.addWidget (&m_srMargin, 1, 1) ;
	m_layout.addWidget (&m_ltMargin, 2, 0) ;
	m_layout.addWidget (&m_stMargin, 2, 1) ;
	m_layout.addWidget (&m_lbMargin, 3, 0) ;
	m_layout.addWidget (&m_sbMargin, 3, 1) ;
	m_layout.addWidget (&m_lDPI, 	 4, 0) ;
	m_layout.addWidget (&m_sDPI,	 4, 1) ;

	m_layout.addMultiCellWidget (&m_cbDesign, 5, 5, 0, 1) ;
	m_layout.setRowStretch      (6, 1) ;

	m_llMargin.setText (TR("Left margin (mm)"  )) ;
	m_lrMargin.setText (TR("Top margin (mm)"   )) ;
	m_ltMargin.setText (TR("Right margin (mm)" )) ;
	m_lbMargin.setText (TR("Bottom margin (mm)")) ;
	m_lDPI	  .setText (TR("Print DPI (zero default)" )) ;
	m_cbDesign.setText (TR("Design rulers show inches")) ;

	m_slMargin.setValue   (m_options.marginL) ;
	m_srMargin.setValue   (m_options.marginR) ;
	m_sbMargin.setValue   (m_options.marginB) ;
	m_stMargin.setValue   (m_options.marginT) ;
	m_sDPI	  .setValue   (m_options.dpi	) ;
	m_cbDesign.setChecked (m_options.designInches) ;
}

/*  KBReportOpts							*/
/*  save	: Save report settings					*/
/*  config	: TKConfig *	: Configuration				*/
/*  (returns)	: void		:					*/

void	KBReportOpts::save
	(	TKConfig	*config
	)
{
	m_options.marginL	= m_slMargin.cleanText().toInt() ;
	m_options.marginR	= m_srMargin.cleanText().toInt() ;
	m_options.marginB	= m_sbMargin.cleanText().toInt() ;
	m_options.marginT	= m_stMargin.cleanText().toInt() ;
	m_options.dpi		= m_sDPI    .cleanText().toInt() ;
	m_options.designInches	= m_cbDesign.isChecked() ;

#if	! __KB_RUNTIME
	config->writeEntry ("marginL",		m_options.marginL     ) ;
	config->writeEntry ("marginR",		m_options.marginR     ) ;
	config->writeEntry ("marginB",		m_options.marginB     ) ;
	config->writeEntry ("marginT",		m_options.marginT     ) ;
	config->writeEntry ("dpi",		m_options.dpi	      ) ;
	config->writeEntry ("designInches",	m_options.designInches) ;
#endif
}

/*  ------------------------------------------------------------------  */

#ifndef _WIN32

KBPythonOpts::KBPythonOpts
	(	QWidget		*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "python"),
	m_options	(options),
	m_eUserpy	(this),
#if	__KB_USESYSPY
	m_lVersion	(this),
	m_eVersion	(this),
#endif
	m_lBinpath	(this),
	m_lPypath	(this),
	m_eBinpath	(this),
	m_ePypath	(this),
	m_layout	(this)
{
	m_layout.addWidget(&m_eUserpy,  0, 1) ;
	m_layout.addWidget(&m_lBinpath, 2, 0) ;
	m_layout.addWidget(&m_lPypath,  3, 0) ;
	m_layout.addWidget(&m_eBinpath, 2, 1) ;
	m_layout.addWidget(&m_ePypath,  3, 1) ;

#if	__KB_USESYSPY
	m_layout.addWidget(&m_lVersion, 1, 0) ;
	m_layout.addWidget(&m_eVersion, 1, 1) ;
#endif
	m_layout.setRowStretch (4, 1) ;

	m_eUserpy .setText  (TR("Enable user settings"	)) ;
	m_lBinpath.setText  (TR("Executable path"	)) ;
	m_lPypath .setText  (TR("PYTHONPATH"		)) ;

#if	__KB_USESYSPY
	m_lVersion.setText  (TR("Version"		)) ;
#endif	
	TKConfig *config = TKConfig::getConfig() ;
        config->setGroup ("Debug Options/py") ;

#if	__KB_USESYSPY
	QString	 libver	 = config->readEntry ("libver" ) ;

	m_eVersion.insertItem ("1.5.2") ;
	m_eVersion.insertItem ("2.0"  ) ;
	m_eVersion.insertItem ("2.1.1") ;
	m_eVersion.insertItem ("2.2"  ) ;

	if	(libver == "22") m_eVersion.setCurrentItem (3) ;
	else if	(libver == "21") m_eVersion.setCurrentItem (2) ;
	else if	(libver == "20") m_eVersion.setCurrentItem (1) ;
	else if	(libver == "15") m_eVersion.setCurrentItem (0) ;
#endif
	m_eUserpy .setChecked (config->readBoolEntry ("userpy" )) ;
	m_eBinpath.setText    (config->readEntry     ("binpath")) ;
	m_ePypath .setText    (config->readEntry     ("pypath" )) ;

#if	__KB_USESYSPY
	changeUserPY() ;

	connect	(&m_eUserpy, SIGNAL(toggled(bool)), SLOT(changeUserPY())) ;
#endif
}

void	KBPythonOpts::save
	(	TKConfig	*
	)
{
	TKConfig *config = TKConfig::getConfig() ;
        config->setGroup ("Debug Options/py") ;

	config->writeEntry	("userpy",  m_eUserpy.isChecked()) ;
	config->writeEntry	("binpath", m_eBinpath.text()) ;
	config->writeEntry	("pypath",  m_ePypath .text()) ;

#if	__KB_USESYSPY
	static	char	versions[][4] =
	{	"15", "20", "21", "22"
	}	;

	config->writeEntry	("libver",  QString(versions[m_eVersion.currentItem()])) ;
#endif
}

void	KBPythonOpts::changeUserPY()
{
#if	__KB_USESYSPY
	bool	userpy	= m_eUserpy.isChecked() ;
	m_eVersion.setEnabled (userpy) ;
	m_eBinpath.setEnabled (userpy) ;
	m_ePypath .setEnabled (userpy) ;
#endif
}

#else

void KBPythonOpts::changeUserPY()
{
}

#endif

/*  ------------------------------------------------------------------  */

/*  KBScriptOpts							*/
/*  KBScriptOpts: Constructor for script options page			*/
/*  parent	: QWidget *	: Parent				*/
/*  options	: KBOptions &	: Options object			*/
/*  (returns)	: void		:					*/

KBScriptOpts::KBScriptOpts
	(	QWidget		*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "script"),
	m_options	(options),
#if	! __KB_EMBEDDED
	m_lScriptFont	(this),
	m_eScriptFont	(this),
	m_bScriptFont	(this),
#endif
	m_lScriptType	(this),
	m_cbScriptType	(this),
	m_lMacroDebug	(this),
	m_cbMacroDebug	(this),
	m_layout	(this)
{
#if	! __KB_EMBEDDED
	m_layout.addWidget(&m_lScriptFont,  0, 0) ;
	m_layout.addWidget(&m_eScriptFont,  0, 1) ;
	m_layout.addWidget(&m_bScriptFont,  0, 2) ;

	m_lScriptFont.setText (TR("Script font")) ;
	m_bScriptFont.setText (TR("Set"	       )) ;

	m_eScriptFont.setText	  (options.scriptFont) ;
	m_eScriptFont.setReadOnly (true) ;

	connect	(&m_bScriptFont, SIGNAL(clicked()), SLOT(clickSetScriptFont())) ;
#endif

	m_layout.addWidget(&m_lScriptType,  1, 0) ;
	m_layout.addWidget(&m_cbScriptType, 1, 1) ;

	m_layout.addWidget(&m_lMacroDebug,  2, 0) ;
	m_layout.addWidget(&m_cbMacroDebug, 2, 1) ;

	m_lScriptType .setText 	  (TR("Scripting"  )) ;
	m_cbScriptType.insertItem (TR("Always use scripting")) ;
	m_cbScriptType.insertItem (TR("Prompt when empty"   )) ;
	m_cbScriptType.insertItem (TR("Always use macros"   )) ;
	m_cbScriptType.setCurrentItem (options.scriptType) ;

	m_lMacroDebug .setText 	  (TR("Macro debug")) ;
	m_cbMacroDebug.insertItem (TR("On demand"  )) ;
	m_cbMacroDebug.insertItem (TR("Always off" )) ;
	m_cbMacroDebug.insertItem (TR("Always on"  )) ;
	m_cbMacroDebug.setCurrentItem (options.macroDebug) ;
}

void	KBScriptOpts::clickSetScriptFont ()
{
#if	! __KB_EMBEDDED
	TKFontDialog  fDialog (this, TR("Font"), false, true) ;
	fDialog.setFont (KBFont::specToFont (m_eScriptFont.text())) ;

	if (fDialog.exec())
		m_eScriptFont.setText (KBFont::fontToSpec (fDialog.font())) ;
#endif
}

void	KBScriptOpts::save
	(	TKConfig	*config
	)
{
#if	! __KB_EMBEDDED
	m_options.scriptFont = m_eScriptFont.text() ;
	config->writeEntry ("scriptFont", m_options.scriptFont) ;
#endif
	m_options.scriptType   = (KBOptions::ScriptType)m_cbScriptType.currentItem() ;
	config->writeEntry ("scriptType", m_options.scriptType) ;

	m_options.macroDebug   = (KBOptions::MacroDebug)m_cbMacroDebug.currentItem() ;
	config->writeEntry ("macroDebug", m_options.macroDebug) ;
}


/*  ------------------------------------------------------------------  */

/*  KBLoggingOpts								*/
/*  KBLoggingOpts	: Constructor for fonts selectioon page			*/
/*  parent	: QWidget *	: Parent				*/
/*  options	: KBOptions &	: Options object			*/
/*  (returns)	: void		:					*/

KBLoggingOpts::KBLoggingOpts
	(	QWidget		*parent,
		KBOptions	&options
	)
	:
	QWidget		(parent, "logging"),
	m_options	(options),
	m_lMaxQueries	(this),
	m_sMaxQueries	(this),
	m_lMaxEvents	(this),
	m_sMaxEvents	(this),
	m_lMaxArgs	(this),
	m_sMaxArgs	(this),
	m_lMaxArgLen	(this),
	m_sMaxArgLen	(this),
	m_layout	(this)
{
	m_layout.addWidget (&m_lMaxQueries, 0, 0) ;
	m_layout.addWidget (&m_sMaxQueries, 0, 1) ;
	m_layout.addWidget (&m_lMaxEvents,  1, 0) ;
	m_layout.addWidget (&m_sMaxEvents,  1, 1) ;
	m_layout.addWidget (&m_lMaxArgs,    2, 0) ;
	m_layout.addWidget (&m_sMaxArgs,    2, 1) ;
	m_layout.addWidget (&m_lMaxArgLen,  3, 0) ;
	m_layout.addWidget (&m_sMaxArgLen,  3, 1) ;

	m_lMaxQueries.setText (TR("Maximum queries logged"  )) ;
	m_lMaxEvents .setText (TR("Maximum events logged"   )) ;
	m_lMaxArgs   .setText (TR("Maximum arguments logged")) ;
	m_lMaxArgLen .setText (TR("Maximum recorded argument length")) ;

	m_sMaxQueries.setRange(10, 1000) ;
	m_sMaxEvents .setRange(10, 2000) ;
	m_sMaxArgs   .setRange( 5,  500) ;
	m_sMaxArgLen .setRange(50, 1000) ;

	m_sMaxQueries.setValue(m_options.logMaxQueries) ;
	m_sMaxEvents .setValue(m_options.logMaxEvents ) ;
	m_sMaxArgs   .setValue(m_options.logMaxArgs   ) ;
	m_sMaxArgLen .setValue(m_options.logMaxArgLen ) ;
}


void	KBLoggingOpts::save
	(	TKConfig	*config
	)
{
	m_options.logMaxQueries	= m_sMaxQueries.cleanText().toInt() ;
	m_options.logMaxEvents	= m_sMaxEvents .cleanText().toInt() ;
	m_options.logMaxArgs	= m_sMaxArgs   .cleanText().toInt() ;
	m_options.logMaxArgLen	= m_sMaxArgLen .cleanText().toInt() ;

	config->writeEntry ("logMaxQueries", m_options.logMaxQueries) ;
	config->writeEntry ("logMaxEvents",  m_options.logMaxEvents ) ;
	config->writeEntry ("logMaxArgs",    m_options.logMaxArgs   ) ;
	config->writeEntry ("logMaxArgLen",  m_options.logMaxArgLen ) ;
}


/*  ------------------------------------------------------------------  */

/*  KBOptionsDlg							*/
/*  KBOptionsDlg: Consttuctor for options dialog			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  (returns)	: KBOptions	:					*/

KBOptionsDlg::KBOptionsDlg
	(	QWidget	*
	)
	:
	_KBDialog	(TR("Options"), true),
#if	! __KB_EMBEDDED
	m_blurb		(this),
#endif
	m_tabber	(this),
	m_bOK		(this, "ok"    ),
	m_bCancel	(this, "cancel")
{
	m_verify	= new KBVerifyOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_verify  ) ;
	m_tabber.addTab	(m_verify,    TR("Verify"   )) ;

	m_interface	= new KBInterfaceOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_interface) ;
	m_tabber.addTab	(m_interface, TR("Interface")) ;

	m_modal		= new KBModalOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_modal	) ;
	m_tabber.addTab	(m_modal,     TR("Modal"    )) ;

#if	! __KB_RUNTIME
	m_layout	= new KBLayoutOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_layout	) ;
	m_tabber.addTab	(m_layout,    TR("Layout"   )) ;

	m_report	= new KBReportOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_report	) ;
	m_tabber.addTab	(m_report,    TR("Reports"  )) ;
#endif
	m_scripts	= new KBScriptOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_scripts	) ;
	m_tabber.addTab	(m_scripts,   TR("Scripts/Macros")) ;
#ifndef _WIN32
	m_python	= new KBPythonOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_python	) ;
	m_tabber.addTab	(m_python,    TR("Python"   )) ;
#endif

#if	! __KB_RUNTIME
	m_logging	= new KBLoggingOpts	(&m_tabber, KBOptions::self()) ;
	setupLayout (m_logging	) ;
	m_tabber.addTab	(m_logging,   TR("Logging"  )) ;
#endif

	QVBoxLayout *layMain	= new QVBoxLayout (this	  ) ;
	QHBoxLayout *layData	= new QHBoxLayout (layMain) ;

#if	! __KB_EMBEDDED
	layData	->addWidget (&m_blurb  ) ;
#endif
	layData	->addWidget (&m_tabber ) ;

	QHBoxLayout *layButt	= new QHBoxLayout (layMain) ;
	layButt	->addStretch()		 ;
	layButt	->addWidget (&m_bOK    ) ;
	layButt	->addWidget (&m_bCancel) ;


	m_bOK	 .setText(TR("OK"    )) ;
	m_bCancel.setText(TR("Cancel")) ;

	connect
	(	&m_tabber,
		SIGNAL(currentChanged(QWidget *)),
		SLOT  (pageChanged   (QWidget *))
	)	;

	pageChanged (m_verify) ;
}


/*  KBOptionsDlg								*/
/*  accept	: Handle user clicking the OK button			*/
/*  (returns)	: void		:					*/

void	KBOptionsDlg::accept ()
{
	TKConfig *config = TKConfig::getConfig () ;
	config->setGroup   (KB_OPTIONS_GROUP) ;

	m_verify   ->save (config) ;
	m_interface->save (config) ;
	m_modal    ->save (config) ;

#if	! __KB_RUNTIME
	m_layout   ->save (config) ;
	m_report   ->save (config) ;
#endif

#if	! __KB_EMBEDDED
	m_scripts  ->save (config) ;
#endif

	m_logging  ->save (config) ;

#ifndef _WIN32
	/* Save the python options last, since these do not go into	*/
	/* the KB_OPTIONS_GROUP section as to the rest of the options.	*/
	m_python   ->save (config) ;
#endif

	config->sync () ;
	done	(1) 	;
}

/*  KBOptionsDlg								*/
/*  reject	: Handle user clicking the cancel button			*/
/*  (returns)	: void		:					*/

void	KBOptionsDlg::reject ()
{
	done	(0)	;
}

void	KBOptionsDlg::pageChanged
	(	QWidget		*widget
	)
{
	fprintf
	(	stderr,
		"KBOptionsDlg::pageChanged: [%s]\n",
		widget->name()
	)	;

	QString	name	= locateFile ("appdata", QString("help/opts_%1.qt").arg(widget->name())) ;
	if (name.isEmpty()) return   ;

	QFile	file	(name)	;

	if (file.open (IO_ReadOnly))
		m_blurb.setText (QTextStream(&file).read()) ;
	else	m_blurb.setText (QString::null) ;
}


/*  ------------------------------------------------------------------  */

/*  KBOptionsDlg							*/
/*  setupWizard	: Startup configuration wizard				*/
/*  config	: TKConfig *	: Configuration object			*/
/*  (returns)	: void		:					*/

void	KBOptionsDlg::setupWizard
	(	TKConfig	*config
	)
{
	config->setGroup (KB_OPTIONS_GROUP) ;
	if (config->readNumEntry("version") >= 210) return ;

	QString	wizXML = locateFile ("appdata", "wizards/wizSetup.wiz") ;
	if (wizXML.isEmpty()) return ;

	KBWizard wizSetup (0, QString::null) ;
	if (!wizSetup.init (wizXML)) return ;

	if (wizSetup.exec() && (wizSetup.currentPageName() != "initial"))
	{
		QVariant  mode		= wizSetup.ctrlAttribute ("interface", "mode",      "index") ;
		QVariant  scripting	= wizSetup.ctrlAttribute ("scripting", "scripting", "index") ;
		QVariant  vInsert	= wizSetup.ctrlAttribute ("verify",    "insert",    "index") ;
		QVariant  vUpdate	= wizSetup.ctrlAttribute ("verify",    "update",    "index") ;
		QVariant  vDelete	= wizSetup.ctrlAttribute ("verify",    "delete",    "index") ;

		KBOptions &opts		= KBOptions::self() ;

		opts.useMdi		= mode.toInt() > 0 ;
		opts.scriptType		= (KBOptions::ScriptType  )scripting.toInt() ;
		opts.verInsert		= (KBOptions::VerifyOption)vInsert  .toInt() ;
		opts.verUpdate		= (KBOptions::VerifyOption)vUpdate  .toInt() ;
		opts.verDelete		= (KBOptions::VerifyOption)vDelete  .toInt() ;

		config->setGroup   (KB_OPTIONS_GROUP) ;
		config->writeEntry ("usemdi", 	  opts.useMdi    ) ;
		config->writeEntry ("scriptType", opts.scriptType) ;
		config->writeEntry ("verInsert",  opts.verInsert ) ;
		config->writeEntry ("verUpdate",  opts.verUpdate ) ;
		config->writeEntry ("verDelete",  opts.verDelete ) ;
	}

	config->setGroup   (KB_OPTIONS_GROUP) ;
	config->writeEntry ("version", 210  ) ;
	config->sync	   () ;
}
