/***************************************************************************
    file	         : kb_macroeditor.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_MACROEDITOR_H
#define  _KB_MACROEDITOR_H


#include	<qwidgetstack.h>
#include	<qtextview.h>
#include	<qsplitter.h>

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_attrdict.h"
#include	"kb_conductor.h"
#include	"kb_macro.h"
#include	"kb_editlistview.h"
#include	"kb_wizard.h"
#include	"kb_macro.h"
#include	"kb_macrodef.h"


class	KBInstructions		;
class	KBInstructionItem	;
class	KBMacroEditor		;

/*  ------------------------------------------------------------------  */

/*  KBInstructions							*/
/*  --------------							*/
/*  Derived class from KBEditListView to provide extra functions used	*/
/*  my the macro editor.						*/

class	LIBKBASE_API	KBInstructions : public KBEditListView
{
	Q_OBJECT

	KBMacroEditor	*m_editor	;

protected :

	virtual KBEditListViewItem
			*newItem	(QListViewItem *, QString = QString::null) ;

protected slots :

	virtual void	itemClicked	(QListViewItem *, const QPoint &, int) ;

public	:

	KBInstructions	(KBMacroEditor *, QWidget *)	;

	virtual	void	fillCombo   (QComboBox &, uint, const QString &) ; 
}	;


/*  KBInstructionItem							*/
/*  -----------------							*/
/*  Wrapper around KBEditListViewItem used to retain additional macro	*/
/*  information.							*/

class	LIBKBASE_API	KBInstructionItem : public KBEditListViewItem
{
	QStringList	m_args	;

public	:

	KBInstructionItem
	(	KBInstructions	*,
		QListViewItem	*,
		QString		,
		KBMacroInstr	*
	)	;

	const QStringList	&args		() ;
	bool			saveSettings	(KBMacroDef *, KBWizardPage *) ;
}	;

/*  KBMacroEditor							*/
/*  -------------							*/

class	LIBKBASE_API	KBMacroEditor : public QSplitter
{
	Q_OBJECT

	KBDBInfo		*m_dbInfo	;
	QString			m_svName	;

	KBInstructions		*m_instrList	;
	QWidgetStack		*m_pageStack	;
	QTextView		*m_pageInfo	;
	QLabel			*m_nullPage	;
	QDict<KBWizardPage>	m_pages		;

	KBInstructionItem	*m_currItem	;
	KBWizardPage		*m_currPage	;
	KBMacroDef		*m_currDef	;
	bool			m_changed	;

	void			syncCurrentPage	() ;
	void			setMacroPage	(KBWizardPage *, KBInstructionItem *, bool) ;
	bool			addSpecialArg	(const KBMacroArgDef &, KBWizardPage *) ;

protected slots :

	void			slotChanged	(KBEditListViewItem *, uint) ;
	void			slotDeleted	(KBEditListViewItem *) ;

signals :

	void			changed		() ;

public	:

	KBMacroEditor		(QWidget *, KBDBInfo *, const QString &) ;
	virtual	~KBMacroEditor	()		;

	void			itemCurrent	(KBInstructionItem *, bool, bool) ;

	KB::ShowRC		startup		(QByteArray  &, KBError &) ;
	KB::ShowRC		startup		(KBMacroExec *, KBError &) ;

	bool			getChanged	() ;
	QString			def		(KBError &) ;
	KBMacroExec		*macro		(KBError &, KBNode  * = 0) ;
}	;

#endif // _KB_MACROEDITOR_H
