/***************************************************************************
    file	         : kb_hiddendlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>

#include	"kb_hidden.h"

#ifndef		_WIN32
#include	"kb_hiddendlg.moc"
#else
#include	"kb_hiddendlg.h"
#endif

/*  KBHiddenItem							*/
/*  ------------							*/
/*  This is a wrapper round a list view item, used to store a pointer	*/
/*  at an associated KBHidden object.					*/

class	KBHiddenItem : public QListViewItem
{
	KBHidden	*hidden	;
public	:

	KBHiddenItem (QListView *, KBHidden *) ;
	KBHiddenItem (QListView *, const QString &, const QString &) ;

	inline	KBHidden *getHidden () { return hidden ; }
}	;


/*  ------------------------------------------------------------------  */

/*  KBHiddenItem							*/
/*  KBHiddenItem: Constructor for extant hidden item			*/
/*  listView	: QListView *	: Display list view			*/
/*  hidden	: KBHidden *	: Hidden field				*/
/*  (returns)	: KBHiddenItem	:					*/

KBHiddenItem::KBHiddenItem
	(	QListView	*listView,
		KBHidden	*hidden
	)
	:
	QListViewItem (listView, hidden->getName   (),
				 hidden->getAttrVal("expr")),
	hidden	      (hidden)
{
}

/*  KBHiddenItem							*/
/*  KBHiddenItem: Constructor for new hidden item			*/
/*  listView	: QListView *	: Display list view			*/
/*  name	: const QString&: Hidden field name			*/
/*  expr	: const QString&: Hidden field expression		*/
/*  (returns)	: KBHiddenItem	:					*/

KBHiddenItem::KBHiddenItem
	(	QListView	*listView,
		const QString	&name, 
		const QString	&expr
	)
	:
	QListViewItem (listView, name, expr),
	hidden	      (0)
{
}


/*  ------------------------------------------------------------------	*/


/*  KBHiddenDlg								*/
/*  KBHiddenDlg	: Constructor for hidden item dialog			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  object	: KBObject *	: Object owning hidden items		*/
/*  (returns)	: KBHiddenDlg	:					*/

KBHiddenDlg::KBHiddenDlg
	(	QWidget		*parent,
		KBObject	*object
	)
	:
	QWidget		(parent),
	m_listView	(this),
	m_bAdd		(this),
	m_bEdit		(this),
	m_bRemove	(this),
	m_object		(object)
{
	QHBoxLayout	*layMain = new QHBoxLayout (this) ;
	layMain->addWidget (&m_listView) ;

	QVBoxLayout	*layButt = new QVBoxLayout (layMain) ;
	layButt->addWidget (&m_bAdd   ) ;
	layButt->addWidget (&m_bEdit  ) ;
	layButt->addWidget (&m_bRemove) ;
	layButt->addStretch() ;

	m_bAdd	    .setText   (TR("Add"   )) ;
	m_bEdit	    .setText   (TR("Edit"  )) ;
	m_bRemove   .setText   (TR("Remove")) ;

	connect	(&m_bAdd,     SIGNAL(clicked()), this, SLOT(clickAdd   ())) ;
	connect	(&m_bEdit,    SIGNAL(clicked()), this, SLOT(clickEdit  ())) ;
	connect	(&m_bRemove,  SIGNAL(clicked()), this, SLOT(clickRemove())) ;

	connect (&m_listView, SIGNAL(clicked       (QListViewItem *)),
		 this,	      SLOT  (selected 	   ())) ;
	connect (&m_listView, SIGNAL(doubleClicked (QListViewItem *)),
		 this,	      SLOT  (clickEdit     ())) ;
	connect (&m_listView, SIGNAL(returnPressed (QListViewItem *)),
		 this,	      SLOT  (clickEdit     ())) ;

	m_listView.addColumn (TR("Name"),  100) ;
	m_listView.addColumn (TR("Expression")) ;

	/* Populate the hidden fields list view with copies of the	*/
	/* hidden fields. This means that the originals will be left	*/
	/* untouched, and can be restored if the user cancels.		*/
	TITER
	(	Hidden,
		m_object->getChildren(),
		h,
		m_hidden.append  (h) ;
	)
	LITER
	(	KBHidden,
		m_hidden,
		h,
		new KBHiddenItem (&m_listView, new KBHidden (object, h))
	)

	m_attrHidden = new KBAttrStr
			   (	m_object,
				"hidden",
				"",
				KAF_GRPOTHER|KAF_CUSTOM|KAF_SYNTHETIC
			   )	;

	m_bRemove.setEnabled  (false) ;
	m_bEdit  .setEnabled  (false) ;
}

/*  KBHiddenDlg								*/
/*  ~KBHiddenDlg: Destructor for hidden item dialog			*/
/*  (returns)	:		:					*/

KBHiddenDlg::~KBHiddenDlg ()
{
	/* "clickOK" or "clickCancel" should have been called before	*/
	/* the destructor, but just in case ...				*/
	clickCancel () ;

	delete	m_attrHidden ;
}

/*  KBHiddenDlg								*/
/*  getText	: Get text for the nominal hidden attribute		*/
/*  (returns)	: QString	: Text					*/

QString	KBHiddenDlg::getText ()
{
	QString		htext	= "" ;
	cchar		*sep	= "" ;

	for (QListViewItem *item  = m_listView.firstChild () ;
			    item != 0 ;
			    item  = item->nextSibling  ())
	{
		htext	+= sep	;
		htext	+= item->text(0) ;
		htext	+= "="	;
		htext	+= item->text(1) ;
		sep	 = ", "	;
	}

	return	htext	;
}

/*  KBHiddenDlg								*/
/*  clickAdd	: Add a new hidden item					*/
/*  (returns)	: void		:					*/

void	KBHiddenDlg::clickAdd ()
{
	bool	 ok	 = false ;
	KBHidden *hidden = new KBHidden (m_object, ok) ;

	if (!ok)
	{	delete	hidden	;
		return	;
	}

	new KBHiddenItem (&m_listView, hidden) ;
}

/*  KBHiddenDlg								*/
/*  clickRemove	: Remove a hidden item					*/
/*  (returns)	: void		:					*/

void	KBHiddenDlg::clickRemove ()
{
	KBHiddenItem *item ;

	if ((item = (KBHiddenItem *)m_listView.currentItem()) != 0)
	{
		delete item->getHidden () ;

		m_listView.removeItem  (m_listView.currentItem()) ;
		m_bRemove .setEnabled  (m_listView.currentItem() != 0) ;
		m_bEdit   .setEnabled  (m_listView.currentItem() != 0) ;
	}
}

/*  KBHiddenDlg								*/
/*  selected	: User selects an item					*/
/*  (returns)	: void		:					*/

void	KBHiddenDlg::selected ()
{
	/* Enable the remove and edit buttons so that the user can	*/
	/* manipulate the item.						*/
	m_bRemove.setEnabled  (true) ;
	m_bEdit  .setEnabled  (true) ;
}

/*  KBHiddenDlg								*/
/*  clickEdit	: Edit the currently seleted item			*/
/*  (returns)	: void		:					*/

void	KBHiddenDlg::clickEdit ()
{
	KBHiddenItem	*item	;
	KBHidden	*hidden	;

	if ((item = (KBHiddenItem *)m_listView.currentItem()) != 0)
	{
		hidden = item->getHidden() ;

		if (hidden->propertyDlg ())
		{
			item->setText (0, hidden->getAttrVal("name")) ;
			item->setText (1, hidden->getAttrVal("expr")) ;
		}
	}
}

/*  KBHiddenDlg								*/
/*  clickOK	: User clicks OK					*/
/*  (returns)	: void		:					*/

void	KBHiddenDlg::clickOK ()
{
	/* User clicks OK, so delete the original hidden fields. Those	*/
	/* that are linked via the list view will become the new ones.	*/
	LITER
	(	KBHidden,
		m_hidden,
		h,
		delete	h
	)

	/* Clear the list view, so that the call to "clickCancel" in	*/
	/* the destructor has no effect.					*/
	m_listView.clear () ;
}

/*  KBHiddenDlg								*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	KBHiddenDlg::clickCancel ()
{
	/* If the user cancels then delete all hidden fields that are	*/
	/* linked via the list view. This will leave the original ones	*/
	/* unchanged.							*/
	for (QListViewItem *item  = m_listView.firstChild () ;
			    item != 0 ;
			    item  = item->nextSibling  ())
	{
		delete	((KBHiddenItem *)item)->getHidden () ;
	}

	/* Clear the list view, so that the second call to		*/
	/* "clickCancel" in the destructor has no effect.		*/
	m_listView.clear () ;
}
