/***************************************************************************
    file	         : kb_config.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_CONFIG_H
#define	__KB_CONFIG_H


#include	"kb_node.h"
#include	"libkbase_exports.h"


/*  KBConfig								*/
/*  --------								*/
/*  This class is used to hold configuration settings for components.	*/
/*  Instances are children of objects in forms and report documents,	*/
/*  and contain values which substitute the attributes of the parent	*/
/*  objects; they are also accessible from scripts so that values can	*/
/*  be picked up at run time.						*/

class	LIBKBASE_API	KBConfig : public KBNode
{
	KBAttrStr	m_ident		;
	KBAttrStr	m_attrib	;
	KBAttrStr	m_value		;
	KBAttrStr	m_legend	;

	KBAttrBool	m_user		;
	KBAttrBool	m_required	;
	KBAttrBool	m_hidden	;

	QString		m_path		;
	bool		m_changed	;

public	:

	KBConfig	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBConfig 	(KBNode *, const QString &, const QString &, const QString &, const QString &, bool, bool, bool) ;
	KBConfig	(KBNode *, KBConfig *) ;
       ~KBConfig 	() ;
	
	virtual	KBNode	*replicate 	(KBNode *)	  ;
	virtual	void	printNode  	(QString &,int)	  ;

	virtual	KBConfig*isConfig 	() { return this ; }

	QString		ident		() { return m_ident    .getValue     () ; }
	QString		attrib		() { return m_attrib   .getValue     () ; }
	QString		value		() { return m_value    .getValue     () ; }
	QString		legend		() { return m_legend   .getValue     () ; }
	bool		hidden		() { return m_hidden   .getBoolValue () ; }
	bool		required	() { return m_required .getBoolValue () ; }
	bool		user		() { return m_user     .getBoolValue () ; }
	const QString	&path		() { return m_path	; }
	bool		changed		() { return m_changed	; }

	void		fixupValue	() ;
	void		setValue	(const QString &) ;

	inline	void	setHidden
		(	bool		h
		)
	{
		m_hidden  .setValue (h) ;
	}
	inline	void	setRequired
		(	bool		r
		)
	{
		m_required.setValue (r) ;
	}
	inline	void	setUser
		(	bool		u
		)
	{
		m_user    .setValue (u) ;
	}
	inline	void	setPath
		(	const QString	&p
		)
	{
		m_path	= p	;
	}
	inline	void	setChanged
		(	bool		c
		)
	{
		m_changed = c	;
	}

	void		substitute (bool) ;
}	;

extern	QString	paramSub	(const QString &, const QDict<QString> &) ;


#endif	// __KB_CONFIG_H
