/***************************************************************************
    file	         : kb_attrdict.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_ATTRDICT_H
#define	__KB_ATTRDICT_H

#include "libkbase_exports.h"

/*  KBAttrDict								*/
/*  ----------								*/
/*  This class is a convenience used to assemble a string-string	*/
/*  attribute dictionary, which can then be rendered as an XML format	*/
/*  text string. The constructor accepts an array of PSet structures	*/
/*  containing initial fixed pairs.					*/

struct	LIBKBASE_API PSet
{
	cchar	*name	;
	cchar	*value	;
}	;


class LIBKBASE_API KBAttrDict : public QDict<QString>
{
public	:

	KBAttrDict () {} ;
	KBAttrDict (const QDict<QString> &) ;
	KBAttrDict (const PSet 	         *) ;

	void	addValue (cchar *, int) ;
	void	addValue (cchar *, cchar 	 *) ;
	void	addValue (cchar *, const QString &) ;
	void	addValue (cchar *, const KBValue *) ;

	QString	print	 (cchar *, bool = false, uint = 0) ;
}	;

#endif	// __KB_ATTRDICT_H
