/***************************************************************************
    file	         : hash.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<std.h>

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"


/*  el_keys	: Get list of keys from hash table			*/
/*  argv	: VALUE *	: Argument vector			*/
/*  (returns)	: VALUE		: Result list				*/

LFUNC	VALUE	el_keys
	(	VALUE	*argv
	)
{
	VALUE	list	(new VEC (0)) ;
	HASH	*hash	= argv[0].val.hash ;
	HITEM	*item	;
	int	hval	;

	extern	void	el_pushvec (const VALUE &, const VALUE &, const char *) ;

	for (hval = 0 ; hval < HTABSIZ ; hval += 1)
	{	item	= hash->htab[hval] ;
		while (item != 0)
		{	list.val.vec->push (item->key) ;
			item	= item->next	;
		}
	}

	return	list	;
}

static	MC	el_hashSpec [] =
{
	{	"keys",		{ 				0 },	el_keys		},
	{	NULL,		{				0 },	NULL		}
}	;

static	ELTAG	*el_hashAllow[] =
{
	&tagHASH,
	0
}	;

METHSET	el_hashMethSet =
{
	0,
	el_hashAllow,
	el_hashSpec
}	;

HITEM::HITEM
	(	const VALUE	&key
	)
	:
	next	(0),
	key	(key)
{
}

HASH::HASH
	(	VALUE	dflt
	)
	:
	dflt	(dflt)
{
	
	memset	(htab, 0, sizeof(htab)) ;
//	fprintf	(stderr, "alloc HASH   %08x\n", (unsigned int)this) ;
}

HASH::~HASH ()
{
	for (int idx = 0 ; idx < HTABSIZ ; idx += 1)
	{	HITEM	*item	= htab[idx] ;
		HITEM	*next	;
		while (item != 0)
		{	next	= item->next ;
			delete	item	     ;
			item	= next	     ;
		}
	}
//	fprintf	(stderr, "free  HASH   %08x\n", (unsigned int)this) ;
}

/*  HASH								*/
/*  entry	: Get pointer at entry value				*/
/*  key		: const VALUE &	: Hash key				*/
/*  make	: int		: Non-zero to create if non-existant	*/
/*  (returns)	: VALUE *	: Entry pointer or null			*/

VALUE	*HASH::entry
	(	const VALUE	&key,
		int		make
	)
{
	extern	int	hashval (const char *) ;

	int	hval	;
	HITEM	*item	;

	/* Determine the hash value. This depends on the type of the	*/
	/* hash key ...							*/
	switch (key.tag->tag)
	{
		case V_NUM	:
			/* Numbers are easy, just use the number itself	*/
			hval	= key.val.num ;
			break	;

		case V_DBL	:
			/* Floating values are similary easy ...	*/
			hval	= (int)key.val.dbl ;
			break	;

		case V_STR	:
			/* Strings are hashed up normally ...		*/
			hval	= hashval (key.val.str->text) ;
			break	;

		default	:
			/* Anything else is not well defined. If the	*/
			/* type is shared then use the shared address,	*/
			/* otherwise use just the tag (pretty useless	*/
			/* but so what, not a common case).		*/
			if ((key.tag->flags & TF_SHARED) == 0)
				hval	= (int)key.val.shared ;
			else	hval	= key.tag->tag ;
			break	;
	}

	/* Normalise the key and look for the entry. If it is not found	*/
	/* and we are not to make a new entry then return a pointer at	*/
	/* the default value.						*/
	if (hval < 0) hval = - hval ;
	hval   %= HTABSIZ ;
	item	= htab[hval] ;

	while (item != 0)
	{
		if (item->key == key) return &item->value ;
		item	= item->next ;
	}

	if (!make) return &dflt ;

	/* OK, we need to make a new entry, and to return a pointer at	*/
	/* the value therein (which will initially be zero).		*/
	item	   = new HITEM (key) ;
	item->next = htab[hval] ;
	htab[hval] = item	;

	return	&item->value	;
}

void	VALUE::operator =
	(	HASH	*hash
	)
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
	tag	= &tagHASH;
	val.hash= hash	  ;
}

