/***************************************************************************
    file	         : error.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<ctype.h>
#include	<setjmp.h>
#include	<std.h>
#include	<except.h>

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"
#include	"code.h"

static	void	KBELError
	(	const char	*msg,
		const char	*where,
		unsigned int	lno
	)
{
	fprintf	(stderr, "%s: %s, %d\n", msg, where, lno) ;
}

/*G el_error	: Error reporting routine				*/
/*  fmt		: char *	: Format string				*/
/*  arg1 ...	:		: Arguments				*/
/*  (returns)	: int		: Always zero				*/

//LIBEL32_API
	int	el_error
	(	const char	*fmt,
		...
	)
{


	va_list	  aptr		 ;
	va_start  (aptr, fmt)	 ;
	char	  eb[1024]	 ;
	vsprintf  (eb, fmt, aptr);

	if (_el_at == 0)
		KBELError (eb, "", 0) ;
	else	KBELError (eb, _el_master[_el_at & 0x0fff].name, _el_at >> 12) ;

	RAISE	  (1) ;
}

