/***************************************************************************
    file	         : compile.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include 	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	<string.h>
#include	<setjmp.h>
#include	<errno.h>

#ifdef		_WIN32
#include	<io.h>
#else
#include	<unistd.h>
#endif

#include	"std.h"
#include	"eli.h"
#include	"interp.h"
#include	"syn.h"

GFUNC	void	_el_cogen   () ;
GFUNC	CBUFF	*_el_cgdone (const char *) ;

GFUNC	int	el_yyparse(void);
GFUNC	void	el_yyrestart(FILE *);

GFUNC	void	el_lex_iinit(FILE *, 	   const char *) ;
GFUNC	void	el_lex_sinit(const char *, const char *) ;
GFUNC	void	el_in_clean () 	;
GFUNC	void	el_syn_clean() 	;

	jmp_buf	cgErrEnv  	;
	FILE	*_el_errout	;

/*  el_compile	: Compile program					*/
/*  srce	: char *	: Source file name or NULL		*/
/*  dest	: char *	: Destination file name or NULL		*/
/*  ifd		: FILE *	: File source or NULL			*/
/*  sstr	: char *	: Source text or NULL			*/
/*  eout	: FILE *	: Error output stream or NULL		*/
/*  (returns)	: CBUFF *	: Code buffer or NULL on error		*/

GFUNC	CBUFF	*el_compile
	(	const char	*srce,
		const char	*dest,
		FILE		*ifd,
		const char	*sstr,
		FILE		*eout
	)
{
	_el_errout = eout == 0 ? stderr : eout ;

	if (setjmp (cgErrEnv) != 0)
		goto Failed ;


	/* Initialise the string list with the name of the file being	*/
	/* compiled.							*/
	_el_slist	= (NAME *)_el_alloc(sizeof(NAME)) ;
	_el_slist->type	= N_STRING	;
	_el_slist->name	= strdup (srce == 0 ? "" : srce)  ;
	_el_slist->next	= 0		;
	_el_slist->ref	= 1		;
	_el_file	= _el_slist	;

#ifdef	_WIN32
	sprintf	(_el_lname, "EL32_%ld", time(NULL)) ;
#else
	sprintf	(_el_lname, "%d_%ld", getpid(), time(NULL)) ;
#endif
	_el_flist	= 0		;
	_el_nlist	= 0		;
	_el_mname	= strdup("")	;
	_el_error	= 0		;

	/* Initialise the lexical analyser and then parse the program.	*/
	/* Check in case any errors were found and if so then exit.	*/
	el_lineno = 1 ;
	if (sstr != NULL)
		el_lex_sinit (sstr, srce != NULL ? srce : "<text string>"   ) ;
	else	el_lex_iinit (ifd,  srce != NULL ? srce : "<standard input>") ;

	el_yyrestart (stdin) ;
	el_yyparse	  () ;
	if (_el_error) goto Failed ;

	/* Now code generate. On return, check again for any errors and	*/
	/* exit if there were any.					*/
	_el_cogen () ;
	if (_el_error) goto Failed ;

	/* Output the name tables and the code. If this routine returns	*/
	/* then there were no errors.					*/
	{
		CBUFF	*cb = _el_cgdone (dest) ;
		el_in_clean  () ;
		el_syn_clean () ;
		return	cb	;
	}

	Failed	:
		el_in_clean  () ;
		el_syn_clean () ;
		return	0 ;
}
