/***************************************************************************
    file	         : kb_textlog.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qwidget.h>
#include	<qfont.h>
#include	<qfontmetrics.h>


#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_gui.h"
#include	"kb_node.h"
#include	"kb_notifier.h"
#include	"kb_viewer.h"
#include	"kbase.h"


#ifndef 	_WIN32
#include	"kb_textlog.moc"
#else
#include 	"kb_textlog.h"
#endif

/*  KBTextLog								*/
/*  KBTextLog	: Constructor for text logging windows			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  caption	: cchar *	: Caption				*/
/*  action	: KToggleAction*: Show/hide action for this window	*/
/*  (returns)	: KBTextLog	:					*/

KBTextLog::KBTextLog
	(	QWidget		*parent,
		cchar		*caption,
		TKToggleAction	*action
	)
	:
	KBasePart (0, parent, WDestructiveClose|WStyle_NormalBorder),
	log	  (new QTextView (m_partWidget)),
	action	  (action)
{
	gui	    = 0   ;
	m_topWidget = log ;

	setGUI (gui = new KBaseGUI (this, this, "rekallui.text.log")) ;

	maxln	= 100 ;
	minln	=  80 ;
	lines.setAutoDelete (true) ;
	log ->setTextFormat (Qt::RichText) ;

	QFontMetrics m (log->font()) ;
	lspace	= m.lineSpacing ()   ;

	m_partWidget->resize	(500, 300, true, false) ;
	log         ->show   	()	   ; 
	m_partWidget->show   	()	   ;
	m_partWidget->setCaption(caption ) ;

	extern	KBaseApp *kbaseApp	;
	kbaseApp  ->addViewer	(this)	;
}

/*  KBTextLog								*/
/*  ~KBTextLog	: Destructor for text logging window			*/
/*  (returns)	:		:					*/

KBTextLog::~KBTextLog ()
{
//	DELOBJ	(gui) ;
}

/*  KBTextLog	: 							*/
/*  resizeEvent	: Handle widget resize					*/
/*  e		: QResizeEvent * : Resize event				*/
/*  (returns)	: void		 :					*/

void	KBTextLog::resizeEvent
	(	QResizeEvent	*
	)
{
	QSize s = m_partWidget->size() ;
	log->setGeometry (0, 0, s.width(), s.height()) ;
}

/*  KBTextLog								*/
/*  logText	: Add text to log					*/
/*  text	: const QString & : Text				*/
/*  rc		: bool		  : Success/failure flag		*/ 
/*  (returns)	: void		  :					*/

void	KBTextLog::logText
	(	const QString	&text,
		bool		rc
	)
{
	bool	reshow	= false ;

	if (lines.count() >= maxln)
	{	while (lines.count() > minln) lines.removeFirst() ;
		reshow = true ;
	}

	/* Add thet text, in red if there was an error. It is wrapped	*/
	/* up to occupy a single line.					*/
	QString	*add = new QString	 ;
	*add	= "<nobr><font color=\"" ;
	*add   += rc ? "black" : "red"	 ;
	*add   += "\">"			 ;
	*add   += text			 ;
	*add   += " </font></nobr><br/>" ;
	lines.append (add) ;

	if (reshow)
	{
		log->setText ("") ;
		LITER (QString, lines, q, log->append (*q)) ;
	}
	else	log->append  (*add) ;

	log->ensureVisible (0, (lines.count() + 2) * lspace) ;
}

/*  KBTextLog								*/
/*  hide	: Trap window hide					*/
/*  (returns)	: void		:					*/

void	KBTextLog::hide ()
{
	KBasePart::hide  () ;

	action->setChecked (false) ;
	lines.clear 	 ()   ;
	log->setText     ("") ;
}

bool	KBTextLog::closeEvent ()
{
	return	true	;
}

