/***************************************************************************
    file	         : kb_scriptlist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qcursor.h>
#include	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_attrdict.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_dbdlg.h"
#include	"kb_script.h"
#include	"kb_prompt.h"
#include	"kb_viewer.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kbase.h"

#ifndef 	_WIN32
#include	"kb_scriptlist.moc"
#else
#include 	"kb_scriptlist.h"
#endif

#include	"tk_messagebox.h"


/*  KBScriptList							*/
/*  KBScriptList: Constructor for script list widget			*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  dbInfo	: KBDBInfo *	  : Database information object		*/
/*  language	: const QString & : Language extension			*/
/*  (returns)	: KBScriptList	  :					*/

KBScriptList::KBScriptList
	(	QWidget		*parent,
		KBDBInfo	*dbInfo,
		const QString	&language
	)
	:
	KBFileList
	(	parent,
		dbInfo,
		"Create new script",
		"script",
		"script",
		"Script name"
	),
	m_language	(language)
{
}

/*  KBScriptList							*/
/*  ~KBScriptList: Destructor for form list widget			*/
/*  (returns)	 :		:					*/

KBScriptList::~KBScriptList ()
{
}

/*  KBScriptList							*/
/*  showServerMenu: Show popup menu for server entries			*/
/*  (returns)	  : void	  :					*/

void	KBScriptList::showServerMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertSeparator () ;
	pop.insertItem (TR("&Reload script list"), this, SLOT(reloadServer())) ;
	pop.insertItem (TR("&Copy to server ..."), this, SLOT(copyToServer())) ;
	pop.exec       (QCursor::pos()) ;
}

/*  KBScriptList							*/
/*  showObjectMenu: Show popup menu for object entries			*/
/*  (returns)	  : void	  :					*/

void	KBScriptList::showObjectMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertItem (TR("&Edit script"),    this, SLOT(showAsData  ())) ;

	if (KBaseApp::getDebugIface (m_language) != 0)
		pop.insertItem
		(	TR("&Load into debugger"),
			this,
		SLOT(loadDebugger())
		)	;

	pop.insertItem (TR("&Rename script"),  this, SLOT(renameScript())) ;
	pop.insertItem (TR("De&lete script"),  this, SLOT(deleteScript())) ;
	pop.insertItem (TR("&Save to file"),   this, SLOT(saveToFile  ())) ;
	pop.exec       (QCursor::pos()) ;
}

/*  KBScriptList							*/
/*  renameScript: Rename a script					*/
/*  (returns)	: void		:					*/

void	KBScriptList::renameScript ()
{
	KBError	   error    ;
	KBLocation location ;

	if (!itemToLocation (m_curItem, location)) return ;
	if (!canOperate     (location,  "rename")) return ;


	/* Prompt the user for a new name for the script, with the	*/
	/* usual getout.						*/
	QString	newName	;
	if (!doPrompt (TR("Rename script"),
		       TR("Please enter the new script name"), newName)) return ;


	/* OK, go ahead and delete it. For files, this is handled	*/
	/* through the scripting interface so that we			*/
	/* don't need to know about things like compiled script files.	*/
	if (location.docLocn == KBLocation::m_pFile)
	{
		KBError	   error     ;
		KBScriptIF *scrIface = LinkKBScript (m_language, error) ;

		if (scrIface == 0)
		{
			error.DISPLAY () ;
			return	;
		}

		if (!scrIface->rename (location, newName, error))
		{
			error.DISPLAY () ;
		}
	}
	else
	{
		/* Database rename is handled in the normal way ...	*/
		if (!location.rename (newName, error))
			error.DISPLAY () ;
	}

	/* Reload the script list. Do this whether or not there was an	*/
	/* error; this ensures that the displayed list is correct.	*/
	objChange (location) ;
}

/*  KBScriptList							*/
/*  deleteScript: Delete a script					*/
/*  (returns)	: void		:					*/

void	KBScriptList::deleteScript ()
{
	KBError	   error    ;
	KBLocation location ;

	if (!itemToLocation (m_curItem,  location)) return ;
	if (!canOperate     (location,   "rename")) return ;


	if (TKMessageBox::questionYesNo
	   	(	0,
			QString (TR("Definitely delete script %1?")).arg(location.docName),
			TR("Delete script")
		)
		!= TKMessageBox::Yes) return ;


	/* OK, go ahead and delete it. For files, this is handled	*/
	/* through the scripting interface so that we don't need to	*/
	/* know about things like compiled script files.		*/
	if (location.docLocn == KBLocation::m_pFile)
	{
		KBError	   error     ;
		KBScriptIF *scrIface = LinkKBScript (m_language, error) ;

		if (scrIface == 0)
		{
			error.DISPLAY () ;
			return	;
		}
		if (!scrIface->unlink (location, error))
		{
			error.DISPLAY () ;
		}
	}
	else
	{
		/* Scripts store in the database are handled in the	*/
		/* default manner.					*/
		if (!location.remove (error))
			error.DISPLAY () ;
	}

	/* Reload the script list. Do this whether or not there was an	*/
	/* error; this ensures that the displayed list is correct.	*/
	objChange (location) ;
}

/*  KBScriptList							*/
/*  loadDebugger: Load script into debugger				*/
/*  (returns)	: void		:					*/

void	KBScriptList::loadDebugger ()
{
	KBError	   error    ;
	KBLocation location ;
	if (!itemToLocation (m_curItem, location)) return ;

	KBScriptIF *scrIface = KBaseApp::getDebugIface (m_language) ;
	if (scrIface == 0) return ;

	if (!scrIface->debugScript (location, error))
		error.DISPLAY () ;
}

#if	0
/*  KBScriptList								*/
/*  showDefault	: Default double-click/return operation			*/
/*  item	: QListViewItem *: Selected item			*/
/*  (returns)	: void		 :					*/

void	KBScriptList::showDefault
	(	QListViewItem *item
	)
{
	if ((m_curItem = (KBListItem *)item) == 0)
		return ;
	
	if (m_curItem->type() == KBListItem::Create)
	{
		KBError		error	 ;
		KBLocation	location (m_dbInfo, m_tabType, m_curItem->parent()->text(0), "", m_language) ;
		KBCallback	*cb	= KBAppPtr::getCallback() ;

		if (! cb->newObject (location, error)) error.DISPLAY() ;
		return	;
	}

	if (m_curItem->type() == KBListItem::Object)
	{
		showObjectAs (m_curItem, KB::ShowAsData) ;
		return	;
	}
}
#endif

/*  KBScriptList								*/
/*  getDocExtension							*/
/*		: Get document name extension				*/
/*  (returns)	: QString	: Extension				*/

QString	KBScriptList::getDocExtension ()
{
	return	m_language ;
}
