/***************************************************************************
    file	         : md5.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef auth_INCLUDED
#  define auth_INCLUDED

/*
 * This package supports both compile-time and run-time determination of CPU
 * byte order.  If ARCH_IS_BIG_ENDIAN is defined as 0, the code will be
 * compiled to run only on little-endian CPUs; if ARCH_IS_BIG_ENDIAN is
 * defined as non-zero, the code will be compiled to run only on big-endian
 * CPUs; if ARCH_IS_BIG_ENDIAN is not defined, the code will be compiled to
 * run on either big- or little-endian CPUs, but will run slightly less
 * efficiently on either one than if ARCH_IS_BIG_ENDIAN is defined.
 */

typedef unsigned char auth_byte_t; /* 8-bit byte */
typedef unsigned int auth_word_t; /* 32-bit word */

/* Define the state of the MD5 Algorithm. */
typedef struct auth_state_s {
    auth_word_t count[2];	/* message length in bits, lsw first */
    auth_word_t abcd[4];		/* digest buffer */
    auth_byte_t buf[64];		/* accumulate block */
} auth_state_t;

#ifdef __cplusplus
extern "C" 
{
#endif

/* Initialize the algorithm. */
void auth_init(auth_state_t *pms);

/* Append a string to the message. */
void auth_append(auth_state_t *pms, const auth_byte_t *data, int nbytes);

/* Finish the message and return the digest. */
void auth_finish(auth_state_t *pms, auth_byte_t digest[16]);

#ifdef __cplusplus
}  /* end extern "C" */
#endif

#endif /* auth_INCLUDED */
