/***************************************************************************
    file	         : kb_serverdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_SERVERDLG_H
#define	_KB_SERVERDLG_H


#include	<qdict.h>
#include	<qlabel.h>
#include	<qlistbox.h>
#include	<qlineedit.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qpushbutton.h>
#include	<qlayout.h>
#include	<qgroupbox.h>
#include	<qdialog.h>

#include	"kb_classes.h"
#include	"kb_serverinfo.h"
#include	"kb_serverdata.h"
#include	"kb_dbdlg.h"

#include	"tk_messagebox.h"
#include	"tk_filedialog.h"


/*  KBServerDlg								*/
/*  -----------								*/
/*  This dialog box is used to configure named server connections in	*/
/*  terms of host, database name, user and passord, and so forth.	*/
/*  push-buttons.							*/

class	KBServerDlg : public QDialog
{
	Q_OBJECT

	KBDBaseDlg	*m_dbaseDlg	;

#if	__KB_EMBEDDED
	QComboBox	m_serverList	;
#else
	QListBox	m_serverList	;
	QGroupBox	m_editGroup	;
#endif
	QWidget		m_editWidget	;
	QLineEdit	m_serverName	;
	QComboBox	m_dbType	;
	QLineEdit	m_hostName	;
	QComboBox	m_dbName	;
	QLineEdit	m_userName	;
	QLineEdit	m_password	;
	QLineEdit	m_portNumber	;
	QLineEdit	m_socketName	;
	QLineEdit	m_flags		;
	QCheckBox	m_showPwd	;
	QCheckBox	m_disabled	;
	QCheckBox	m_autostart	;

	QPushButton	m_bEdit		;
	QPushButton	m_bAdvanced	;
	QPushButton	m_bSave		;
	QPushButton	m_bNew		;
	QPushButton	m_bCancel	;
	QPushButton	m_bDelete	;
	QPushButton	m_bDatabases	;

	int		m_currIndex	;
	KBServerData	*m_currServer	;
	KBServerData	*m_editServer	;
	KBDBInfoData	*m_dbInfo	;

	void		clearServerInfo		()	;
	void		showServerInfo		(KBServerData  *, bool) ;
	bool		showServerType		(KBServerData  *) ;
	void		showServer   		(int)	;

	void		loadDBInfo		()	;
	void		setEnabledAll		(bool, bool, uint = 0) ;
	bool		autoStartForm		(KBServerInfo   *, KBLocation &) ;

private slots :

	void		clickEdit		()	;
	void		clickAdvanced		()	;
	void		clickSave		()	;
	void		clickNew		()	;
	void		clickCancel		()	;
	void		clickDelete		()	;
	void		showPassword		(bool)	;
	void		typeChange		()	;
	void		showServer		()	;
	void		showDatabases		()	;

public	:

	KBServerDlg (KBDBaseDlg *, KBDBInfoData *, KBaseGUI *) ;
       ~KBServerDlg () ;

	bool		autoStart 		(KBLocation &) ;
	void		showRawSQL		(KBaseApp   *) ;
#if	! __KB_RUNTIME
	void		dumpDatabase		(KBaseApp   *) ;
	void		loadDatabase		(KBaseApp   *) ;
#endif
}	;

#endif	// _KB_SERVERDLG_H
