/***************************************************************************
    file	         : kb_unisql.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/


#ifndef	__KB_UNISQL_H
#define	__KB_UNISQL_H

#include	<qarray.h>
#include	<qstring.h>
#include	<qdict.h>
#include	<qintdict.h>
#include	<qsocket.h>
#include	<qdialog.h>
#include	<qxml.h>



#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_databuffer.h"
#include	"kb_database.h"
#include	"kb_serverinfo.h"
#include	"kb_build.h"

#define		_C(x)	(char *)(const char *)(x)


/*  UniColInfo								*/
/*  ----------								*/
/*  Class used to hold column information as extracted from reply from	*/
/*  UniverSQL server.							*/

class	UniColInfo
{
public	:

	int		m_slot		;

	QString		m_name		;
	QString		m_tag		;
	QString		m_type		;
	int		m_length	;
	bool		m_nullable	;
	bool		m_autoinc	;
	bool		m_keycol	;

	inline	UniColInfo	()
	{
		m_slot		= 0	;
		m_length	= 0	;
		m_nullable	= false	;
		m_autoinc	= false	;
		m_keycol	= false	;
	}
}	;


/*  KBUniSQLParser							*/
/*  --------------							*/
/*  Parser for replies from UniverSQL server. Also used to store the	*/
/*  results extracted from the reply.					*/

class	KBUniSQLParser : public QXmlDefaultHandler
{
public	:

	enum	State
	{
		Start,
		Result,
		ColumnInfo,
		ColumnInfoDetail,
		RowData,
		ErrorData,
		Error
	}	;

private	:

	State			m_state		;
	UniColInfo		m_dummy		;
	QValueList<UniColInfo>	m_columns	;
	QDict     <UniColInfo>	m_colMap	;
	UniColInfo		*m_curCol	;
	QValueList<QStringList>	m_values	;
	QString			m_error		;

	cchar		*state		()	;

	virtual	bool	characters	(const QString &) ;
	virtual	bool	startElement	(const QString &, const QString &, const QString &, const QXmlAttributes &) ;
	virtual	bool	endElement	(const QString &, const QString &, const QString &) ;

public	:

	bool		parseText	(QByteArray	  &) ;

	inline	uint	rows	()
	{
		return	m_values.count() ;
	}
	inline	uint	columns	()
	{
		return	m_values.count() == 0 ?
				m_columns  .count() :
				m_values[0].count() ;
	}
	inline	const	QString	&value
			(	uint	row,
				uint	col
			)
	{
		return	m_values[row][col] ;
	}

	inline	const	QString	&name	(uint	col) { return m_columns[col].m_name	; }
	inline	const	QString	&type	(uint	col) { return m_columns[col].m_type	; }
	inline	int		length	(uint	col) { return m_columns[col].m_length	; }
	inline	bool		nullable(uint	col) { return m_columns[col].m_nullable	; }
	inline	bool		autoinc	(uint	col) { return m_columns[col].m_autoinc	; }
	inline	bool		keycol	(uint	col) { return m_columns[col].m_keycol	; }

	inline	bool	error
		(	QString	&msg
		)
	{
		msg	= m_error ;
		return	m_state == Error ;
	}
}	;

/*  ------------------------------------------------------------------  */

/*  UniSQLTypeMap							*/
/*  -------------							*/
/*  Entry structure for UniverSQL <-> Rekall type mapping		*/

struct	UniSQLTypeMap
{	cchar		*ident		;	/* UniSQL identifier	*/
	KB::IType	itype		;	/* Internal type	*/
	char		mtype	[16]	;	/* UniSQL type name	*/
	uint		flags		;	/* Various flags	*/
}	;

/*  ------------------------------------------------------------------  */

/*  KBUniSQLType								*/
/*  -----------								*/

class	KBUniSQLType : public KBType
{
	UniSQLTypeMap	*m_typeInfo	;

public	:

	KBUniSQLType  (UniSQLTypeMap *, uint, uint, bool) ;

	virtual	bool    isValid      (const QString &, KBError  &, const QString & = QString::null) ;
	virtual	void	getQueryText (KBDataArray   *, KBShared *, KBDataBuffer  &) ;
}	;


/*  ------------------------------------------------------------------  */

/*  KBUniSQL								*/
/*  -------								*/
/*  Implementation class for insertface to the UniSQL database		*/

class	KBUniSQL : public KBServer
{
	QSocket			m_connection	;
	QString			m_name		;
	QString			m_host		;
	int			m_port		;
	QString			m_dsn		;
	bool			m_connected	;
	bool			m_readOnly	;

	bool			m_rekallTables	;
	UniSQLTypeMap		*m_typeMap	;
	QDict<UniSQLTypeMap>	m_dIdentToType	;

//	bool			m_mapCRLF	;
//	bool			m_showSysTables	;
	bool			m_mapExpressions;
//	QString			m_odbcType	;

	bool			doListTablesSys	(KBTableDetailsList &, bool, uint = KB::IsAny) ;
	bool			doListTablesRkl (KBTableDetailsList &, bool, uint = KB::IsAny) ;
	bool			doListFieldsSys	(KBTableSpec   &) ;
	bool			doListFieldsRkl	(KBTableSpec   &) ;

	bool			makeConnection	(bool, KBError &) ;

protected :

	virtual	bool	 	doConnect    	(KBServerInfo  *) ;
	virtual	bool		doListTables 	(KBTableDetailsList &, uint = KB::IsAny) ;
	virtual	bool		doListFields 	(KBTableSpec   &) ;
	virtual	bool		doCreateTable	(KBTableSpec   &,  bool, bool = false) ;
	virtual	bool		doRenameTable	(cchar *, cchar *, bool) ;
	virtual	bool		doDropTable  	(cchar *,	   bool) ;

public	:

	KBUniSQL	() ;
virtual~KBUniSQL () ;


	virtual	KBSQLSelect	*qrySelect 	(bool, const QString &, bool) ;
	virtual	KBSQLUpdate	*qryUpdate 	(bool, const QString &, const QString &) ;
	virtual	KBSQLInsert	*qryInsert 	(bool, const QString &, const QString &) ;
	virtual	KBSQLDelete	*qryDelete 	(bool, const QString &, const QString &) ;

	virtual	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect ** = 0) ;

	virtual	QString		listTypes	() ;
	virtual	QString		mapExpression	(const QString &) ;
	virtual	bool		tableExists	(const QString &, bool &) ;

	KBUniSQLParser	*execSQL
			(	const QString	&,
				QString		&,
				uint		,
				const KBValue	*,
				QTextCodec	*,
				cchar		*,
				KBError		&,
				bool		= false
			)	;

}	;


/*  ------------------------------------------------------------------  */

/*  KBUniSQLQrySelect							*/
/*  ----------------							*/
/*  Implementation class for select queries on the UniSQL database	*/

class	KBUniSQLQrySelect : public KBSQLSelect
{
	KBUniSQL	*m_server	;
	QStringList	m_fields	;
	KBUniSQLParser	*m_parser	;

public	:
	KBUniSQLQrySelect (KBUniSQL *, bool, const QString &) ;
	KBUniSQLQrySelect (KBUniSQL *, bool, const QString &, KBUniSQLParser *) ;
virtual~KBUniSQLQrySelect () ;

	virtual	bool	execute		(uint, const KBValue *) ;
	virtual	KBValue	getField	(uint, uint, KBValue::VTrans) ;
	virtual	QString	getFieldName	(uint) ;
}	;


/*  KBUniSQLQryUpdate							*/
/*  ----------------							*/
/*  Implementation class for update queries on the UniSQL database	*/

class	KBUniSQLQryUpdate : public KBSQLUpdate
{
	KBUniSQL	*m_server	;

public	:
	KBUniSQLQryUpdate (KBUniSQL *, bool, const QString &, const QString &) ;
virtual~KBUniSQLQryUpdate () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;

}	;

/*  KBUniSQLQryInsert							*/
/*  ----------------							*/
/*  Implementation class for insert queries on the UniSQL database	*/

class	KBUniSQLQryInsert : public KBSQLInsert
{
	KBUniSQL	*m_server	;
	QString		m_autocol	;
	KBValue		m_newKey	;

public	:
	KBUniSQLQryInsert (KBUniSQL *, bool, const QString &, const QString &) ;
virtual~KBUniSQLQryInsert () ;

	virtual	bool	execute	  (uint, const KBValue *) ;
	virtual	bool	getNewKey (const QString &, KBValue &, bool) ;
}	;

/*  KBUniSQLQryDelete							*/
/*  ----------------							*/
/*  Implementation class for delete queries on the UniSQL database	*/

class	KBUniSQLQryDelete : public KBSQLDelete
{
	KBUniSQL		*m_server	;

public	:
	KBUniSQLQryDelete (KBUniSQL *, bool, const QString &, const QString &) ;
virtual~KBUniSQLQryDelete () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;

/*  ------------------------------------------------------------------  */

class	KBUniSQLConnect : public QDialog
{
	Q_OBJECT

	QLabel		m_lStatus	;
	QPushButton	m_bCancel	;
	QSocket		&m_socket	;
	QString		m_host		;
	int		m_port		;

private slots :

	void	slotError	(int)	;
	void	slotConnected	()	;
	void	slotClosed	()	;
	void	slotHostFound	()	;
	void	slotCancel	()	;

public	:

	KBUniSQLConnect		(QSocket &, const QString &, int) ;
	~KBUniSQLConnect	()	;

	int	exec		()	;
}	;

#endif	// __KB_UNISQL_H
