/***************************************************************************
    file	         : kb_checkodbc.cpp
    copyright            : (C) 1999,2000,2001 by Mike Richardson
			   (C) 2000,2001 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/



/*  checkRCOK	: Check whether SQL statement executed correctly	*/
/*  stmHandle	: SQLHSTMT	: Statement handle			*/
/*  db2cliRC	: long		: ODBC return code			*/
/*  where	: cchar *	: First text string for possible error	*/
/*  htype	: SQLSMALLINT	: Handle type				*/
/*  pError	: KBError &	: Error return location			*/
/*  (returns)	: bool		: True if statement executed correctly	*/

static	bool	checkRCOK
	(	SQLHSTMT	stmHandle,
		SQLRETURN	odbcRC,
		cchar		*where,
		SQLSMALLINT	htype,
		KBError		&pError
	)
{
	if (SQL_SUCCEEDED(odbcRC)) return true ;

	fprintf
	(	stderr,
		DBTAG "::checkODBCOK: %d (%s)\n",
		(int)odbcRC,
		where
	)	;

	/* Check for the invalid handle error and treat this specially	*/
	/* since calling SQLGetDiagRec in this situation will fail.	*/
	if (odbcRC == SQL_INVALID_HANDLE)
	{
		pError	= KBError
			  (	KBError::Error,
				TR(where),
				"Invalid handle",
				__ERRLOCN
			  )	;
		return	false	;
	}

	char		message[SQL_MAX_MESSAGE_LENGTH] ;
	char 		status [6]	;
	SQLINTEGER	error		;
	SQLSMALLINT	msglen		;
	SQLRETURN	rc		;
	SQLSMALLINT	recNo	= 1	;
	bool		checkRC	= true	;
	QString		errmsg		;

	/* Loop retrieving the diagnostic records, which are assembed	*/
	/* into "errmsg". The return code is set false as soon as we	*/
	/* hit an status with *is not* inormational.			*/
	for (;;)
	{		
		rc = SQLGetDiagRec
		     (		htype,
				stmHandle,
				recNo,
				(SQLCHAR *)status,
				&error, 
				(SQLCHAR *)message,
				sizeof(message)/2 - 1,
				&msglen
		     )	;

		if (!SQL_SUCCEEDED(rc)) break ;

		fprintf
		(	stderr,
			DBTAG "::checkodbcOK: %d %d [%s] [%.48s]\n",
			(int)recNo,
			(int)msglen,
			status,
			message
		)	;


		if (msglen >= (int)sizeof(message)) msglen = sizeof(message) - 1 ;
		message[msglen] = 0;

		if (!errmsg.isEmpty()) errmsg += "<br>" ;
		errmsg += message ;

		if ((status[0] != 'I') || (status[1] != 'M'))
			checkRC	= false	;

		recNo	+= 1 ;
	}

//	fprintf
//	(	stderr,
//		DBTAG "::checkodbcOK -> [%d]\n",
//		checkRC
//	)	;

	if (!checkRC)
		pError	= KBError
			  (	KBError::Error,
				TR(where),
				errmsg,
				__ERRLOCN
			  )	;
	return checkRC	;
}

/*  checkDataOK	: Check whether SQL statement executed correctly	*/
/*		: Allows SQL_NO_DATA as OK (eg., update and delete)	*/
/*  stmHandle	: SQLHSTMT	: Statement handle			*/
/*  db2cliRC	: long		: ODBC return code			*/
/*  where	: cchar *	: First text string for possible error	*/
/*  pError	: KBError &	: Error return location			*/
/*  (returns)	: bool		: True if statement executed correctly	*/

static	bool	checkDataOK
	(	SQLHSTMT	stmHandle,
		SQLRETURN	odbcRC,
		cchar		*where,
		KBError		&pError
	)
{
	return	odbcRC == SQL_NO_DATA ?
			true :
			::checkRCOK (stmHandle, odbcRC, where, SQL_HANDLE_STMT, pError) ;
}

