/***************************************************************************
    file	         : kb_pgsql.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PGSQL_H
#define	__KB_PGSQL_H


/*  PgSQLTypeMap							*/
/*  ------------							*/
/*  This structure is used to map between PostgreSQL Oid identifiers	*/
/*  and type names, and KBase internal types. The length field contains	*/
/*  the size (precision or length) of the PostgreSQL type.		*/

struct	PgSQLTypeMap
{	Oid		oid		;	/* PgSQL identifier	*/
	KB::IType	itype		;	/* KBase internal	*/
	char		ptype	[16]	;	/* Description		*/
	uint		flags		;	/* Various flags	*/
}	TypeMap	;


/*  KBPgSQLType								*/
/*  -----------								*/
/*  This is the derived type for rhe PostgreSQL interface. It stores	*/
/*  the PGSQL type Oid as well as the internal type.			*/

class	KBPgSQLType : public KBType
{
	PgSQLTypeMap	*m_typeInfo ;

public	:

	KBPgSQLType (PgSQLTypeMap *, uint, uint, bool) ;

	virtual	bool    isValid      (const QString &, KBError  &, const QString & = QString::null) ;
	virtual	void	getQueryText (KBDataArray   *, KBShared *, KBDataBuffer  &, QTextCodec * = 0) ;
}	;

/*  KBPgSQL								*/
/*  -------								*/
/*  Implementation class for the interface to the PostgreSQL database	*/

class	KBPgSQL : public KBServer
{
	QString		m_socket		;
	QString		m_flags			;
	PGconn		*m_pgConn		;

	bool		m_primaryIsSerial	;
	bool		m_ignoreUser		;
	bool		m_showPgSQLObjects	;
	bool		m_logInternal		;
	bool		m_requireSSL		;
	bool		m_caseInsensitive	;
	bool		m_mapExpressions	;
	bool		m_useTimeouts		;
	uint		m_stmtTimeout		;
	uint		m_lockTimeout		;
	bool		m_readOnly		;

	bool		m_grants		;
	bool		m_grantSelect		;
	bool		m_grantInsert		;
	bool		m_grantUpdate		;
	bool		m_grantDelete		;
	QString		m_grantTo		;
	bool		m_grantPopup		;

	void		*m_activeCookie		;

	bool		doGrants	(const QString &, const QString &, const QString &) ;
	bool		tblCreateSQL	(QList<KBFieldSpec> &,  const QString &, QString &, bool) ;
	bool		listForType	(KBTableDetailsList &,  const QString &, KB::TableType, uint) ;

	cchar		*m_opMap[(int)KBServer::Like + 1] ;

protected :

	virtual	bool	 	doConnect	(KBServerInfo  *) ;
	virtual	bool		doListTables 	(KBTableDetailsList &, uint = KB::IsAny) ;
	virtual	bool		doListFields 	(KBTableSpec   &) ;
	virtual	bool		doCreateTable	(KBTableSpec   &,  bool, bool = false) ;
	virtual	bool		doRenameTable	(cchar *, cchar *, bool) ;
	virtual	bool		doDropTable  	(cchar *,	   bool) ;

public	:
	KBPgSQL	() ;
virtual~KBPgSQL () ;

	bool			objectExists (const QString &, cchar *, bool &) ;


	PGresult		*execSQL
				(	const QString	&,
					QString 	&,
					uint,
					const KBValue 	*,
					QTextCodec	*,
					const QString	&,
					ExecStatusType	,
					KBError 	&,
					bool		= false
				) ;

	bool			execSQL
				(	const QString	&,
					const QString	&,
					ExecStatusType	,
					bool		= false
				) ;

	virtual	bool		viewExists	(const QString &, bool &) ;
	virtual bool		createView	(KBTableSpec    &) ;
	virtual bool		renameView	(cchar *, cchar *) ;
	virtual bool		dropView	(cchar *) ;

	virtual	bool		sequenceExists	(const QString &, bool &) ;
	virtual bool		descSequence	(KBSequenceSpec &) ;
	virtual bool		createSequence	(KBSequenceSpec &) ;
	virtual bool		renameSequence	(cchar *, cchar *) ;
	virtual bool		dropSequence	(cchar *) ;


	virtual	KBSQLSelect	*qrySelect	(bool, const QString &, bool) ;
	virtual	KBSQLUpdate	*qryUpdate	(bool, const QString &, const QString &) ;
	virtual	KBSQLInsert	*qryInsert	(bool, const QString &, const QString &) ;
	virtual	KBSQLDelete	*qryDelete	(bool, const QString &, const QString &) ;
	virtual	KBSQLCursor	*qryCursor	(bool, const QString &, const QString &) ;

	virtual	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect ** = 0) ;
	virtual	bool		transaction	(Transaction, void **) ;

	virtual bool		listDatabases	(QStringList &) ;
	virtual	QString		listTypes	() ;
	virtual	bool		tableExists	(const QString &, bool &) ;
	virtual	bool		keepsCase  	() ;
	virtual	uint 		optionFlags	() ;
	virtual	QString		mapExpression	(const QString &) ;
	virtual	uint		operatorMap	(cchar **&) ;
	virtual	bool		getSyntax	(QString &, KBServer::Syntax, ...) ;

	bool			setLockTimeout	(KBError &) ;
	bool			setStmtTimeout	(KBError &) ;

	friend	class	KBPgSQLQryInsert	;
}	;


/*  KBPgSQLQrySelect							*/
/*  ----------------							*/
/*  Implementation class for select queries on the PgSQL database	*/

class	KBPgSQLQrySelect : public KBSQLSelect
{
	PGresult	*m_pgQry	;
	KBPgSQL		*m_server	;
	bool		m_update	;

public	:

	KBPgSQLQrySelect (KBPgSQL *, bool, const QString &, bool) ;
virtual~KBPgSQLQrySelect () ;

	virtual	bool	execute		(uint, const KBValue * ) ;
	virtual	KBValue	getField	(uint, uint, KBValue::VTrans) ;
	virtual	QString	getFieldName	(uint)	     ;
}	;


/*  KBPgSQLQryUpdate							*/
/*  ----------------							*/
/*  Implementation class for update queries on the PgSQL database	*/

class	KBPgSQLQryUpdate : public KBSQLUpdate
{
	KBPgSQL			*m_server	;
	bool			m_isView	;

public	:
	KBPgSQLQryUpdate (KBPgSQL *, bool, const QString &, const QString &) ;
virtual~KBPgSQLQryUpdate () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;

/*  KBPgSQLQryInsert							*/
/*  ----------------							*/
/*  Implementation class for insert queries on the PgSQL database	*/

class	KBPgSQLQryInsert : public KBSQLInsert
{
	KBPgSQL			*m_server	;
	int			m_usePKey	;
	QString			m_lastOid	;

public	:
	KBPgSQLQryInsert (KBPgSQL *, bool, const QString &, const QString &) ;
virtual~KBPgSQLQryInsert () ;

	virtual	bool	execute	   (uint, const KBValue *) ;
	virtual	bool	getNewKey  (const QString &, KBValue &, bool) ;
}	;

/*  KBPgSQLQryDelete							*/
/*  ----------------							*/
/*  Implementation class for delete queries on the PgSQL database	*/

class	KBPgSQLQryDelete : public KBSQLDelete
{
	KBPgSQL			*m_server	;

public	:
	KBPgSQLQryDelete (KBPgSQL *, bool, const QString &, const QString &) ;
virtual~KBPgSQLQryDelete () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;

/*  KBPgSQLQryCursor							*/
/*  ----------------							*/
/*  The KBPqSQLQryCursor class is used for PostgreSQL cursors		*/

class	KBPgSQLQryCursor : public KBSQLCursor
{
	KBPgSQL			*m_server	;

public	:

	KBPgSQLQryCursor (KBPgSQL *, bool, const QString &, const QString &) ;
	virtual ~KBPgSQLQryCursor ()	;

	virtual	bool	execute	(uint, const KBValue   *) ;
	virtual	bool	update	(const QString &, uint, const KBValue *) ;
	virtual	bool	fetch	(uint, KBValue *, bool &) ;
	virtual	bool	close	()			  ;
}	;


static	QIntDict<PgSQLTypeMap>	dOidToType	;
static	QDict   <KBPgSQLType >  typesDict	;


#endif	// __KB_PGSQL_H
